/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JPanel;
import protex.AcidInChain;
import protex.ColorCoder;
import protex.Grid;
import protex.GridPoint;
import protex.OutputPalette;
import protex.Polypeptide;
import protex.Protex;
import protex.ShadingColorCoder;
import protex.SsBond;

public abstract class GridCanvas
extends JPanel {
    protected int cellRadius = 20;
    protected int cellDiameter = 2 * this.cellRadius;
    protected int size;
    protected Grid grid = null;
    protected int numAcids;
    protected Polypeptide pp;
    private JPanel parentPanel;
    private Dimension requiredCanvasSize = new Dimension(0, 0);
    private boolean strictMatchDisplayMode;

    public GridCanvas(int width, int height) {
        this();
        this.setSize(width, height);
        this.strictMatchDisplayMode = false;
    }

    public GridCanvas() {
    }

    public Dimension getRequiredCanvasSize() {
        this.calculateRequiredCanvasSize();
        return this.requiredCanvasSize;
    }

    protected void setGrid(Grid grid) {
        this.grid = grid;
        this.size = grid.getSize();
        this.pp = grid.getPP();
        this.numAcids = this.pp.getLength();
    }

    public void setStrictMatchDisplayMode(boolean b) {
        this.strictMatchDisplayMode = b;
    }

    protected Grid getGrid() {
        return this.grid;
    }

    protected GridPoint getMin() {
        int minX = this.size;
        int minY = this.size;
        int minZ = this.size;
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.pp.getAminoAcid(i);
            if (a.xyz.x < minX) {
                minX = a.xyz.x;
            }
            if (a.xyz.y < minY) {
                minY = a.xyz.y;
            }
            if (a.xyz.z < minZ) {
                minZ = a.xyz.z;
            }
            ++i;
        }
        return new GridPoint(minX - 1, minY - 1, minZ - 1);
    }

    private GridPoint getMin(GridPoint[] points) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int i = 0;
        while (i < points.length) {
            if (points[i].x < minX) {
                minX = points[i].x;
            }
            if (points[i].y < minY) {
                minY = points[i].y;
            }
            if (points[i].z < minZ) {
                minZ = points[i].z;
            }
            ++i;
        }
        return new GridPoint(minX - this.cellDiameter, minY - this.cellDiameter, minZ);
    }

    protected GridPoint getMax() {
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.pp.getAminoAcid(i);
            if (a.xyz.x > maxX) {
                maxX = a.xyz.x;
            }
            if (a.xyz.y > maxY) {
                maxY = a.xyz.y;
            }
            if (a.xyz.z > maxZ) {
                maxZ = a.xyz.z;
            }
            ++i;
        }
        return new GridPoint(maxX, maxY, maxZ);
    }

    protected abstract GridPoint project(GridPoint var1);

    protected int getAcidRadius() {
        return this.cellRadius;
    }

    protected int getStringIndentationConstant(String name, int r) {
        int length = name.trim().length();
        if (length == 1) {
            return 0;
        }
        if (length == 2) {
            return 0;
        }
        if (length == 3) {
            return (int)(0.125f * (float)r);
        }
        if (length == 4) {
            return (int)(0.5f * (float)r);
        }
        if (length == 5) {
            return (int)(0.6666667f * (float)r);
        }
        return (int)(0.75f * (float)r);
    }

    public void setParentPanel(JPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    @Override
    public void paint(Graphics g) {
        AcidInChain a;
        if (this.grid == null) {
            return;
        }
        boolean buildTargetShapeMode = false;
        if (this.parentPanel == null) {
            buildTargetShapeMode = true;
        }
        this.calculateRequiredCanvasSize();
        this.setPreferredSize(this.requiredCanvasSize);
        if (!buildTargetShapeMode) {
            ((OutputPalette)this.parentPanel).getDimension().width = this.requiredCanvasSize.width;
            ((OutputPalette)this.parentPanel).getDimension().height = this.requiredCanvasSize.height;
            this.revalidate();
        }
        super.paintComponent(g);
        ShadingColorCoder cc = null;
        if (!buildTargetShapeMode) {
            if (((OutputPalette)this.parentPanel).getssBondsOn()) {
                this.setBackground(Protex.SS_BONDS_ON_BACKGROUND);
                cc = new ShadingColorCoder(this.pp.getTable().getContrastScaler());
                g.setColor(Protex.SS_BONDS_ON_BACKGROUND);
                g.fillRect(0, 0, this.requiredCanvasSize.width, this.requiredCanvasSize.height);
            } else {
                this.setBackground(Protex.SS_BONDS_OFF_BACKGROUND);
                cc = new ShadingColorCoder(this.pp.getTable().getContrastScaler());
                g.setColor(Protex.SS_BONDS_OFF_BACKGROUND);
                g.fillRect(0, 0, this.requiredCanvasSize.width, this.requiredCanvasSize.height);
            }
        } else {
            this.setBackground(Color.WHITE);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.requiredCanvasSize.width, this.requiredCanvasSize.height);
        }
        GridPoint[] spots = new GridPoint[this.numAcids];
        AcidInChain[] acidsByZ = new AcidInChain[this.numAcids];
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a2 = this.pp.getAminoAcid(i);
            spots[i] = this.project(a2.xyz);
            acidsByZ[i] = a2;
            ++i;
        }
        GridPoint min = this.getMin(spots);
        int i2 = 0;
        while (i2 < this.numAcids) {
            spots[i2] = spots[i2].subtract(min);
            ++i2;
        }
        Arrays.sort(acidsByZ, new SortByZ());
        int r = this.getAcidRadius();
        int i3 = 0;
        while (i3 < this.numAcids) {
            a = acidsByZ[i3];
            GridPoint here = this.project(a.xyz).subtract(min);
            if (a.getAbName().equals("X")) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(((ColorCoder)cc).getCellColor(a.getNormalizedHydrophobicIndex()));
            }
            g.fillOval(here.x - r, here.y - r, 2 * r, 2 * r);
            ++i3;
        }
        g.setColor(Color.red);
        i3 = 0;
        while (i3 < this.numAcids) {
            a = this.pp.getAminoAcid(i3);
            int offset = this.getStringIndentationConstant(a.name, r);
            g.setColor(Color.white);
            if (a.getName().equals("Arg") || a.getName().equals("Lys") || a.getName().equals("His")) {
                g.setColor(Color.blue);
                g.drawString("+", spots[i3].x - 15, spots[i3].y);
                g.setColor(Color.black);
            }
            if (a.getName().equals("Asp") || a.getName().equals("Glu")) {
                g.setColor(Color.red);
                g.drawString("-", spots[i3].x - 15, spots[i3].y);
                g.setColor(Color.black);
            }
            if (a.getName().equals("Asn") || a.getName().equals("Gln") || a.getName().equals("Ser") || a.getName().equals("Thr") || a.getName().equals("Tyr")) {
                g.setColor(Color.green);
                g.drawString("*", spots[i3].x - 15, spots[i3].y);
                g.setColor(Color.BLACK);
            }
            if (a.getAbName().equals("X")) {
                if (this.strictMatchDisplayMode) {
                    g.drawString(Integer.toString(a.getIndex() + 1), spots[i3].x - offset, spots[i3].y);
                }
            } else {
                g.drawString(a.name, spots[i3].x - offset, spots[i3].y);
                g.drawString(a.getAbName(), spots[i3].x - 2, spots[i3].y + 12);
            }
            g.setColor(Color.magenta);
            if ((this.strictMatchDisplayMode || !buildTargetShapeMode) && i3 < this.numAcids - 1) {
                g.drawLine(spots[i3].x, spots[i3].y, spots[i3 + 1].x, spots[i3 + 1].y);
            }
            ++i3;
        }
        if (this.parentPanel != null && ((OutputPalette)this.parentPanel).getssBondsOn() && this.grid.getssBondList().size() != 0) {
            g.setColor(Color.yellow);
            ArrayList ssBondList = this.grid.getssBondList();
            int i4 = 0;
            while (i4 < ssBondList.size()) {
                int first = ((SsBond)ssBondList.get(i4)).getFirst();
                int second = ((SsBond)ssBondList.get(i4)).getSecond();
                g.drawLine(spots[first].x, spots[first].y, spots[second].x, spots[second].y);
                ++i4;
            }
        }
    }

    public void calculateRequiredCanvasSize() {
        if (this.grid == null) {
            return;
        }
        GridPoint[] spots = new GridPoint[this.numAcids];
        AcidInChain[] acidsByZ = new AcidInChain[this.numAcids];
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.pp.getAminoAcid(i);
            spots[i] = this.project(a.xyz);
            acidsByZ[i] = a;
            ++i;
        }
        GridPoint min = this.getMin(spots);
        int i2 = 0;
        while (i2 < this.numAcids) {
            spots[i2] = spots[i2].subtract(min);
            ++i2;
        }
        Arrays.sort(acidsByZ, new SortByZ());
        GridPoint here = null;
        int maxX = 0;
        int maxY = 0;
        int i3 = 0;
        while (i3 < this.numAcids) {
            AcidInChain a = acidsByZ[i3];
            here = this.project(a.xyz).subtract(min);
            if (i3 == 0) {
                maxX = here.x;
                maxY = here.y;
            } else {
                if (here.x > maxX) {
                    maxX = here.x;
                }
                if (here.y > maxY) {
                    maxY = here.y;
                }
            }
            ++i3;
        }
        this.requiredCanvasSize = new Dimension(maxX + 2 * this.cellDiameter, maxY + 2 * this.cellDiameter);
    }

    private void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
    }

    private void paintEmpties(Graphics g) {
        g.setColor(Color.black);
        int row = 0;
        while (row < this.size) {
            int rowstart = row <= this.numAcids ? this.numAcids - row : 0;
            int rowend = row <= this.numAcids ? this.size : this.size - row + this.numAcids;
            int col = rowstart;
            while (col < rowend) {
                GridPoint gridPoint = new GridPoint(row, col);
                ++col;
            }
            ++row;
        }
    }

    private class SortByZ
    implements Comparator {
        private SortByZ() {
        }

        public int compare(Object o1, Object o2) {
            AcidInChain a1 = (AcidInChain)o1;
            AcidInChain a2 = (AcidInChain)o2;
            return a1.xyz.z - a2.xyz.z;
        }
    }
}

