/*
 * Decompiled with CFR 0.152.
 */
package protex;

import protex.AcidInChain;
import protex.Attributes;
import protex.Direction;
import protex.FoldingException;
import protex.FoldingManager;
import protex.GridPoint;
import protex.HexGrid;
import protex.OutputPalette;
import protex.ProteinImageFactory;

public class ShapeMatcher {
    private String targetString;
    private boolean strictMode;
    private Direction[] targetDirections;
    private GridPoint targetMin;
    private GridPoint targetMax;
    private int targetWidth;
    private int targetHeight;
    private GridPoint[] targetPoints;

    public ShapeMatcher(String targetString, boolean strictMode) {
        this.strictMode = strictMode;
        this.targetString = targetString;
        String[] targetStringParts = targetString.split(";");
        this.targetDirections = new Direction[targetStringParts.length];
        int i = 0;
        while (i < targetStringParts.length) {
            this.targetDirections[i] = Direction.getDirection(targetStringParts[i]);
            ++i;
        }
        HexGrid targetGrid = ProteinImageFactory.layoutOntoHexGrid(this.targetDirections);
        AcidInChain[] targetAcids = targetGrid.getPP().getAcidArray();
        this.targetMax = targetGrid.getMax();
        this.targetMin = targetGrid.getMin();
        this.targetWidth = this.targetMax.x - this.targetMin.x;
        this.targetHeight = this.targetMax.y - this.targetMin.y;
        this.targetPoints = new GridPoint[targetAcids.length];
        int i2 = 0;
        while (i2 < this.targetPoints.length) {
            this.targetPoints[i2] = targetAcids[i2].xyz;
            ++i2;
        }
    }

    public boolean matchesTarget(String guess) {
        guess = guess.trim();
        String[] guessStrings = guess.split(";");
        Direction[] guessDirections = new Direction[guessStrings.length];
        int i = 0;
        while (i < guessStrings.length) {
            guessDirections[i] = Direction.getDirection(guessStrings[i]);
            ++i;
        }
        if (guessDirections.length != this.targetDirections.length) {
            return false;
        }
        if (this.strictMode) {
            i = 0;
            while (i < guessDirections.length) {
                if (guessDirections[i] != this.targetDirections[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        i = 0;
        while (i < 6) {
            if (this.isSameShape(guessDirections)) {
                return true;
            }
            int j = 0;
            while (j < guessDirections.length) {
                guessDirections[j] = Direction.increment(guessDirections[j]);
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean isSameShape(Direction[] guessDirections) {
        HexGrid guessGrid = ProteinImageFactory.layoutOntoHexGrid(guessDirections);
        AcidInChain[] guessAcids = guessGrid.getPP().getAcidArray();
        GridPoint guessMax = guessGrid.getMax();
        GridPoint guessMin = guessGrid.getMin();
        int guessWidth = guessMax.x - guessMin.x;
        int guessHeight = guessMax.y - guessMin.y;
        if (guessWidth != this.targetWidth || guessHeight != this.targetHeight) {
            return false;
        }
        GridPoint[] guessPoints = new GridPoint[this.targetPoints.length];
        int i = 0;
        while (i < this.targetPoints.length) {
            guessPoints[i] = guessAcids[i].xyz;
            ++i;
        }
        int xOffset = guessMin.x - this.targetMin.x;
        int yOffset = guessMin.y - this.targetMin.y;
        int i2 = 0;
        while (i2 < this.targetPoints.length) {
            boolean foundAMatch = false;
            int j = 0;
            while (j < guessPoints.length) {
                if (guessPoints[j].x - xOffset == this.targetPoints[i2].x && guessPoints[j].y - yOffset == this.targetPoints[i2].y) {
                    foundAMatch = true;
                    break;
                }
                ++j;
            }
            if (!foundAMatch) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static void main(String[] args) {
        String guessAASeq = args[0];
        String targetFoldingString = args[1];
        FoldingManager manager = FoldingManager.getInstance();
        Attributes attributes = new Attributes(guessAASeq.trim(), false, 1, "0.0", "straight", "test");
        OutputPalette outputPalette = new OutputPalette();
        try {
            manager.fold(attributes);
        }
        catch (FoldingException e) {
            e.printStackTrace();
        }
        manager.createCanvas(outputPalette);
        outputPalette.getDrawingPane().getRequiredCanvasSize();
        outputPalette.setssBondsOn(false);
        String guessFoldingString = outputPalette.getDrawingPane().getGrid().getPP().getDirectionSequence();
        System.out.println("guess=" + guessFoldingString);
        ShapeMatcher shapeMatcher = new ShapeMatcher(targetFoldingString, false);
        if (shapeMatcher.matchesTarget(guessFoldingString)) {
            System.out.println("match=Y");
        } else {
            System.out.println("match=N");
        }
    }
}

