/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import protex.AminoAcid;
import protex.Direction;
import protex.GridPoint;

public class AcidInChain
implements Serializable {
    protected Direction next;
    protected GridPoint xyz;
    private int index;
    protected AminoAcid a;
    protected String name;
    protected String abName;
    protected double hydrophobicIndex;
    private TreeSet neighbors;

    public AcidInChain(AminoAcid a, int index) {
        this.a = a;
        this.next = Direction.none;
        this.neighbors = new TreeSet();
        this.index = index;
        this.name = a.getName();
        this.abName = a.getAbName();
        this.hydrophobicIndex = a.hydrophobicIndex;
    }

    public AminoAcid getAminoAcid() {
        return this.a;
    }

    public double getHydrophobicIndex() {
        return this.a.getHydrophobicIndex();
    }

    public int gethydrogenbondIndex() {
        return this.a.gethydrogenbondIndex();
    }

    public int getionicIndex() {
        return this.a.getionicIndex();
    }

    public boolean getssIndex() {
        return this.a.getssIndex();
    }

    public float getNormalizedHydrophobicIndex() {
        return this.a.getNormalizedHydrophobicIndex();
    }

    public String getName() {
        return this.a.getName();
    }

    public String getAbName() {
        return this.a.getAbName();
    }

    public int getIndex() {
        return this.index;
    }

    public Set getNeighbors() {
        return this.neighbors;
    }

    public GridPoint getPoint() {
        return this.xyz;
    }

    public Direction getNext() {
        return this.next;
    }

    public String toString() {
        return String.valueOf(this.a.toString()) + " : " + this.next;
    }

    public void addNeighbor(Integer neighbor) {
        int i = neighbor;
        if (i != this.index - 1 && i != this.index + 1) {
            this.neighbors.add(neighbor);
        }
    }

    public void setNext(Direction next) {
        this.next = next;
    }
}

