'use strict';


var Type = require('../type');


var YAML_NULL_MAP = {
  '~'    : true,
  'null' : true,
  'Null' : true,
  'NULL' : true
};


function resolveYamlNull(state) {
  if (YAML_NULL_MAP.hasOwnProperty(state.result)) {
    state.result = null;
    return true;
  }
  return false;
}


function isNull(object) {
  return null === object;
}


module.exports = new Type('tag:yaml.org,2002:null', {
  loadKind: 'scalar',
  loadResolver: resolveYamlNull,
  dumpPredicate: isNull,
  dumpRepresenter: {
    canonical: function () { return '~';    },
    lowercase: function () { return 'null'; },
    uppercase: function () { return 'NULL'; },
    camelcase: function () { return 'Null'; }
  },
  dumpDefaultStyle: 'lowercase'
});
