/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;
import protex.AminoAcid;
import protex.ColorCoder;
import protex.Protex;
import protex.ShadingColorCoder;
import protex.StandardTable;

public class AminoAcidPalette
extends JPanel {
    private static int cellRadius = 20;
    private static int cellDiameter = 2 * cellRadius;
    private static int AB_Y_OFFSET = 13;
    private int row;
    private int column;
    private int columnWidth;
    private int rowHeight;
    private AminoAcid selectedAminoAcid;
    private AminoAcid[] list;
    private boolean admin;

    public AminoAcidPalette(int width, int height, int row, int column, boolean admin) {
        super(new BorderLayout());
        super.setPreferredSize(new Dimension(width, height));
        super.setBackground(Protex.SS_BONDS_OFF_BACKGROUND);
        this.row = row;
        this.column = column;
        this.admin = admin;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        Point p = this.getLocation();
        this.rowHeight = this.columnWidth = cellDiameter + cellRadius / 4;
        StandardTable table = StandardTable.getInstance();
        this.list = table.getAllAcids();
        ShadingColorCoder cc = new ShadingColorCoder(table.getContrastScaler());
        int x = 0;
        int i = 0;
        while (i < this.row) {
            int j = 0;
            while (j < this.column) {
                AminoAcid a = this.list[x];
                if (a.getAbName().equals("X")) break;
                int offset = this.getStringIndentationConstant(a.getName(), cellRadius);
                int abOffset = this.getStringIndentationConstant(a.getAbName(), cellRadius);
                g.setColor(((ColorCoder)cc).getCellColor(a.getNormalizedHydrophobicIndex()));
                g.fillOval(j * this.columnWidth, i * this.rowHeight, cellDiameter, cellDiameter);
                g.setColor(Color.white);
                if (a.getName().equals("Arg") || a.getName().equals("Lys") || a.getName().equals("His")) {
                    g.setColor(Color.blue);
                    g.drawString("+", j * this.columnWidth + cellRadius - 15, i * this.rowHeight + cellRadius);
                    g.setColor(Color.BLACK);
                }
                if (a.getName().equals("Asp") || a.getName().equals("Glu")) {
                    g.setColor(Color.red);
                    g.drawString("-", j * this.columnWidth + cellRadius - 15, i * this.rowHeight + cellRadius);
                    g.setColor(Color.BLACK);
                }
                if (a.getName().equals("Asn") || a.getName().equals("Gln") || a.getName().equals("Ser") || a.getName().equals("Thr") || a.getName().equals("Tyr")) {
                    g.setColor(Color.green);
                    g.drawString("*", j * this.columnWidth + cellRadius - 15, i * this.rowHeight + cellRadius);
                    g.setColor(Color.BLACK);
                }
                g.drawString(a.getName(), j * this.columnWidth + cellRadius - offset, i * this.rowHeight + cellRadius);
                g.drawString(a.getAbName(), j * this.columnWidth + cellRadius - abOffset, i * this.rowHeight + cellRadius + AB_Y_OFFSET);
                g.setColor(Color.black);
                ++x;
                ++j;
            }
            ++i;
        }
    }

    protected int getStringIndentationConstant(String name, int r) {
        int length = name.trim().length();
        if (length == 1) {
            return 0;
        }
        if (length == 2) {
            return 0;
        }
        if (length == 3) {
            return (int)(0.2f * (float)r);
        }
        if (length == 4) {
            return (int)(0.5f * (float)r);
        }
        if (length == 5) {
            return (int)(0.6666667f * (float)r);
        }
        return (int)(0.75f * (float)r);
    }
}

