// Generated by CoffeeScript 1.6.1
(function() {
  var _this = this,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  if (typeof Backbone !== "undefined" && Backbone !== null) {
    this.DiscussionThreadEditView = (function(_super) {

      __extends(DiscussionThreadEditView, _super);

      function DiscussionThreadEditView() {
        var _this = this;
        this.cancelHandler = function(event) {
          return DiscussionThreadEditView.prototype.cancelHandler.apply(_this, arguments);
        };
        this.updateHandler = function(event) {
          return DiscussionThreadEditView.prototype.updateHandler.apply(_this, arguments);
        };
        this.save = function() {
          return DiscussionThreadEditView.prototype.save.apply(_this, arguments);
        };
        this.isTabMode = function() {
          return DiscussionThreadEditView.prototype.isTabMode.apply(_this, arguments);
        };
        this.addField = function(fieldView) {
          return DiscussionThreadEditView.prototype.addField.apply(_this, arguments);
        };
        this.render = function() {
          return DiscussionThreadEditView.prototype.render.apply(_this, arguments);
        };
        this.initialize = function(options) {
          return DiscussionThreadEditView.prototype.initialize.apply(_this, arguments);
        };
        return DiscussionThreadEditView.__super__.constructor.apply(this, arguments);
      }

      DiscussionThreadEditView.prototype.tagName = 'form';

      DiscussionThreadEditView.prototype.events = {
        'submit': 'updateHandler',
        'click .post-cancel': 'cancelHandler'
      };

      DiscussionThreadEditView.prototype.attributes = {
        'class': 'discussion-post edit-post-form'
      };

      DiscussionThreadEditView.prototype.initialize = function(options) {
        this.container = options.container || $('.thread-content-wrapper');
        this.mode = options.mode || 'inline';
        this.course_settings = options.course_settings;
        this.threadType = this.model.get('thread_type');
        this.topicId = this.model.get('commentable_id');
        _.bindAll(this);
        return this;
      };

      DiscussionThreadEditView.prototype.render = function() {
        var formId, threadTypeTemplate;
        formId = _.uniqueId("form-");
        this.template = _.template($('#thread-edit-template').html());
        this.$el.html(this.template(this.model.toJSON())).appendTo(this.container);
        this.submitBtn = this.$('.post-update');
        threadTypeTemplate = _.template($("#thread-type-template").html());
        this.addField(threadTypeTemplate({
          form_id: formId
        }));
        this.$("#" + formId + "-post-type-" + this.threadType).attr('checked', true);
        this.topicView = new DiscussionTopicMenuView({
          topicId: this.topicId,
          course_settings: this.course_settings
        });
        this.addField(this.topicView.render());
        DiscussionUtil.makeWmdEditor(this.$el, $.proxy(this.$, this), 'edit-post-body');
        return this;
      };

      DiscussionThreadEditView.prototype.addField = function(fieldView) {
        this.$('.forum-edit-post-form-wrapper').append(fieldView);
        return this;
      };

      DiscussionThreadEditView.prototype.isTabMode = function() {
        return this.mode === 'tab';
      };

      DiscussionThreadEditView.prototype.save = function() {
        var body, commentableId, postData, threadType, title,
          _this = this;
        title = this.$('.edit-post-title').val();
        threadType = this.$(".post-type-input:checked").val();
        body = this.$('.edit-post-body textarea').val();
        commentableId = this.topicView.getCurrentTopicId();
        postData = {
          title: title,
          thread_type: threadType,
          body: body,
          commentable_id: commentableId
        };
        return DiscussionUtil.safeAjax({
          $elem: this.submitBtn,
          $loading: this.submitBtn,
          url: DiscussionUtil.urlFor('update_thread', this.model.id),
          type: 'POST',
          dataType: 'json',
          async: false,
          data: postData,
          error: DiscussionUtil.formErrorHandler(this.$('.post-errors')),
          success: function() {
            _this.$('.edit-post-title').val('').attr('prev-text', '');
            _this.$('.edit-post-body textarea').val('').attr('prev-text', '');
            _this.$('.wmd-preview p').html('');
            postData.courseware_title = _this.topicView.getFullTopicName();
            _this.model.set(postData).unset('abbreviatedBody');
            _this.trigger('thread:updated');
            if (_this.threadType !== threadType) {
              _this.model.trigger('thread:thread_type_updated');
              return _this.trigger('comment:endorse');
            }
          }
        });
      };

      DiscussionThreadEditView.prototype.updateHandler = function(event) {
        event.preventDefault();
        this.trigger('thread:update', event);
        this.save();
        return this;
      };

      DiscussionThreadEditView.prototype.cancelHandler = function(event) {
        event.preventDefault();
        this.trigger("thread:cancel_edit", event);
        this.remove();
        return this;
      };

      return DiscussionThreadEditView;

    })(Backbone.View);
  }

}).call(this);
