/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.util.Iterator;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.ColorCoder;

public class ColorColorCoder
extends ColorCoder {
    private float[] redHSB = Color.RGBtoHSB(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), new float[3]);
    private float[] greenHSB = Color.RGBtoHSB(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), new float[3]);
    private float k = 0.5f;
    private float a;
    private float b;
    private float c;

    public ColorColorCoder() {
        this(0.5f);
    }

    public ColorColorCoder(float k) {
        this.k = k;
        this.a = 4.0f - 4.0f * k;
        this.b = -6.0f + 6.0f * k;
        this.c = 3.0f - 2.0f * k;
    }

    @Override
    protected Color getCellColor(double hydrophobicIndex) {
        return this.getCellColor((float)hydrophobicIndex);
    }

    @Override
    protected Color getCellColor(float hydrophobicIndex) {
        float x = (hydrophobicIndex + 1.0f) / 2.0f;
        float alpha = x * (this.c + x * (this.b + this.a * x));
        float oneMinusAlpha = 1.0f - alpha;
        return Color.getHSBColor(alpha * this.redHSB[0] + oneMinusAlpha * this.greenHSB[0], alpha * this.redHSB[1] + oneMinusAlpha * this.greenHSB[1], alpha * this.redHSB[2] + oneMinusAlpha * this.greenHSB[2]);
    }

    public static void main(String[] args) {
        try {
            ColorColorCoder cc = new ColorColorCoder();
            AminoAcidTable standard = AminoAcidTable.makeTable("standard");
            Iterator i = standard.getIterator();
            while (i.hasNext()) {
                AminoAcid a = standard.get((String)i.next());
                Color color = cc.getCellColor(a.getHydrophobicIndex());
                Color opp = new Color(-color.getRGB());
                System.out.println(a + " " + color + " " + opp + " " + Integer.toHexString(color.getRGB()) + " " + Integer.toHexString(-color.getRGB()));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

