/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.util.HashSet;
import java.util.Set;
import protex.AcidInChain;
import protex.Direction;
import protex.Folder;
import protex.Grid;
import protex.GridPoint;
import protex.Polypeptide;

public class BruteForceFolder
extends Folder {
    protected double energy;
    protected GridPoint[] points;
    protected int chainCount = 0;
    protected int energyTies = 1;
    protected double infiniteEnergy;
    protected long[] buckets = new long[201];
    protected double scale;
    protected double offset;
    protected Set topologies;

    @Override
    public String getName() {
        return "Brute force folding";
    }

    public int getCurrent() {
        return 0;
    }

    public BruteForceFolder(boolean custom, Polypeptide pp, Grid grid) {
        super(custom, pp, grid);
        this.infiniteEnergy = grid.getInfiniteEnergy();
    }

    @Override
    public void realFold() {
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = 0L;
            ++i;
        }
        this.topologies = new HashSet();
        this.scale = 100.0 / (this.pp.getMaxEnergy() * (double)(4 * this.numAcids + 2));
        this.offset = 100.0 / this.pp.getMaxEnergy();
        this.points = new GridPoint[this.grid.getSize()];
        i = 0;
        while (i < this.numAcids) {
            this.grid.unset(this.acids[i]);
            ++i;
        }
        this.resetEnergy();
        if (this.numAcids > 0) {
            this.grid.set(0, this.grid.getCenter(), Direction.none);
        }
        if (this.numAcids == 1) {
            this.energy = this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
            return;
        }
        this.grid.set(1, this.grid.nextCell(this.grid.getFirstDirection(), this.grid.getCenter()), this.grid.getFirstDirection());
        if (this.numAcids == 2) {
            this.energy = this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
            return;
        }
        this.placeRestOfAcids();
        this.restore();
    }

    protected void placeRestOfAcids() {
        Direction[] thirdPlacement = this.grid.getThirdPlacement();
        int i = 0;
        while (i < thirdPlacement.length) {
            this.tryDirection(thirdPlacement[i], 2, this.numAcids);
            ++i;
        }
    }

    protected void resetEnergy() {
        this.energy = this.infiniteEnergy;
    }

    public void recurse(Direction[] next, int current, int stop) {
        int i = 0;
        while (i < next.length) {
            this.tryDirection(next[i], current, stop);
            ++i;
        }
    }

    protected void tryDirection(Direction direction, int current, int stop) {
        AcidInChain lastA = this.acids[current - 1];
        GridPoint p = this.grid.nextCell(direction, lastA.xyz);
        if (this.grid.get(p) == null) {
            this.grid.set(current, p, direction);
            if (++current == stop) {
                this.saveIfNecessary();
            } else {
                this.recurse(this.grid.getNextDirection(direction), current, stop);
            }
            this.grid.unset(p, current);
        }
    }

    protected void saveIfNecessary() {
        ++this.chainCount;
        double localEnergy = this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
        if (localEnergy > this.energy) {
            return;
        }
        if (localEnergy == this.energy) {
            ++this.energyTies;
            this.grid.computeStatistics(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
            if (this.grid.isLastAcidPlaced()) {
                this.topologies.add(String.valueOf(this.pp.getTopology()) + "\n" + this.pp.getDirectionSequence());
            }
            return;
        }
        this.energy = localEnergy;
        this.energyTies = 1;
        this.topologies.clear();
        this.grid.computeStatistics(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
        if (this.grid.isLastAcidPlaced()) {
            this.topologies.add(String.valueOf(this.pp.getTopology()) + "\n" + this.pp.getDirectionSequence());
        }
        int i = 0;
        while (i < this.numAcids) {
            this.points[i] = this.acids[i].getPoint();
            ++i;
        }
    }

    public String getTopologies() {
        return this.topologies.toString();
    }

    @Override
    public String getStatistics() {
        return "explored " + this.chainCount + " chains in " + this.getTime() + " seconds";
    }

    public String getEnergyHistogram() {
        StringBuffer buf = new StringBuffer(400);
        int i = 0;
        while (i < this.buckets.length) {
            buf.append(String.valueOf(this.buckets[i]) + ", ");
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String report() {
        StringBuffer buf = new StringBuffer(super.report());
        buf.append("\nexplored " + this.chainCount + " chains");
        buf.append("\nminimum occurred " + this.getEnergyTies() + " times");
        return buf.toString();
    }

    public int getEnergyTies() {
        return this.energyTies;
    }

    protected void restore() {
        int i = 0;
        while (i < this.numAcids) {
            Direction d = Direction.none;
            if (this.points[i] == null) break;
            if (i > 0) {
                d = this.grid.getDirection(this.points[i - 1], this.points[i]);
            }
            this.grid.set(i, this.points[i], d);
            ++i;
        }
    }
}

