/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.util.HashMap;
import protex.Direction;
import protex.GridPoint;
import protex.Polypeptide;
import protex.TwoDGrid;

public class HexGrid
extends TwoDGrid {
    public final Direction E = Direction.E;
    public final Direction SE = Direction.SE;
    public final Direction SW = Direction.SW;
    public final Direction W = Direction.W;
    public final Direction NW = Direction.NW;
    public final Direction NE = Direction.NE;

    public HexGrid(Polypeptide pp) {
        super(pp);
        this.allDirections = this.getAllDirections();
        this.setNextDirectionsStraight();
        this.setNextDirectionsBent();
        this.setNextDirections();
        if (pp.isFolded()) {
            GridPoint currentP = this.getCenter();
            this.set(0, currentP, Direction.none);
            Direction d = pp.getNextDirection(0);
            int i = 1;
            while (i < this.numAcids) {
                currentP = this.nextCell(d, currentP);
                this.set(i, currentP, d);
                d = pp.getNextDirection(i);
                ++i;
            }
        }
    }

    @Override
    protected Direction[] getAllDirections() {
        Direction[] all = new Direction[]{Direction.E, Direction.NE, Direction.NW, Direction.W, Direction.SW, Direction.SE};
        return all;
    }

    @Override
    public Direction[] getThirdPlacement() {
        Direction[] directions = new Direction[]{this.E, this.NE, this.NW};
        return directions;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int row = 0;
        while (row < this.size) {
            int indent = 0;
            while (indent < row) {
                buf.append("  ");
                ++indent;
            }
            int col = 0;
            while (col < this.size) {
                buf.append(this.cells[row][col] == null ? "---" : this.cells[row][col].name);
                buf.append(' ');
                ++col;
            }
            buf.append('\n');
            ++row;
        }
        return buf.toString();
    }

    @Override
    protected Direction getDirection(int x1, int y1, int x2, int y2) {
        if (y1 == y2) {
            if (x1 + 1 == x2) {
                return this.E;
            }
            return this.W;
        }
        if (x1 == x2) {
            if (y1 + 1 == y2) {
                return this.SE;
            }
            return this.NW;
        }
        if (y1 + 1 == y2) {
            return this.SW;
        }
        return this.NE;
    }

    @Override
    protected GridPoint nextCell(Direction direction, GridPoint p) {
        int x = p.x;
        int y = p.y;
        if (direction == this.E) {
            return this.points[x + 1][y];
        }
        if (direction == this.W) {
            return this.points[x - 1][y];
        }
        if (direction == this.SE) {
            return this.points[x][y + 1];
        }
        if (direction == this.NW) {
            return this.points[x][y - 1];
        }
        if (direction == this.SW) {
            return this.points[x - 1][y + 1];
        }
        if (direction == this.NE) {
            return this.points[x + 1][y - 1];
        }
        if (direction == Direction.none) {
            return p;
        }
        return null;
    }

    @Override
    protected Direction[] getDirectionRing3() {
        Direction[] ring = new Direction[]{this.E, this.NE, this.NW, this.W, this.SW, this.SE, this.E, this.NE, this.NW, this.W, this.SW, this.SE, this.E, this.NE, this.NW, this.W, this.SW, this.SE};
        return ring;
    }

    @Override
    protected int getNumDirections() {
        return 6;
    }

    @Override
    public void setNextDirectionsStraight() {
        this.straightMap = new HashMap();
        Direction[] nextE = new Direction[]{this.E, this.NE, this.SE, this.NW, this.SW};
        this.straightMap.put(this.E, nextE);
        Direction[] nextNE = new Direction[]{this.NE, this.NW, this.E, this.W, this.SE};
        this.straightMap.put(this.NE, nextNE);
        Direction[] nextNW = new Direction[]{this.NW, this.W, this.NE, this.SW, this.E};
        this.straightMap.put(this.NW, nextNW);
        Direction[] nextW = new Direction[]{this.W, this.SW, this.NW, this.SE, this.NE};
        this.straightMap.put(this.W, nextW);
        Direction[] nextSW = new Direction[]{this.SW, this.W, this.SE, this.NW, this.E};
        this.straightMap.put(this.SW, nextSW);
        Direction[] nextSE = new Direction[]{this.SE, this.SW, this.E, this.W, this.NE};
        this.straightMap.put(this.SE, nextSE);
    }
}

