// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.VideoProgressSlider = (function() {

    function VideoProgressSlider(player) {
      this.player = player;
      this.onStop = __bind(this.onStop, this);

      this.onChange = __bind(this.onChange, this);

      this.onSlide = __bind(this.onSlide, this);

      this.onUpdatePlayTime = __bind(this.onUpdatePlayTime, this);

      this.onReady = __bind(this.onReady, this);

      this.buildSlider();
      this.buildHandle();
      $(this.player).bind('updatePlayTime', this.onUpdatePlayTime);
      $(this.player).bind('ready', this.onReady);
    }

    VideoProgressSlider.prototype.$ = function(selector) {
      return this.player.$(selector);
    };

    VideoProgressSlider.prototype.buildSlider = function() {
      return this.slider = this.$('.slider').slider({
        range: 'min',
        change: this.onChange,
        slide: this.onSlide,
        stop: this.onStop
      });
    };

    VideoProgressSlider.prototype.buildHandle = function() {
      this.handle = this.$('.ui-slider-handle');
      return this.handle.qtip({
        content: "" + (Time.format(this.slider.slider('value'))),
        position: {
          my: 'bottom center',
          at: 'top center',
          container: this.handle
        },
        hide: {
          delay: 700
        },
        style: {
          classes: 'ui-tooltip-slider',
          widget: true
        }
      });
    };

    VideoProgressSlider.prototype.onReady = function() {
      return this.slider.slider('option', 'max', this.player.duration());
    };

    VideoProgressSlider.prototype.onUpdatePlayTime = function(event, currentTime) {
      if (!this.frozen) {
        this.slider.slider('option', 'max', this.player.duration());
        return this.slider.slider('value', currentTime);
      }
    };

    VideoProgressSlider.prototype.onSlide = function(event, ui) {
      this.frozen = true;
      this.updateTooltip(ui.value);
      return $(this.player).trigger('seek', ui.value);
    };

    VideoProgressSlider.prototype.onChange = function(event, ui) {
      return this.updateTooltip(ui.value);
    };

    VideoProgressSlider.prototype.onStop = function(event, ui) {
      var _this = this;
      this.frozen = true;
      $(this.player).trigger('seek', ui.value);
      return setTimeout((function() {
        return _this.frozen = false;
      }), 200);
    };

    VideoProgressSlider.prototype.updateTooltip = function(value) {
      return this.handle.qtip('option', 'content.text', "" + (Time.format(value)));
    };

    return VideoProgressSlider;

  })();

}).call(this);
