// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.Sequence = (function() {

    function Sequence(id, elements, tag, position) {
      this.id = id;
      this.elements = elements;
      this.tag = tag;
      this.previous = __bind(this.previous, this);

      this.next = __bind(this.next, this);

      this.goto = __bind(this.goto, this);

      this.toggleArrows = __bind(this.toggleArrows, this);

      this.element = $("#sequence_" + this.id);
      this.buildNavigation();
      this.bind();
      this.render(position);
    }

    Sequence.prototype.$ = function(selector) {
      return $(selector, this.element);
    };

    Sequence.prototype.bind = function() {
      this.element.bind('contentChanged', this.toggleArrows);
      return this.$('#sequence-list a').click(this.goto);
    };

    Sequence.prototype.buildNavigation = function() {
      var _this = this;
      return $.each(this.elements, function(index, item) {
        var link, list_item, title;
        link = $('<a>').attr({
          "class": "seq_" + item.type + "_inactive",
          'data-element': index + 1
        });
        title = $('<p>').html(item.title);
        list_item = $('<li>').append(link.append(title));
        return _this.$('#sequence-list').append(list_item);
      });
    };

    Sequence.prototype.toggleArrows = function() {
      this.$('.sequence-nav-buttons a').unbind('click');
      if (this.position === 1) {
        this.$('.sequence-nav-buttons .prev a').addClass('disabled');
      } else {
        this.$('.sequence-nav-buttons .prev a').removeClass('disabled').click(this.previous);
      }
      if (this.position === this.elements.length) {
        return this.$('.sequence-nav-buttons .next a').addClass('disabled');
      } else {
        return this.$('.sequence-nav-buttons .next a').removeClass('disabled').click(this.next);
      }
    };

    Sequence.prototype.render = function(new_position) {
      if (this.position !== new_position) {
        if (this.position !== void 0) {
          this.mark_visited(this.position);
          $.postWithPrefix("/modx/" + this.tag + "/" + this.id + "/goto_position", {
            position: new_position
          });
        }
        this.mark_active(new_position);
        this.$('#seq_content').html(eval(this.elements[new_position - 1].content));
        MathJax.Hub.Queue(["Typeset", MathJax.Hub]);
        this.position = new_position;
        return this.element.trigger('contentChanged');
      }
    };

    Sequence.prototype.goto = function(event) {
      var new_position;
      event.preventDefault();
      new_position = $(event.target).data('element');
      Logger.log("seq_goto", {
        old: this.position,
        "new": new_position,
        id: this.id
      });
      return this.render(new_position);
    };

    Sequence.prototype.next = function(event) {
      var new_position;
      event.preventDefault();
      new_position = this.position + 1;
      Logger.log("seq_next", {
        old: this.position,
        "new": new_position,
        id: this.id
      });
      return this.render(new_position);
    };

    Sequence.prototype.previous = function(event) {
      var new_position;
      event.preventDefault();
      new_position = this.position - 1;
      Logger.log("seq_prev", {
        old: this.position,
        "new": new_position,
        id: this.id
      });
      return this.render(new_position);
    };

    Sequence.prototype.link_for = function(position) {
      return this.$("#sequence-list a[data-element=" + position + "]");
    };

    Sequence.prototype.mark_visited = function(position) {
      return this.link_for(position).attr({
        "class": "seq_" + this.elements[position - 1].type + "_visited"
      });
    };

    Sequence.prototype.mark_active = function(position) {
      return this.link_for(position).attr({
        "class": "seq_" + this.elements[position - 1].type + "_active"
      });
    };

    return Sequence;

  })();

}).call(this);
