// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.VideoPlayer = (function() {

    function VideoPlayer(video) {
      this.video = video;
      this.toggleFullScreen = __bind(this.toggleFullScreen, this);

      this.onUpdatePlayTime = __bind(this.onUpdatePlayTime, this);

      this.update = __bind(this.update, this);

      this.onSpeedChange = __bind(this.onSpeedChange, this);

      this.onPause = __bind(this.onPause, this);

      this.onPlay = __bind(this.onPlay, this);

      this.onStateChange = __bind(this.onStateChange, this);

      this.onReady = __bind(this.onReady, this);

      this.bindExitFullScreen = __bind(this.bindExitFullScreen, this);

      this.currentTime = 0;
      this.element = $("#video_" + this.video.id);
      this.render();
      this.bind();
    }

    VideoPlayer.prototype.$ = function(selector) {
      return $(selector, this.element);
    };

    VideoPlayer.prototype.bind = function() {
      $(this).bind('seek', this.onSeek).bind('updatePlayTime', this.onUpdatePlayTime).bind('speedChange', this.onSpeedChange).bind('play', this.onPlay).bind('pause', this.onPause).bind('ended', this.onPause);
      $(document).keyup(this.bindExitFullScreen);
      this.$('.add-fullscreen').click(this.toggleFullScreen);
      if (!onTouchBasedDevice()) {
        return this.addToolTip();
      }
    };

    VideoPlayer.prototype.bindExitFullScreen = function(event) {
      if (this.element.hasClass('fullscreen') && event.keyCode === 27) {
        return this.toggleFullScreen(event);
      }
    };

    VideoPlayer.prototype.render = function() {
      new VideoControl(this);
      new VideoCaption(this, this.video.youtubeId('1.0'));
      new VideoSpeedControl(this, this.video.speeds);
      new VideoProgressSlider(this);
      return this.player = new YT.Player(this.video.id, {
        playerVars: {
          controls: 0,
          wmode: 'transparent',
          rel: 0,
          showinfo: 0,
          enablejsapi: 1
        },
        videoId: this.video.youtubeId(),
        events: {
          onReady: this.onReady,
          onStateChange: this.onStateChange
        }
      });
    };

    VideoPlayer.prototype.addToolTip = function() {
      return this.$('.add-fullscreen, .hide-subtitles').qtip({
        position: {
          my: 'top right',
          at: 'top center'
        }
      });
    };

    VideoPlayer.prototype.onReady = function() {
      $(this).trigger('ready');
      $(this).trigger('updatePlayTime', 0);
      if (!onTouchBasedDevice()) {
        return $('.course-content .video:first').data('video').player.play();
      }
    };

    VideoPlayer.prototype.onStateChange = function(event) {
      switch (event.data) {
        case YT.PlayerState.PLAYING:
          return $(this).trigger('play');
        case YT.PlayerState.PAUSED:
          return $(this).trigger('pause');
        case YT.PlayerState.ENDED:
          return $(this).trigger('ended');
      }
    };

    VideoPlayer.prototype.onPlay = function() {
      Logger.log('play_video', {
        id: this.currentTime,
        code: this.player.getVideoEmbedCode()
      });
      if (window.player && window.player !== this.player) {
        window.player.pauseVideo();
      }
      window.player = this.player;
      if (!this.player.interval) {
        return this.player.interval = setInterval(this.update, 200);
      }
    };

    VideoPlayer.prototype.onPause = function() {
      Logger.log('pause_video', {
        id: this.currentTime,
        code: this.player.getVideoEmbedCode()
      });
      if (window.player === this.player) {
        window.player = null;
      }
      clearInterval(this.player.interval);
      return this.player.interval = null;
    };

    VideoPlayer.prototype.onSeek = function(event, time) {
      this.player.seekTo(time, true);
      if (this.isPlaying()) {
        clearInterval(this.player.interval);
        return this.player.interval = setInterval(this.update, 200);
      } else {
        this.currentTime = time;
        return $(this).trigger('updatePlayTime', time);
      }
    };

    VideoPlayer.prototype.onSpeedChange = function(event, newSpeed) {
      this.currentTime = Time.convert(this.currentTime, parseFloat(this.currentSpeed()), newSpeed);
      this.video.setSpeed(parseFloat(newSpeed).toFixed(2).replace(/\.00$/, '.0'));
      if (this.isPlaying()) {
        this.player.loadVideoById(this.video.youtubeId(), this.currentTime);
      } else {
        this.player.cueVideoById(this.video.youtubeId(), this.currentTime);
      }
      return $(this).trigger('updatePlayTime', this.currentTime);
    };

    VideoPlayer.prototype.update = function() {
      if (this.currentTime = this.player.getCurrentTime()) {
        return $(this).trigger('updatePlayTime', this.currentTime);
      }
    };

    VideoPlayer.prototype.onUpdatePlayTime = function(event, time) {
      var progress;
      progress = Time.format(time) + ' / ' + Time.format(this.duration());
      return this.$(".vidtime").html(progress);
    };

    VideoPlayer.prototype.toggleFullScreen = function(event) {
      event.preventDefault();
      if (this.element.hasClass('fullscreen')) {
        this.$('.exit').remove();
        this.$('.add-fullscreen').attr('title', 'Fill browser');
        this.element.removeClass('fullscreen');
      } else {
        this.element.append('<a href="#" class="exit">Exit</a>').addClass('fullscreen');
        this.$('.add-fullscreen').attr('title', 'Exit fill browser');
        this.$('.exit').click(this.toggleFullScreen);
      }
      return $(this).trigger('resize');
    };

    VideoPlayer.prototype.play = function() {
      if (this.player.playVideo) {
        return this.player.playVideo();
      }
    };

    VideoPlayer.prototype.isPlaying = function() {
      return this.player.getPlayerState() === YT.PlayerState.PLAYING;
    };

    VideoPlayer.prototype.pause = function() {
      return this.player.pauseVideo();
    };

    VideoPlayer.prototype.duration = function() {
      return this.video.getDuration();
    };

    VideoPlayer.prototype.currentSpeed = function() {
      return this.video.speed;
    };

    return VideoPlayer;

  })();

}).call(this);
