/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.io.Serializable;
import java.util.Iterator;
import protex.AminoAcid;
import protex.FoldingException;
import protex.StandardTable;
import protex.VirtualTable;

public abstract class AminoAcidTable
implements Serializable {
    public static final String STANDARD = "standard";
    public static final String VIRTUAL = "virtual";
    private static StandardTable standardTable = null;
    private static VirtualTable virtualTable = null;

    public static AminoAcidTable makeTable(String tableName) throws FoldingException {
        if (tableName.equalsIgnoreCase(STANDARD)) {
            if (standardTable == null) {
                standardTable = StandardTable.getInstance();
            }
            return standardTable;
        }
        if (tableName.equalsIgnoreCase(VIRTUAL)) {
            if (virtualTable == null) {
                virtualTable = new VirtualTable();
            }
            return virtualTable;
        }
        throw new FoldingException("no AminoAcid  named " + tableName);
    }

    public abstract void add(AminoAcid var1, double var2) throws FoldingException;

    public abstract void add(AminoAcid var1) throws FoldingException;

    public abstract AminoAcid[] getRandom(int var1, int var2);

    public abstract double getMaxEnergy();

    public abstract AminoAcid get(String var1) throws FoldingException;

    public abstract AminoAcid getFromAbName(String var1) throws FoldingException;

    public float getContrastScaler() {
        return 0.5f;
    }

    public Iterator getIterator() throws FoldingException {
        throw new FoldingException("no iterator available");
    }

    public abstract String getName();

    public static void main(String[] args) {
        AminoAcidTable t = null;
        try {
            t = AminoAcidTable.makeTable(STANDARD);
        }
        catch (FoldingException foldingException) {
            // empty catch block
        }
        AminoAcid[] list = t.getRandom(15, 999);
        int i = 0;
        while (i < list.length) {
            System.out.print(list[i] + " ");
            ++i;
        }
        System.out.println();
    }
}

