"""
There are other askbot settings in common.py that covers things like where the
templates are located, etc. This file is purely for askbot forum *behavior*.
This means things like karma limits, the ability to post questions as wikis, 
anonymous questions, etc.
"""

LIVESETTINGS_OPTIONS = {
    1: {
        'DB' : False,
        'SETTINGS' : {
            'ACCESS_CONTROL' : {
                'ASKBOT_CLOSED_FORUM_MODE' : True,
            },
            'BADGES' : {
                'DISCIPLINED_BADGE_MIN_UPVOTES' : 3,
                'PEER_PRESSURE_BADGE_MIN_DOWNVOTES' : 3,
                'TEACHER_BADGE_MIN_UPVOTES' : 1,
                'NICE_ANSWER_BADGE_MIN_UPVOTES' : 2,
                'GOOD_ANSWER_BADGE_MIN_UPVOTES' : 3,
                'GREAT_ANSWER_BADGE_MIN_UPVOTES' : 5,
                'NICE_QUESTION_BADGE_MIN_UPVOTES' : 2,
                'GOOD_QUESTION_BADGE_MIN_UPVOTES' : 3,
                'GREAT_QUESTION_BADGE_MIN_UPVOTES' : 5,
                'POPULAR_QUESTION_BADGE_MIN_VIEWS' : 150,
                'NOTABLE_QUESTION_BADGE_MIN_VIEWS' : 250,
                'FAMOUS_QUESTION_BADGE_MIN_VIEWS' : 500,
                'SELF_LEARNER_BADGE_MIN_UPVOTES' : 1,
                'CIVIC_DUTY_BADGE_MIN_VOTES' : 100,
                'ENLIGHTENED_BADGE_MIN_UPVOTES' : 3,
                'ASSOCIATE_EDITOR_BADGE_MIN_EDITS' : 20,
                'COMMENTATOR_BADGE_MIN_COMMENTS' : 10,
                'ENTHUSIAST_BADGE_MIN_DAYS' : 30,
                'FAVORITE_QUESTION_BADGE_MIN_STARS' : 3,
                'GURU_BADGE_MIN_UPVOTES' : 5,
                'NECROMANCER_BADGE_MIN_DELAY' : 30,
                'NECROMANCER_BADGE_MIN_UPVOTES' : 1,
                'STELLAR_QUESTION_BADGE_MIN_STARS' : 5,
                'TAXONOMIST_BADGE_MIN_USE_COUNT' : 10,
            },
            'EMAIL' : {
                'EMAIL_SUBJECT_PREFIX' : u'[Django] ',
                'EMAIL_UNIQUE' : True,
                'EMAIL_VALIDATION' : False,
                'DEFAULT_NOTIFICATION_DELIVERY_SCHEDULE_M_AND_C' : u'w',
                'DEFAULT_NOTIFICATION_DELIVERY_SCHEDULE_Q_ALL' : u'w',
                'DEFAULT_NOTIFICATION_DELIVERY_SCHEDULE_Q_ANS' : u'w',
                'DEFAULT_NOTIFICATION_DELIVERY_SCHEDULE_Q_ASK' : u'w',
                'DEFAULT_NOTIFICATION_DELIVERY_SCHEDULE_Q_SEL' : u'w',
                'ENABLE_UNANSWERED_REMINDERS' : False,
                'DAYS_BEFORE_SENDING_UNANSWERED_REMINDER' : 1,
                'UNANSWERED_REMINDER_FREQUENCY' : 1,
                'MAX_UNANSWERED_REMINDERS' : 5,
                'ENABLE_ACCEPT_ANSWER_REMINDERS' : False,
                'DAYS_BEFORE_SENDING_ACCEPT_ANSWER_REMINDER' : 3,
                'ACCEPT_ANSWER_REMINDER_FREQUENCY' : 3,
                'MAX_ACCEPT_ANSWER_REMINDERS' : 5,
                'ANONYMOUS_USER_EMAIL' : u'anonymous@askbot.org',
                'ALLOW_ASKING_BY_EMAIL' : False,
                'REPLACE_SPACE_WITH_DASH_IN_EMAILED_TAGS' : True,                
                'MAX_ALERTS_PER_EMAIL' : 7,
            },
            'EMBEDDABLE_WIDGETS' : {
                'QUESTIONS_WIDGET_CSS' : u"\nbody {\n    overflow: hidden;\n}\n#container {\n    width: 200px;\n    height: 350px;\n}\nul {\n    list-style: none;\n    padding: 5px;\n    margin: 5px;\n}\nli {\n    border-bottom: #CCC 1px solid;\n    padding-bottom: 5px;\n    padding-top: 5px;\n}\nli:last-child {\n    border: none;\n}\na {\n    text-decoration: none;\n    color: #464646;\n    font-family: 'Yanone Kaffeesatz', sans-serif;\n    font-size: 15px;\n}\n",
                'QUESTIONS_WIDGET_FOOTER' : u"\n<link \n    href='http://fonts.googleapis.com/css?family=Yanone+Kaffeesatz:300,400,700'\n    rel='stylesheet'\n    type='text/css'\n>\n",
                'QUESTIONS_WIDGET_HEADER' : u'',
                'QUESTIONS_WIDGET_MAX_QUESTIONS' : 7,                
            },
            'EXTERNAL_KEYS' : {
                'RECAPTCHA_KEY' : u'',
                'RECAPTCHA_SECRET' : u'',
                'FACEBOOK_KEY' : u'',
                'FACEBOOK_SECRET' : u'',
                'HOW_TO_CHANGE_LDAP_PASSWORD' : u'',
                'IDENTICA_KEY' : u'',
                'IDENTICA_SECRET' : u'',
                'GOOGLE_ANALYTICS_KEY' : u'',
                'GOOGLE_SITEMAP_CODE' : u'',
                'LDAP_PROVIDER_NAME' : u'',
                'LDAP_URL' : u'',
                'LINKEDIN_KEY' : u'',
                'LINKEDIN_SECRET' : u'',
                'TWITTER_KEY' : u'',
                'TWITTER_SECRET' : u'',
                'USE_LDAP_FOR_PASSWORD_LOGIN' : False,
                'USE_RECAPTCHA' : False,
            },
            'FLATPAGES' : {
                'FORUM_ABOUT' : u'',
                'FORUM_FAQ' : u'',
                'FORUM_PRIVACY' : u'',
            },
            'FORUM_DATA_RULES' : {
                'MIN_TITLE_LENGTH' : 1,
                'MIN_QUESTION_BODY_LENGTH' : 1,
                'MIN_ANSWER_BODY_LENGTH' : 1,
                'WIKI_ON' : False,
                'ALLOW_ASK_ANONYMOUSLY' : True,
                'ALLOW_POSTING_BEFORE_LOGGING_IN' : False,
                'ALLOW_SWAPPING_QUESTION_WITH_ANSWER' : False,
                'MAX_TAG_LENGTH' : 20,
                'MIN_TITLE_LENGTH' : 1,
                'MIN_QUESTION_BODY_LENGTH' : 1,
                'MIN_ANSWER_BODY_LENGTH' : 1,
                'MANDATORY_TAGS' : u'',
                'FORCE_LOWERCASE_TAGS' : False,
                'TAG_LIST_FORMAT' : u'list',
                'USE_WILDCARD_TAGS' : False,
                'MAX_COMMENTS_TO_SHOW' : 5,
                'MAX_COMMENT_LENGTH' : 300,
                'USE_TIME_LIMIT_TO_EDIT_COMMENT' : True,
                'MINUTES_TO_EDIT_COMMENT' : 10,
                'SAVE_COMMENT_ON_ENTER' : True,
                'MIN_SEARCH_WORD_LENGTH' : 4,
                'DECOUPLE_TEXT_QUERY_FROM_SEARCH_STATE' : False,
                'MAX_TAGS_PER_POST' : 5,
                'DEFAULT_QUESTIONS_PAGE_SIZE' : u'30',
                'UNANSWERED_QUESTION_MEANING' : u'NO_ACCEPTED_ANSWERS',

                # Enabling video requires forked version of markdown
                # pip uninstall markdown2
                # pip install -e git+git://github.com/andryuha/python-markdown2.git#egg=markdown2
                'ENABLE_VIDEO_EMBEDDING' : False,
            },
            'GENERAL_SKIN_SETTINGS' : {
                'CUSTOM_CSS' : u'',
                'CUSTOM_FOOTER' : u'',
                'CUSTOM_HEADER' : u'',
                'CUSTOM_HTML_HEAD' : u'',
                'CUSTOM_JS' : u'',
                'SITE_FAVICON' : u'/images/favicon.gif',
                'SITE_LOGO_URL' : u'/images/logo.gif',
                'SHOW_LOGO' : False,
                'LOCAL_LOGIN_ICON' : u'/images/pw-login.gif',
                'ALWAYS_SHOW_ALL_UI_FUNCTIONS' : False,
                'ASKBOT_DEFAULT_SKIN' : u'mitx',
                'USE_CUSTOM_HTML_HEAD' : False,
                'FOOTER_MODE' : u'default',
                'USE_CUSTOM_CSS' : False,
                'USE_CUSTOM_JS' : False,
            },
            'LEADING_SIDEBAR' : {
                'ENABLE_LEADING_SIDEBAR' : False,
                'LEADING_SIDEBAR' : u'',
            },
            'LOGIN_PROVIDERS' : {
                'PASSWORD_REGISTER_SHOW_PROVIDER_BUTTONS' : True,
                'SIGNIN_ALWAYS_SHOW_LOCAL_LOGIN' : True,
                'SIGNIN_AOL_ENABLED' : True,
                'SIGNIN_BLOGGER_ENABLED' : True,
                'SIGNIN_CLAIMID_ENABLED' : True,
                'SIGNIN_FACEBOOK_ENABLED' : True,
                'SIGNIN_FLICKR_ENABLED' : True,
                'SIGNIN_GOOGLE_ENABLED' : True,
                'SIGNIN_IDENTI.CA_ENABLED' : True,
                'SIGNIN_LINKEDIN_ENABLED' : True,
                'SIGNIN_LIVEJOURNAL_ENABLED' : True,
                'SIGNIN_LOCAL_ENABLED' : True,
                'SIGNIN_OPENID_ENABLED' : True,
                'SIGNIN_TECHNORATI_ENABLED' : True,
                'SIGNIN_TWITTER_ENABLED' : True,
                'SIGNIN_VERISIGN_ENABLED' : True,
                'SIGNIN_VIDOOP_ENABLED' : True,
                'SIGNIN_WORDPRESS_ENABLED' : True,
                'SIGNIN_WORDPRESS_SITE_ENABLED' : False,
                'SIGNIN_YAHOO_ENABLED' : True,
                'WORDPRESS_SITE_ICON' : u'/images/logo.gif',
                'WORDPRESS_SITE_URL' : '',                   
            },
            'LICENSE_SETTINGS' : {
                'LICENSE_ACRONYM' : u'cc-by-sa',
                'LICENSE_LOGO_URL' : u'/images/cc-by-sa.png',
                'LICENSE_TITLE' : u'Creative Commons Attribution Share Alike 3.0',
                'LICENSE_URL' : 'http://creativecommons.org/licenses/by-sa/3.0/legalcode',
                'LICENSE_USE_LOGO' : True,
                'LICENSE_USE_URL' : True,
                'USE_LICENSE' : True,
            },
            'MARKUP' : {
                'MARKUP_CODE_FRIENDLY' : False,
                'ENABLE_MATHJAX' : True,
                'MATHJAX_BASE_URL' : u'/static/js/vendor/mathjax-MathJax-c9db6ac/',
                'ENABLE_AUTO_LINKING' : False,
                'AUTO_LINK_PATTERNS' : u'',
                'AUTO_LINK_URLS' : u'',
            },
            'MIN_REP' : {
                'MIN_REP_TO_ACCEPT_OWN_ANSWER' : 1,
                'MIN_REP_TO_ANSWER_OWN_QUESTION' : 1,
                'MIN_REP_TO_CLOSE_OTHERS_QUESTIONS' : 1200,
                'MIN_REP_TO_CLOSE_OWN_QUESTIONS' : 1,
                'MIN_REP_TO_DELETE_OTHERS_COMMENTS' : 5000,
                'MIN_REP_TO_DELETE_OTHERS_POSTS' : 10000,
                'MIN_REP_TO_EDIT_OTHERS_POSTS' : 5000,
                'MIN_REP_TO_EDIT_WIKI' : 200,
                'MIN_REP_TO_FLAG_OFFENSIVE' : 1,
                'MIN_REP_TO_HAVE_STRONG_URL' : 250,
                'MIN_REP_TO_LEAVE_COMMENTS' : 1,
                'MIN_REP_TO_LOCK_POSTS' : 10000,
                'MIN_REP_TO_REOPEN_OWN_QUESTIONS' : 1,
                'MIN_REP_TO_RETAG_OTHERS_QUESTIONS' : 100,
                'MIN_REP_TO_UPLOAD_FILES' : 1,
                'MIN_REP_TO_VIEW_OFFENSIVE_FLAGS' : 2000,
                'MIN_REP_TO_VOTE_DOWN' : 15,
                'MIN_REP_TO_VOTE_UP' : 1,
            },
            'QA_SITE_SETTINGS' : {
                'APP_COPYRIGHT' : u'Copyright Askbot, 2010-2011.',
                'APP_DESCRIPTION' : u'Open source question and answer forum written in Python and Django',
                'APP_KEYWORDS' : u'Askbot,CNPROG,forum,community',
                'APP_SHORT_NAME' : u'Askbot',
                'APP_TITLE' : u'Askbot: Open Source Q&A Forum',
                'APP_URL' : u'http://askbot.org',
                'FEEDBACK_SITE_URL' : u'',
                'ENABLE_GREETING_FOR_ANON_USER' : True,
                'GREETING_FOR_ANONYMOUS_USER' : u'First time here? Check out the FAQ!',
            },
            'REP_CHANGES' : {
                'MAX_REP_GAIN_PER_USER_PER_DAY' : 200,
                'REP_GAIN_FOR_ACCEPTING_ANSWER' : 2,
                'REP_GAIN_FOR_CANCELING_DOWNVOTE' : 1,
                'REP_GAIN_FOR_RECEIVING_ANSWER_ACCEPTANCE' : 15,
                'REP_GAIN_FOR_RECEIVING_DOWNVOTE_CANCELATION' : 2,
                'REP_GAIN_FOR_RECEIVING_UPVOTE' : 10,
                'REP_LOSS_FOR_CANCELING_ANSWER_ACCEPTANCE' : -2,
                'REP_LOSS_FOR_DOWNVOTING' : -2,
                'REP_LOSS_FOR_RECEIVING_CANCELATION_OF_ANSWER_ACCEPTANCE' : -5,
                'REP_LOSS_FOR_RECEIVING_DOWNVOTE' : -1,
                'REP_LOSS_FOR_RECEIVING_FIVE_FLAGS_PER_REVISION' : -100,
                'REP_LOSS_FOR_RECEIVING_FLAG' : -2,
                'REP_LOSS_FOR_RECEIVING_THREE_FLAGS_PER_REVISION' : -30,
                'REP_LOSS_FOR_RECEIVING_UPVOTE_CANCELATION' : -10,
            },
            'SOCIAL_SHARING' : {
                'ENABLE_SHARING_TWITTER' : False,
                'ENABLE_SHARING_FACEBOOK' : False,
                'ENABLE_SHARING_LINKEDIN' : False,
                'ENABLE_SHARING_IDENTICA' : False,
                'ENABLE_SHARING_GOOGLE' : False,
            },
            'SIDEBAR_MAIN' : {
                'SIDEBAR_MAIN_AVATAR_LIMIT' : 16,
                'SIDEBAR_MAIN_FOOTER' : u'',
                'SIDEBAR_MAIN_HEADER' : u'',
                'SIDEBAR_MAIN_SHOW_AVATARS' : True,
                'SIDEBAR_MAIN_SHOW_TAGS' : True,
                'SIDEBAR_MAIN_SHOW_TAG_SELECTOR' : True,                
            },
            'SIDEBAR_PROFILE' : {
                'SIDEBAR_PROFILE_FOOTER' : u'',
                'SIDEBAR_PROFILE_HEADER' : u'',
            },
            'SIDEBAR_QUESTION' : {
                'SIDEBAR_QUESTION_FOOTER' : u'',
                'SIDEBAR_QUESTION_HEADER' : u'',
                'SIDEBAR_QUESTION_SHOW_META' : True,
                'SIDEBAR_QUESTION_SHOW_RELATED' : True,
                'SIDEBAR_QUESTION_SHOW_TAGS' : True,
            },
            'SITE_MODES' : {
                'ACTIVATE_BOOTSTRAP_MODE' : False,
            },
            'SKIN_COUNTER_SETTINGS' : {
                
            },
            'SPAM_AND_MODERATION' : {
                'AKISMET_API_KEY' : u'',
                'USE_AKISMET' : False,
            },
            'USER_SETTINGS' : {
                'EDITABLE_SCREEN_NAME' : False,
                'EDITABLE_EMAIL' : False,
                'ALLOW_ADD_REMOVE_LOGIN_METHODS' : False,
                'ENABLE_GRAVATAR' : False,
                'GRAVATAR_TYPE' : u'identicon',
                'NAME_OF_ANONYMOUS_USER' : u'',
                'DEFAULT_AVATAR_URL' : u'/images/nophoto.png',
                'MIN_USERNAME_LENGTH' : 1,
                'ALLOW_ACCOUNT_RECOVERY_BY_EMAIL' : True,
            },
            'VOTE_RULES' : {
                'MAX_VOTES_PER_USER_PER_DAY' : 30,
                'MAX_FLAGS_PER_USER_PER_DAY' : 5,
                'MIN_DAYS_FOR_STAFF_TO_ACCEPT_ANSWER' : 0,
                'MIN_DAYS_TO_ANSWER_OWN_QUESTION' : 0,
                'MIN_FLAGS_TO_DELETE_POST' : 5,
                'MIN_FLAGS_TO_HIDE_POST' : 3,
                'MAX_DAYS_TO_CANCEL_VOTE' : 1,
                'VOTES_LEFT_WARNING_THRESHOLD' : 5,
            },
        },
    },
}
