/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.util.Random;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.FoldingException;

public class VirtualTable
extends AminoAcidTable {
    double maxEnergy = 1.0;

    @Override
    public void add(AminoAcid a, double probability) throws FoldingException {
        throw new FoldingException("can't add to virtual table");
    }

    @Override
    public void add(AminoAcid a) throws FoldingException {
        throw new FoldingException("can't add to virtual table");
    }

    @Override
    public String getName() {
        return "virtual";
    }

    @Override
    public AminoAcid get(String name) throws FoldingException {
        try {
            double hydrophobicIndex = new Double(name);
            int hydrogenbondIndex = new Integer(name);
            int ionicIndex = new Integer(name);
            this.updateMax(hydrophobicIndex);
            return new AminoAcid(hydrophobicIndex, hydrogenbondIndex, ionicIndex);
        }
        catch (NumberFormatException e) {
            throw new FoldingException("hydrophobic index " + name + " not a number");
        }
    }

    @Override
    public AminoAcid[] getRandom(int length, int seed) {
        AminoAcid[] sequence = new AminoAcid[length];
        Random random = new Random(seed);
        int i = 0;
        while (i < length) {
            double d = (double)random.nextInt(1000) / 1000.0;
            if (random.nextBoolean()) {
                d = -d;
            }
            this.updateMax(d);
            ++i;
        }
        return sequence;
    }

    private void updateMax(double d) {
        this.maxEnergy = Math.max(Math.abs(d), this.maxEnergy);
    }

    @Override
    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public static void main(String[] args) {
        VirtualTable t = new VirtualTable();
        AminoAcid[] list = ((AminoAcidTable)t).getRandom(15, 999);
        int i = 0;
        while (i < list.length) {
            System.out.println(list[i]);
            ++i;
        }
    }

    @Override
    public AminoAcid getFromAbName(String name) throws FoldingException {
        return null;
    }
}

