// Generated by LiveScript 1.2.0
(function(){
  var ref$, map, sortBy, ld, closestString, nameToRaw, camelize, dasherize;
  ref$ = require('prelude-ls'), map = ref$.map, sortBy = ref$.sortBy;
  ld = require('levenshtein-damerau');
  closestString = function(possibilities, input){
    var distances, ref$, string, distance;
    if (!possibilities.length) {
      return;
    }
    distances = map(function(it){
      var ref$, longer, shorter;
      ref$ = input.length > it.length
        ? [input, it]
        : [it, input], longer = ref$[0], shorter = ref$[1];
      return {
        string: it,
        distance: ld(longer, shorter)
      };
    })(
    possibilities);
    ref$ = sortBy(function(it){
      return it.distance;
    }, distances)[0], string = ref$.string, distance = ref$.distance;
    return string;
  };
  nameToRaw = function(name){
    if (name.length === 1 || name === 'NUM') {
      return "-" + name;
    } else {
      return "--" + name;
    }
  };
  camelize = function(it){
    return it.replace(/-[a-z]/ig, function(it){
      return it.charAt(1).toUpperCase();
    });
  };
  dasherize = function(string){
    if (/^[A-Z]/.test(string)) {
      return string;
    } else {
      return string.replace(/[A-Z]{2,}/g, function(it){
        return "-" + it;
      }).replace(/([a-z])([A-Z])/g, function(arg$, lower, upper){
        return lower + "-" + upper.toLowerCase();
      });
    }
  };
  module.exports = {
    closestString: closestString,
    nameToRaw: nameToRaw,
    camelize: camelize,
    dasherize: dasherize
  };
}).call(this);
