/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import protex.ProteinImageFactory;
import protex.ProteinImageSet;
import protex.Protex;
import protex.TargetShape;
import protex.TargetShapeList;

public class TargetShapeSelectionDialog
extends JDialog {
    private Protex protex;
    private TargetShapeList targetShapeList;
    private JButton cancelButton;

    public TargetShapeSelectionDialog(Protex protex) {
        super(protex, "Double-click a Target Shape", true);
        this.protex = protex;
        this.getContentPane().setLayout(new BorderLayout());
        this.targetShapeList = new TargetShapeList(new DefaultListModel(), this.protex);
        JScrollPane sp = new JScrollPane(this.targetShapeList);
        this.getContentPane().add((Component)sp, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setBounds(300, 300, 300, 300);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TargetShapeSelectionDialog.this.goAway();
            }
        });
    }

    public void showTargetShapeSelectionDialog() {
        block16: {
            File targetShapeFile = new File("target_shapes.txt");
            if (!targetShapeFile.exists()) {
                JOptionPane.showMessageDialog(null, "Could Not Find Target Shape File.", "File Not Found", 2);
                return;
            }
            this.targetShapeList.clearList();
            BufferedReader input = null;
            try {
                try {
                    input = new BufferedReader(new FileReader("target_shapes.txt"));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        if (line.indexOf(";") == -1) continue;
                        line = line.trim();
                        String[] parts = line.split(",");
                        ProteinImageSet imageSet = ProteinImageFactory.buildProtein(parts[1], this.protex.getStrictMatchingMode());
                        this.targetShapeList.add(new TargetShape(imageSet.getFullScaleImage(), imageSet.getThumbnailImage(), parts[0], parts[1]));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block16;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.setVisible(true);
    }

    public void goAway() {
        this.setVisible(false);
    }
}

