/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import protex.AminoAcid;
import protex.Direction;
import protex.GridCanvas;
import protex.HexCanvas;
import protex.HexGrid;
import protex.OutputPalette;
import protex.Polypeptide;
import protex.ProteinImageSet;
import protex.StandardTable;

public class ProteinImageFactory {
    private static final int thumbWidth = 130;
    private static final int thumbHeight = 70;

    public static ProteinImageSet generateImages(OutputPalette op) {
        return ProteinImageFactory.generateImages(op.getDrawingPane());
    }

    public static ProteinImageSet buildProtein(String foldingString, boolean strictMatchDisplayMode) {
        Direction[] directionArray = ProteinImageFactory.directionStringToDirectionArray(foldingString);
        HexCanvas hexCanvas = new HexCanvas();
        hexCanvas.setGrid(ProteinImageFactory.layoutOntoHexGrid(directionArray));
        hexCanvas.setStrictMatchDisplayMode(strictMatchDisplayMode);
        return ProteinImageFactory.generateImages(hexCanvas);
    }

    private static Direction[] directionStringToDirectionArray(String directionString) {
        int i;
        ArrayList<Direction> directionList = new ArrayList<Direction>();
        String[] parts = directionString.split(";");
        if (directionString.indexOf(":") != -1) {
            i = 0;
            while (i < parts.length) {
                String[] pieces = parts[i].split(":");
                directionList.add(Direction.getDirection(pieces[1]));
                ++i;
            }
        } else {
            i = 0;
            while (i < parts.length) {
                directionList.add(Direction.getDirection(parts[i]));
                ++i;
            }
        }
        Direction[] directionArray = new Direction[directionList.size()];
        int i2 = 0;
        while (i2 < directionList.size()) {
            directionArray[i2] = (Direction)directionList.get(i2);
            ++i2;
        }
        return directionArray;
    }

    public static HexGrid layoutOntoHexGrid(Direction[] directionArray) {
        int numAcids = directionArray.length;
        StandardTable aaTable = StandardTable.getInstance();
        AminoAcid acidX = aaTable.getFromAbName("X");
        AminoAcid[] aminoAcids = new AminoAcid[numAcids];
        int i = 0;
        while (i < numAcids) {
            aminoAcids[i] = acidX;
            ++i;
        }
        Polypeptide polypeptide = new Polypeptide(aaTable, aminoAcids, "");
        polypeptide.setDirections(directionArray);
        polypeptide.setFolded();
        return new HexGrid(polypeptide);
    }

    public static ProteinImageSet generateImages(GridCanvas gridCanvas) {
        gridCanvas.calculateRequiredCanvasSize();
        BufferedImage fullSizePic = new BufferedImage(gridCanvas.getRequiredCanvasSize().width, gridCanvas.getRequiredCanvasSize().height, 1);
        Graphics2D g = fullSizePic.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gridCanvas.paint(g);
        g.dispose();
        int imageWidth = fullSizePic.getWidth(null);
        int imageHeight = fullSizePic.getHeight(null);
        double imageRatio = (double)imageWidth / (double)imageHeight;
        double thumbRatio = 1.8571428571428572;
        int actualThumbHeight = 70;
        int actualThumbWidth = 130;
        if (thumbRatio < imageRatio) {
            actualThumbHeight = (int)(130.0 / imageRatio);
        } else {
            actualThumbWidth = (int)(70.0 * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(actualThumbWidth, actualThumbHeight, 1);
        Graphics2D smallG = thumbImage.createGraphics();
        smallG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        smallG.drawImage(fullSizePic, 0, 0, actualThumbWidth, actualThumbHeight, null);
        smallG.dispose();
        return new ProteinImageSet(fullSizePic, thumbImage);
    }
}

