/*
 * Decompiled with CFR 0.152.
 */
package protex;

import protex.BruteForceFolder;
import protex.Grid;
import protex.Polypeptide;

public class IncrementalFolder
extends BruteForceFolder {
    public static final int defaultLookAhead = 8;
    public static final int defaultStep = 4;
    private int lookAhead = 8;
    private int step = 4;
    int current;

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public String getName() {
        return "Incremental folding - lookahead: " + this.lookAhead + " step: " + this.step;
    }

    public IncrementalFolder(boolean custom, Polypeptide pp, Grid g, int lookAhead, int step) {
        this(custom, pp, g);
        this.lookAhead = lookAhead;
        this.step = step;
    }

    public IncrementalFolder(boolean custom, Polypeptide pp, Grid g) {
        super(custom, pp, g);
    }

    public void setLookAhead(int lookAhead) {
        this.lookAhead = lookAhead;
    }

    public void setStep(int step) {
        this.step = step;
    }

    @Override
    protected void placeRestOfAcids() {
        this.current = 2;
        while (this.current < this.numAcids) {
            this.resetEnergy();
            int localLookAhead = Math.min(this.current + this.lookAhead, this.numAcids);
            this.recurse(this.grid.getNextDirection(this.acids[this.current - 2].next), this.current, localLookAhead);
            this.restore();
            int i = this.current + this.step;
            while (i < localLookAhead) {
                this.grid.unset(this.acids[i]);
                ++i;
            }
            this.current += this.step;
        }
    }
}

