/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import protex.FoldedPolypeptide;
import protex.HistListPopupMenu;
import protex.HistoryCellRenderer;
import protex.Protex;

public class HistoryList
extends JList
implements Serializable {
    DefaultListModel histListDataModel;
    HistListPopupMenu histListPopupMenu;

    public HistoryList(ListModel dataModel, Protex protex) {
        super(dataModel);
        this.setSelectionMode(0);
        this.setCellRenderer(new HistoryCellRenderer());
        this.histListDataModel = (DefaultListModel)dataModel;
        this.setFixedCellWidth(20);
        this.histListPopupMenu = new HistListPopupMenu(this, protex);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    int x = evt.getX();
                    int y = evt.getY();
                    HistoryList.this.histListPopupMenu.show((Component)evt.getSource(), x - 10, y - 2);
                }
            }
        });
    }

    public void add(FoldedPolypeptide fp) {
        this.histListDataModel.addElement(fp);
    }

    public void deleteSelected() {
        if (this.getSelectedIndex() != -1) {
            this.histListDataModel.removeElementAt(this.getSelectedIndex());
        } else {
            JOptionPane.showMessageDialog(null, "You have not selected an item to delete.", "None Selected", 2);
        }
    }

    public void clearList() {
        this.histListDataModel.removeAllElements();
    }

    public Object[] getAll() {
        return this.histListDataModel.toArray();
    }
}

