/*
 *  /MathJax/config/AM_HTMLorMML.js
 *  
 *  Copyright (c) 2010-11 Design Science, Inc.
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/AsciiMath/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/asciimath2jax.js",
  "[MathJax]/extensions/MathEvents.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/AsciiMath/jax.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.AsciiMath=MathJax.InputJax({id:"AsciiMath",version:"2.0",directory:MathJax.InputJax.directory+"/AsciiMath",extensionDir:MathJax.InputJax.extensionDir+"/AsciiMath",config:{displaystyle:true,decimal:"."}});MathJax.InputJax.AsciiMath.Register("math/asciimath");MathJax.InputJax.AsciiMath.loadComplete("config.js");

MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"2.0",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",mtextFontInherit:false,EqnChunk:(MathJax.Hub.Browser.isMobile?10:50),EqnChunkFactor:1.5,EqnChunkDelay:100,linebreaks:{automatic:false,width:"container"},styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-style":"normal","font-size":"90%"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px"}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set("Your browser does not support MathJax",null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");

MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"2.0",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{scale:100,minScaleAdjust:50,styles:{"DIV.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}MathJax.OutputJax.NativeMML.loadComplete("config.js");

(function(c,g){var f="2.0";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"HTML",Opera:"HTML",Chrome:"HTML",Safari:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(g.version==="0.0"||g.versionAtLeast(e[g]||0));var d=(g.isFirefox&&g.versionAtLeast("1.5"))||(g.isMSIE&&g.hasMathPlayer)||(g.isSafari&&g.versionAtLeast("5.0"))||(g.isOpera&&g.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var h=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(h==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}c.Startup.signal.Post("NativeMML output selected")}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}c.Startup.signal.Post("HTML-CSS output selected")}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set("Your browser does not support MathJax",null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub,MathJax.Hub.Browser);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");

MathJax.Extension.asciimath2jax={version:"2.0",config:{delimiters:[["`","`"]],skipTags:["script","noscript","style","textarea","pre","code"],ignoreClass:"asciimath2jax_ignore",processClass:"asciimath2jax_process",preview:"AsciiMath"},PreProcess:function(a){if(!this.configured){this.config=MathJax.Hub.CombineConfig("asciimath2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.configured=true}if(typeof(a)==="string"){a=document.getElementById(a)}if(!a){a=document.body}if(this.createPatterns()){this.scanElement(a,a.nextSibling)}},createPatterns:function(){var d=[],c,a,b=this.config;this.match={};if(b.delimiters.length===0){return false}for(c=0,a=b.delimiters.length;c<a;c++){d.push(this.patternQuote(b.delimiters[c][0]));this.match[b.delimiters[c][0]]={mode:"",end:b.delimiters[c][1],pattern:this.endPattern(b.delimiters[c][1])}}this.start=new RegExp(d.sort(this.sortLength).join("|"),"g");this.skipTags=new RegExp("^("+b.skipTags.join("|")+")$","i");this.ignoreClass=new RegExp("(^| )("+b.ignoreClass+")( |$)");this.processClass=new RegExp("(^| )("+b.processClass+")( |$)");return true},patternQuote:function(a){return a.replace(/([\^$(){}+*?\-|\[\]\:\\])/g,"\\$1")},endPattern:function(a){return new RegExp(this.patternQuote(a)+"|\\\\.","g")},sortLength:function(d,c){if(d.length!==c.length){return c.length-d.length}return(d==c?0:(d<c?-1:1))},scanElement:function(c,b,g){var a,e,d,f;while(c&&c!=b){if(c.nodeName.toLowerCase()==="#text"){if(!g){c=this.scanText(c)}}else{a=(typeof(c.className)==="undefined"?"":c.className);e=(typeof(c.tagName)==="undefined"?"":c.tagName);if(typeof(a)!=="string"){a=String(a)}f=this.processClass.exec(a);if(c.firstChild&&!a.match(/(^| )MathJax/)&&(f||!this.skipTags.exec(e))){d=(g||this.ignoreClass.exec(a))&&!f;this.scanElement(c.firstChild,b,d)}}if(c){c=c.nextSibling}}},scanText:function(b){if(b.nodeValue.replace(/\s+/,"")==""){return b}var a,c;this.search={start:true};this.pattern=this.start;while(b){this.pattern.lastIndex=0;while(b&&b.nodeName.toLowerCase()==="#text"&&(a=this.pattern.exec(b.nodeValue))){if(this.search.start){b=this.startMatch(a,b)}else{b=this.endMatch(a,b)}}if(this.search.matched){b=this.encloseMath(b)}if(b){do{c=b;b=b.nextSibling}while(b&&(b.nodeName.toLowerCase()==="br"||b.nodeName.toLowerCase()==="#comment"));if(!b||b.nodeName!=="#text"){return c}}}return b},startMatch:function(a,b){var c=this.match[a[0]];if(c!=null){this.search={end:c.end,mode:c.mode,open:b,olen:a[0].length,opos:this.pattern.lastIndex-a[0].length};this.switchPattern(c.pattern)}return b},endMatch:function(a,b){if(a[0]==this.search.end){this.search.close=b;this.search.cpos=this.pattern.lastIndex;this.search.clen=(this.search.isBeginEnd?0:a[0].length);this.search.matched=true;b=this.encloseMath(b);this.switchPattern(this.start)}return b},switchPattern:function(a){a.lastIndex=this.pattern.lastIndex;this.pattern=a;this.search.start=(a===this.start)},encloseMath:function(b){var a=this.search,f=a.close,e,c;if(a.cpos===f.length){f=f.nextSibling}else{f=f.splitText(a.cpos)}if(!f){e=f=MathJax.HTML.addText(a.close.parentNode,"")}a.close=f;c=(a.opos?a.open.splitText(a.opos):a.open);while(c.nextSibling&&c.nextSibling!==f){if(c.nextSibling.nodeValue!==null){if(c.nextSibling.nodeName==="#comment"){c.nodeValue+=c.nextSibling.nodeValue.replace(/^\[CDATA\[((.|\n|\r)*)\]\]$/,"$1")}else{c.nodeValue+=c.nextSibling.nodeValue}}else{if(this.msieNewlineBug){c.nodeValue+=(c.nextSibling.nodeName.toLowerCase()==="br"?"\n":" ")}else{c.nodeValue+=" "}}c.parentNode.removeChild(c.nextSibling)}var d=c.nodeValue.substr(a.olen,c.nodeValue.length-a.olen-a.clen);c.parentNode.removeChild(c);if(this.config.preview!=="none"){this.createPreview(a.mode,d)}c=this.createMathTag(a.mode,d);this.search={};this.pattern.lastIndex=0;if(e){e.parentNode.removeChild(e)}return c},insertNode:function(b){var a=this.search;a.close.parentNode.insertBefore(b,a.close)},createPreview:function(c,a){var b;if(this.config.preview==="AsciiMath"){b=[this.filterPreview(a)]}else{if(this.config.preview instanceof Array){b=this.config.preview}}if(b){b=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},b);this.insertNode(b)}},createMathTag:function(c,a){var b=document.createElement("script");b.type="math/asciimath"+c;MathJax.HTML.setScript(b,a);this.insertNode(b);return b},filterPreview:function(a){return a},msieNewlineBug:(MathJax.Hub.Browser.isMSIE&&(document.documentMode||0)<9)};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.asciimath2jax]);MathJax.Ajax.loadComplete("[MathJax]/extensions/asciimath2jax.js");

(function(d,h,l,g,b,j){var p="2.0";var i=MathJax.Extension;var c=i.MathEvents={version:p};var k=d.config.menuSettings;var o={hover:500,frame:{x:3.5,y:5,bwidth:1,bcolor:"#A6D",hwidth:"15px",hcolor:"#83A"},button:{x:-4,y:-3,wx:-2,src:l.fileURL(b.imageDir+"/MenuArrow-15.png")},fadeinInc:0.2,fadeoutInc:0.05,fadeDelay:50,fadeoutStart:400,fadeoutDelay:15*1000,styles:{".MathJax_Hover_Frame":{"border-radius":".25em","-webkit-border-radius":".25em","-moz-border-radius":".25em","-khtml-border-radius":".25em","box-shadow":"0px 0px 15px #83A","-webkit-box-shadow":"0px 0px 15px #83A","-moz-box-shadow":"0px 0px 15px #83A","-khtml-box-shadow":"0px 0px 15px #83A",border:"1px solid #A6D ! important",display:"inline-block",position:"absolute"},".MathJax_Hover_Arrow":{position:"absolute",width:"15px",height:"11px",cursor:"pointer"}}};var m=c.Event={LEFTBUTTON:0,RIGHTBUTTON:2,MENUKEY:"altKey",Mousedown:function(q){return m.Handler(q,"Mousedown",this)},Mouseup:function(q){return m.Handler(q,"Mouseup",this)},Mousemove:function(q){return m.Handler(q,"Mousemove",this)},Mouseover:function(q){return m.Handler(q,"Mouseover",this)},Mouseout:function(q){return m.Handler(q,"Mouseout",this)},Click:function(q){return m.Handler(q,"Click",this)},DblClick:function(q){return m.Handler(q,"DblClick",this)},Menu:function(q){return m.Handler(q,"ContextMenu",this)},Handler:function(t,r,s){if(l.loadingMathMenu){return m.False(t)}var q=b[s.jaxID];if(!t){t=window.event}t.isContextMenu=(r==="ContextMenu");if(q[r]){return q[r](t,s)}if(i.MathZoom){return i.MathZoom.HandleEvent(t,r,s)}},False:function(q){if(!q){q=window.event}if(q){if(q.preventDefault){q.preventDefault()}if(q.stopPropagation){q.stopPropagation()}q.cancelBubble=true;q.returnValue=false}return false},ContextMenu:function(r,y,u){var w=b[y.jaxID],t=w.getJaxFromMath(y);var z=(w.config.showMathMenu!=null?w:d).config.showMathMenu;if(!z||(k.context!=="MathJax"&&!u)){return}if(c.msieEventBug){r=window.event||r}m.ClearSelection();f.ClearHoverTimer();if(t.hover){if(t.hover.remove){clearTimeout(t.hover.remove);delete t.hover.remove}t.hover.nofade=true}var s=MathJax.Menu;if(s){s.jax=t;var q=s.menu.Find("Show Math As").menu;q.items[1].name=(j[t.inputJax].sourceMenuTitle||"Original Form");q.items[0].hidden=(t.inputJax==="Error");var v=s.menu.Find("Math Settings","MathPlayer");v.hidden=!(t.outputJax==="NativeMML"&&d.Browser.hasMathPlayer);return s.menu.Post(r)}else{if(!l.loadingMathMenu){l.loadingMathMenu=true;var x={pageX:r.pageX,pageY:r.pageY,clientX:r.clientX,clientY:r.clientY};g.Queue(l.Require("[MathJax]/extensions/MathMenu.js"),function(){delete l.loadingMathMenu;if(!MathJax.Menu){MathJax.Menu={}}},["ContextMenu",this,x,y,u])}return m.False(r)}},AltContextMenu:function(s,r){var t=b[r.jaxID];var q=(t.config.showMathMenu!=null?t:d).config.showMathMenu;if(q){q=(t.config.showMathMenuMSIE!=null?t:d).config.showMathMenuMSIE;if(k.context==="MathJax"&&!k.mpContext&&q){if(!c.noContextMenuBug||s.button!==m.RIGHTBUTTON){return}}else{if(!s[m.MENUKEY]||s.button!==m.LEFTBUTTON){return}}return t.ContextMenu(s,r,true)}},ClearSelection:function(){if(c.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(document.selection){setTimeout("document.selection.empty()",0)}},getBBox:function(s){s.appendChild(c.topImg);var r=c.topImg.offsetTop,t=s.offsetHeight-r,q=s.offsetWidth;s.removeChild(c.topImg);return{w:q,h:r,d:t}}};var f=c.Hover={Mouseover:function(s,r){if(k.discoverable||k.zoom==="Hover"){var u=s.fromElement||s.relatedTarget,t=s.toElement||s.target;if(u&&t&&(u.isMathJax!=t.isMathJax||d.getJaxFor(u)!==d.getJaxFor(t))){var q=this.getJaxFromMath(r);if(q.hover){f.ReHover(q)}else{f.HoverTimer(q,r)}return m.False(s)}}},Mouseout:function(s,r){if(k.discoverable||k.zoom==="Hover"){var u=s.fromElement||s.relatedTarget,t=s.toElement||s.target;if(u&&t&&(u.isMathJax!=t.isMathJax||d.getJaxFor(u)!==d.getJaxFor(t))){var q=this.getJaxFromMath(r);if(q.hover){f.UnHover(q)}else{f.ClearHoverTimer()}return m.False(s)}}},Mousemove:function(s,r){if(k.discoverable||k.zoom==="Hover"){var q=this.getJaxFromMath(r);if(q.hover){return}if(f.lastX==s.clientX&&f.lastY==s.clientY){return}f.lastX=s.clientX;f.lastY=s.clientY;f.HoverTimer(q,r);return m.False(s)}},HoverTimer:function(q,r){this.ClearHoverTimer();this.hoverTimer=setTimeout(g(["Hover",this,q,r]),o.hover)},ClearHoverTimer:function(){if(this.hoverTimer){clearTimeout(this.hoverTimer);delete this.hoverTimer}},Hover:function(q,u){if(i.MathZoom&&i.MathZoom.Hover({},u)){return}var t=b[q.outputJax],v=t.getHoverSpan(q,u),y=t.getHoverBBox(q,v,u),w=(t.config.showMathMenu!=null?t:d).config.showMathMenu;var A=o.frame.x,z=o.frame.y,x=o.frame.bwidth;if(c.msieBorderWidthBug){x=0}q.hover={opacity:0,id:q.inputID+"-Hover"};var r=h.Element("span",{id:q.hover.id,isMathJax:true,style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{className:"MathJax_Hover_Frame",isMathJax:true,style:{display:"inline-block",position:"absolute",top:this.Px(-y.h-z-x-(y.y||0)),left:this.Px(-A-x+(y.x||0)),width:this.Px(y.w+2*A),height:this.Px(y.h+y.d+2*z),opacity:0,filter:"alpha(opacity=0)"}}]]);var s=h.Element("span",{isMathJax:true,id:q.hover.id+"Menu",style:{display:"inline-block","z-index":1,width:0,height:0,position:"relative"}},[["img",{className:"MathJax_Hover_Arrow",isMathJax:true,math:u,src:o.button.src,onclick:this.HoverMenu,jax:t.id,style:{left:this.Px(y.w+A+x+(y.x||0)+o.button.x),top:this.Px(-y.h-z-x-(y.y||0)-o.button.y),opacity:0,filter:"alpha(opacity=0)"}}]]);if(y.width){r.style.width=s.style.width=y.width;r.style.marginRight=s.style.marginRight="-"+y.width;r.firstChild.style.width=y.width;s.firstChild.style.left="";s.firstChild.style.right=this.Px(o.button.wx)}v.parentNode.insertBefore(r,v);if(w){v.parentNode.insertBefore(s,v)}if(v.style){v.style.position="relative"}this.ReHover(q)},ReHover:function(q){if(q.hover.remove){clearTimeout(q.hover.remove)}q.hover.remove=setTimeout(g(["UnHover",this,q]),o.fadeoutDelay);this.HoverFadeTimer(q,o.fadeinInc)},UnHover:function(q){if(!q.hover.nofade){this.HoverFadeTimer(q,-o.fadeoutInc,o.fadeoutStart)}},HoverFade:function(q){delete q.hover.timer;q.hover.opacity=Math.max(0,Math.min(1,q.hover.opacity+q.hover.inc));q.hover.opacity=Math.floor(1000*q.hover.opacity)/1000;var s=document.getElementById(q.hover.id),r=document.getElementById(q.hover.id+"Menu");s.firstChild.style.opacity=q.hover.opacity;s.firstChild.style.filter="alpha(opacity="+Math.floor(100*q.hover.opacity)+")";if(r){r.firstChild.style.opacity=q.hover.opacity;r.firstChild.style.filter=s.style.filter}if(q.hover.opacity===1){return}if(q.hover.opacity>0){this.HoverFadeTimer(q,q.hover.inc);return}s.parentNode.removeChild(s);if(r){r.parentNode.removeChild(r)}if(q.hover.remove){clearTimeout(q.hover.remove)}delete q.hover},HoverFadeTimer:function(q,s,r){q.hover.inc=s;if(!q.hover.timer){q.hover.timer=setTimeout(g(["HoverFade",this,q]),(r||o.fadeDelay))}},HoverMenu:function(q){if(!q){q=window.event}return b[this.jax].ContextMenu(q,this.math,true)},ClearHover:function(q){if(q.hover.remove){clearTimeout(q.hover.remove)}if(q.hover.timer){clearTimeout(q.hover.timer)}f.ClearHoverTimer();delete q.hover},Px:function(q){if(Math.abs(q)<0.006){return"0px"}return q.toFixed(2).replace(/\.?0+$/,"")+"px"},getImages:function(){var q=new Image();q.src=o.button.src}};var a=c.Touch={last:0,delay:500,start:function(r){var q=new Date().getTime();var s=(q-a.last<a.delay);a.last=q;if(s){a.timeout=setTimeout(a.menu,a.delay,r,this);r.preventDefault()}},end:function(q){if(a.timeout){clearTimeout(a.timeout);delete a.timeout;a.last=0;q.preventDefault();return m.Handler((q.touches[0]||q.touch),"DblClick",this)}},menu:function(r,q){delete a.timeout;a.last=0;return m.Handler((r.touches[0]||r.touch),"ContextMenu",q)}};if(d.Browser.isMobile){var n=o.styles[".MathJax_Hover_Arrow"];n.width="25px";n.height="18px";o.button.x=-6}d.Browser.Select({MSIE:function(q){var s=(document.documentMode||0);var r=q.versionAtLeast("8.0");c.msieBorderWidthBug=(document.compatMode==="BackCompat");c.msieEventBug=q.isIE9;c.msieAlignBug=(!r||s<8);if(s<9){m.LEFTBUTTON=1}},Safari:function(q){c.safariContextMenuBug=true},Opera:function(q){c.operaPositionBug=true},Konqueror:function(q){c.noContextMenuBug=true}});c.topImg=(c.msieAlignBug?h.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):h.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(c.operaPositionBug){c.topImg.style.border="1px solid"}c.config=o=d.CombineConfig("MathEvents",o);var e=function(){var q=o.styles[".MathJax_Hover_Frame"];q.border=o.frame.bwidth+"px solid "+o.frame.bcolor+" ! important";q["box-shadow"]=q["-webkit-box-shadow"]=q["-moz-box-shadow"]=q["-khtml-box-shadow"]="0px 0px "+o.frame.hwidth+" "+o.frame.hcolor};g.Queue(d.Register.StartupHook("End Config",{}),[e],["getImages",f],["Styles",l,o.styles],["Post",d.Startup.signal,"MathEvents Ready"],["loadComplete",l,"[MathJax]/extensions/MathEvents.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.Callback,MathJax.OutputJax,MathJax.InputJax);

(function(a,d,f,c,j){var k="2.0";var i=a.CombineConfig("MathZoom",{styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"},"#MathJax_ZoomEventTrap":{position:"absolute",left:0,top:0,"z-index":302,display:"inline-block",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var e,b,g;MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){g=MathJax.Extension.MathEvents.Event;e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Hover});var h=MathJax.Extension.MathZoom={version:k,settings:a.config.menuSettings,scrollSize:18,HandleEvent:function(n,l,m){if(h.settings.CTRL&&!n.ctrlKey){return true}if(h.settings.ALT&&!n.altKey){return true}if(h.settings.CMD&&!n.metaKey){return true}if(h.settings.Shift&&!n.shiftKey){return true}if(!h[l]){return true}return h[l](n,m)},Click:function(m,l){if(this.settings.zoom==="Click"){return this.Zoom(m,l)}},DblClick:function(m,l){if(this.settings.zoom==="Double-Click"){return this.Zoom(m,l)}},Hover:function(m,l){if(this.settings.zoom==="Hover"){this.Zoom(m,l);return true}return false},Zoom:function(n,s){this.Remove();b.ClearHoverTimer();g.ClearSelection();var q=MathJax.OutputJax[s.jaxID];var o=q.getJaxFromMath(s);if(o.hover){b.UnHover(o)}var l=Math.floor(0.85*document.body.clientWidth),r=Math.floor(0.85*Math.max(document.body.clientHeight,document.documentElement.clientHeight));var m=d.Element("span",{style:{position:"relative",display:"inline-block",height:0,width:0},id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale,"max-width":l+"px","max-height":r+"px"}},[["span",{style:{display:"inline-block","white-space":"nowrap"}}]]]]);var x=m.lastChild,u=x.firstChild,p=m.firstChild;s.parentNode.insertBefore(m,s);if(u.addEventListener){u.addEventListener("mousedown",this.Remove,true)}if(this.msieTrapEventBug){var w=d.Element("span",{id:"MathJax_ZoomEventTrap",onmousedown:this.Remove});m.insertBefore(w,x)}if(this.msieZIndexBug){var t=d.addElement(document.body,"img",{src:"about:blank",id:"MathJax_ZoomTracker",width:0,height:0,style:{width:0,height:0,position:"relative"}});m.style.position="relative";m.style.zIndex=i.styles["#MathJax_ZoomOverlay"]["z-index"];m=t}var v=q.Zoom(o,u,s,l,r);if(this.msiePositionBug){if(this.msieSizeBug){x.style.height=v.zH+"px";x.style.width=v.zW+"px"}if(x.offsetHeight>r){x.style.height=r+"px";x.style.width=(v.zW+this.scrollSize)+"px"}if(x.offsetWidth>l){x.style.width=l+"px";x.style.height=(v.zH+this.scrollSize)+"px"}}if(this.operaPositionBug){x.style.width=Math.min(l,v.zW)+"px"}if(x.offsetWidth<l&&x.offsetHeight<r){x.style.overflow="visible"}this.Position(x,v);if(this.msieTrapEventBug){w.style.height=x.clientHeight+"px";w.style.width=x.clientWidth+"px";w.style.left=(parseFloat(x.style.left)+x.clientLeft)+"px";w.style.top=(parseFloat(x.style.top)+x.clientTop)+"px"}x.style.visibility="";if(this.settings.zoom==="Hover"){p.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}a.signal.Post(["math zoomed",o]);return e(n)},Position:function(p,r){var q=this.Resize(),m=q.x,s=q.y,l=r.mW;var o=-Math.floor((p.offsetWidth-l)/2),n=r.Y;p.style.left=Math.max(o,10-m)+"px";p.style.top=Math.max(n,10-s)+"px";if(!h.msiePositionBug){h.SetWH()}},Resize:function(n){if(h.onresize){h.onresize(n)}var l=0,q=0,o,p=document.getElementById("MathJax_ZoomFrame"),m=document.getElementById("MathJax_ZoomOverlay");o=p;while(o.offsetParent){l+=o.offsetLeft;o=o.offsetParent}if(h.operaPositionBug){p.style.border="1px solid"}o=p;while(o.offsetParent){q+=o.offsetTop;o=o.offsetParent}if(h.operaPositionBug){p.style.border=""}m.style.left=(-l)+"px";m.style.top=(-q)+"px";if(h.msiePositionBug){setTimeout(h.SetWH,0)}else{h.SetWH()}return{x:l,y:q}},SetWH:function(){var l=document.getElementById("MathJax_ZoomOverlay");l.style.width=l.style.height="1px";var m=document.documentElement||document.body;l.style.width=m.scrollWidth+"px";l.style.height=Math.max(m.clientHeight,m.scrollHeight)+"px"},Remove:function(n){var p=document.getElementById("MathJax_ZoomFrame");if(p){var o=MathJax.OutputJax[p.nextSibling.jaxID];var l=o.getJaxFromMath(p.nextSibling);a.signal.Post(["math unzoomed",l]);p.parentNode.removeChild(p);p=document.getElementById("MathJax_ZoomTracker");if(p){p.parentNode.removeChild(p)}if(h.operaRefreshBug){var m=d.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(m)}if(window.removeEventListener){removeEventListener("resize",h.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",h.Resize)}else{window.onresize=h.onresize;delete h.onresize}}}return e(n)}};a.Browser.Select({MSIE:function(l){var n=(document.documentMode||0);var m=(n>=9);h.msiePositionBug=!m;h.msieSizeBug=l.versionAtLeast("7.0")&&(!document.documentMode||n===7||n===8);h.msieZIndexBug=(n<=7);h.msieInlineBlockAlignBug=(n<=7);h.msieTrapEventBug=!window.addEventListener;if(document.compatMode==="BackCompat"){h.scrollSize=52}if(m){delete i.styles["#MathJax_Zoom"].filter}},Opera:function(l){h.operaPositionBug=true;h.operaRefreshBug=true}});h.topImg=(h.msieInlineBlockAlignBug?d.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):d.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(h.operaPositionBug||h.msieTopBug){h.topImg.style.border="1px solid"}MathJax.Callback.Queue(["StartupHook",MathJax.Hub.Register,"Begin Styles",{}],["Styles",f,i.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",f,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);

(function(c,g,k,f,b){var p="2.0";var j=MathJax.Callback.Signal("menu");MathJax.Extension.MathMenu={version:p,signal:j};var n=c.Browser.isPC,l=c.Browser.isMSIE,e=((document.documentMode||0)>8);var i=(n?null:"5px");var o=c.CombineConfig("MathMenu",{delay:150,helpURL:"http://www.mathjax.org/help-v2/user/",closeImg:k.fileURL(b.imageDir+"/CloseX-31.png"),showRenderer:true,showMathPlayer:true,showFontMenu:false,showContext:false,showDiscoverable:false,windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:100,height:50},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(n?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":i,"-webkit-border-radius":i,"-moz-border-radius":i,"-khtml-border-radius":i,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(n?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuTitle":{"background-color":"#CCCCCC",margin:(n?"-1px -1px 1px -1px":"-5px 0 0 0"),"text-align":"center","font-style":"italic","font-size":"80%",color:"#444444",padding:"2px 0",overflow:"hidden"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuRadioCheck":{position:"absolute",left:(n?"1em":".7em")},".MathJax_MenuLabel":{padding:(n?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(n?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(n?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(n?"Highlight":"#606872"),color:(n?"HighlightText":"white")},".MathJax_Menu_Close":{position:"absolute",width:"31px",height:"31px",top:"-15px",left:"-15px"}}});var h,d;c.Register.StartupHook("MathEvents Ready",function(){h=MathJax.Extension.MathEvents.Event.False;d=MathJax.Extension.MathEvents.Hover});var a=MathJax.Menu=MathJax.Object.Subclass({version:p,items:[],posted:false,title:null,margin:5,Init:function(q){this.items=[].slice.call(arguments,0)},With:function(q){if(q){c.Insert(this,q)}return this},Post:function(r,B){if(!r){r=window.event}var z=(!this.title?null:[["div",{className:"MathJax_MenuTitle"},[this.title]]]);var q=document.getElementById("MathJax_MenuFrame");if(!q){q=a.Background(this);delete m.lastItem;delete m.lastMenu;delete a.skipUp;j.Post(["post",a.jax])}var s=g.addElement(q,"div",{onmouseup:a.Mouseup,ondblclick:h,ondragstart:h,onselectstart:h,oncontextmenu:h,menuItem:this,className:"MathJax_Menu"},z);for(var u=0,t=this.items.length;u<t;u++){this.items[u].Create(s)}if(a.isMobile){g.addElement(s,"span",{className:"MathJax_Menu_Close",menu:B,ontouchstart:a.Close,ontouchend:h,onmousedown:a.Close,onmouseup:h},[["img",{src:o.closeImg,style:{width:"100%",height:"100%"}}]])}this.posted=true;s.style.width=(s.offsetWidth+2)+"px";var A=r.pageX,w=r.pageY;if(!A&&!w){A=r.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;w=r.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!B){if(A+s.offsetWidth>document.body.offsetWidth-this.margin){A=document.body.offsetWidth-s.offsetWidth-this.margin}if(a.isMobile){A=Math.max(5,A-Math.floor(s.offsetWidth/2));w-=20}a.skipUp=r.isContextMenu}else{var v="left",C=B.offsetWidth;A=(a.isMobile?30:C-2);w=0;while(B&&B!==q){A+=B.offsetLeft;w+=B.offsetTop;B=B.parentNode}if(A+s.offsetWidth>document.body.offsetWidth-this.margin&&!a.isMobile){v="right";A=Math.max(this.margin,A-C-s.offsetWidth+6)}if(!n){s.style["borderRadiusTop"+v]=0;s.style["WebkitBorderRadiusTop"+v]=0;s.style["MozBorderRadiusTop"+v]=0;s.style["KhtmlBorderRadiusTop"+v]=0}}s.style.left=A+"px";s.style.top=w+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return h(r)},Remove:function(q,r){j.Post(["unpost",a.jax]);var s=document.getElementById("MathJax_MenuFrame");if(s){s.parentNode.removeChild(s);if(this.msieFixedPositionBug){detachEvent("onresize",a.Resize)}}if(a.jax.hover){delete a.jax.hover.nofade;d.UnHover(a.jax)}return h(q)},Find:function(r){var t=[].slice.call(arguments,1);for(var s=0,q=this.items.length;s<q;s++){if(this.items[s].name===r){if(t.length){if(!this.items[s].menu){return null}return this.items[s].menu.Find.apply(this.items[s].menu,t)}return this.items[s]}}return null},IndexOf:function(r){for(var s=0,q=this.items.length;s<q;s++){if(this.items[s].name===r){return s}}return null}},{config:o,div:null,Close:function(q){return a.Event(q,this.menu||this.parentNode,(this.menu?"Touchend":"Remove"))},Remove:function(q){return a.Event(q,this,"Remove")},Mouseover:function(q){return a.Event(q,this,"Mouseover")},Mouseout:function(q){return a.Event(q,this,"Mouseout")},Mousedown:function(q){return a.Event(q,this,"Mousedown")},Mouseup:function(q){return a.Event(q,this,"Mouseup")},Touchstart:function(q){return a.Event(q,this,"Touchstart")},Touchend:function(q){return a.Event(q,this,"Touchend")},Event:function(s,u,q,t){if(a.skipMouseover&&q==="Mouseover"&&!t){return h(s)}if(a.skipUp){if(q.match(/Mouseup|Touchend/)){delete a.skipUp;return h(s)}if(q==="Touchstart"||(q==="Mousedown"&&!a.skipMousedown)){delete a.skipUp}}if(!s){s=window.event}var r=u.menuItem;if(r&&r[q]){return r[q](s,u)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(r){var s=g.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:r,onmousedown:this.Remove}]]);var q=s.firstChild;if(r.msieBackgroundBug){q.style.backgroundColor="white";q.style.filter="alpha(opacity=0)"}if(r.msieFixedPositionBug){s.width=s.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{q.style.position="fixed"}return s},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var q=document.getElementById("MathJax_MenuFrame");if(q){q=q.firstChild;q.style.width=q.style.height="1px";q.style.width=document.body.scrollWidth+"px";q.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){g.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=g.Cookie.Get("menu")},getImages:function(){if(a.isMobile){var q=new Image();q.src=o.closeImg}}});var m=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(r){if(!this.hidden){var q={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:a.Mousedown,ondragstart:h,onselectstart:h,onselectend:h,ontouchstart:a.Touchstart,ontouchend:a.Touchend,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){q.className+=" MathJax_MenuDisabled"}g.addElement(r,"div",q,this.Label(q,r))}},Mouseover:function(u,w){if(!this.disabled){this.Activate(w)}if(!this.menu||!this.menu.posted){var v=document.getElementById("MathJax_MenuFrame").childNodes,r=w.parentNode.childNodes;for(var s=0,q=r.length;s<q;s++){var t=r[s].menuItem;if(t&&t.menu&&t.menu.posted){t.Deactivate(r[s])}}q=v.length-1;while(q>=0&&w.parentNode.menuItem!==v[q].menuItem){v[q].menuItem.posted=false;v[q].parentNode.removeChild(v[q]);q--}if(this.Timer&&!a.isMobile){this.Timer(u,w)}}},Mouseout:function(q,r){if(!this.menu||!this.menu.posted){this.Deactivate(r)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(q,r){return this.Remove(q,r)},Touchstart:function(q,r){return this.TouchEvent(q,r,"Mousedown")},Touchend:function(q,r){return this.TouchEvent(q,r,"Mouseup")},TouchEvent:function(r,s,q){if(this!==m.lastItem){if(m.lastMenu){a.Event(r,m.lastMenu,"Mouseout")}a.Event(r,s,"Mouseover",true);m.lastItem=this;m.lastMenu=s}if(this.nativeTouch){return null}a.Event(r,s,q);return false},Remove:function(q,r){r=r.parentNode.menuItem;return r.Remove(q,r)},Activate:function(q){this.Deactivate(q);q.className+=" MathJax_MenuActive"},Deactivate:function(q){q.className=q.className.replace(/ MathJax_MenuActive/,"")},With:function(q){if(q){c.Insert(this,q)}return this}});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(q,s,r){this.name=q;this.action=s;this.With(r)},Label:function(q,r){return[this.name]},Mouseup:function(q,r){if(!this.disabled){this.Remove(q,r);j.Post(["command",this]);this.action.call(this,q)}return h(q)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(n&&!c.Browser.isSafari?"\u25B6":"\u25B8"),Init:function(q,s){this.name=q;var r=1;if(!(s instanceof a.ITEM)){this.With(s),r++}this.menu=a.apply(a,[].slice.call(arguments,r))},Label:function(q,r){this.menu.posted=false;return[this.name+" ",["span",{className:"MathJax_MenuArrow"},[this.marker]]]},Timer:function(q,r){if(this.timer){clearTimeout(this.timer)}q={clientX:q.clientX,clientY:q.clientY};this.timer=setTimeout(f(["Mouseup",this,q,r]),o.delay)},Touchend:function(r,t){var s=this.menu.posted;var q=this.SUPER(arguments).Touchend.apply(this,arguments);if(s){this.Deactivate(t);delete m.lastItem;delete m.lastMenu}return q},Mouseup:function(r,t){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(r,t)}else{var s=document.getElementById("MathJax_MenuFrame").childNodes,q=s.length-1;while(q>=0){var u=s[q];u.menuItem.posted=false;u.parentNode.removeChild(u);if(u.menuItem===this.menu){break}q--}}}return h(r)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(n?"\u25CF":"\u2713"),Init:function(r,q,s){this.name=r;this.variable=q;this.With(s);if(this.value==null){this.value=this.name}},Label:function(r,s){var q={className:"MathJax_MenuRadioCheck"};if(o.settings[this.variable]!==this.value){q={style:{display:"none"}}}return[["span",q,[this.marker]]," "+this.name]},Mouseup:function(t,u){if(!this.disabled){var v=u.parentNode.childNodes;for(var r=0,q=v.length;r<q;r++){var s=v[r].menuItem;if(s&&s.variable===this.variable){v[r].firstChild.style.display="none"}}u.firstChild.display="";o.settings[this.variable]=this.value;a.cookie[this.variable]=o.settings[this.variable];a.saveCookie();j.Post(["radio button",this])}this.Remove(t,u);if(this.action&&!this.disabled){this.action.call(a,this)}return h(t)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(r,q,s){this.name=r;this.variable=q;this.With(s)},Label:function(r,s){var q={className:"MathJax_MenuCheck"};if(!o.settings[this.variable]){q={style:{display:"none"}}}return[["span",q,[this.marker]]," "+this.name]},Mouseup:function(q,r){if(!this.disabled){r.firstChild.display=(o.settings[this.variable]?"none":"");o.settings[this.variable]=!o.settings[this.variable];a.cookie[this.variable]=o.settings[this.variable];a.saveCookie();j.Post(["checkbox",this])}this.Remove(q,r);if(this.action&&!this.disabled){this.action.call(a,this)}return h(q)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(q,r){this.name=q;this.With(r)},Label:function(q,r){delete q.onmouseover,delete q.onmouseout;delete q.onmousedown;q.className+=" MathJax_MenuLabel";return[this.name]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(q,r){delete q.onmouseover,delete q.onmouseout;delete q.onmousedown;q.className+=" MathJax_MenuRule";return null}});a.About=function(){var t=b["HTML-CSS"]||{fontInUse:""};var v=(t.webFonts?"":"local "),r=(t.webFonts?" web":"");var s=(t.imgFonts?"Image":v+t.fontInUse+r)+" fonts";if(s==="local  fonts"&&b.SVG){s="web SVG fonts"}var q=["MathJax.js v"+MathJax.fileversion,["br"]];q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(q,MathJax.InputJax,"Input Jax");a.About.GetJax(q,MathJax.OutputJax,"Output Jax");a.About.GetJax(q,MathJax.ElementJax,"Element Jax");q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(q,MathJax.Extension,"Extension",true);q.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[c.Browser+" v"+c.Browser.version+(t.webFonts&&!t.imgFonts?" \u2014 "+t.allowWebFonts+" fonts":"")]]);a.About.div=a.Background(a.About);var w=g.addElement(a.About.div,"div",{id:"MathJax_About",onclick:a.About.Remove},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],"using "+s,["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","max-height":"20em",overflow:"auto","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},q],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]]]);var x=(document.documentElement||{});var u=window.innerHeight||x.clientHeight||x.scrollHeight||0;if(a.prototype.msieAboutBug){w.style.width="20em";w.style.position="absolute";w.style.left=Math.floor((document.documentElement.scrollWidth-w.offsetWidth)/2)+"px";w.style.top=(Math.floor((u-w.offsetHeight)/3)+document.body.scrollTop)+"px"}else{w.style.marginLeft=Math.floor(-w.offsetWidth/2)+"px";w.style.top=Math.floor((u-w.offsetHeight)/3)+"px"}};a.About.Remove=function(q){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(r,w,u,t){var v=[];for(var x in w){if(w.hasOwnProperty(x)&&w[x]){if((t&&w[x].version)||(w[x].isa&&w[x].isa(w))){v.push((w[x].id||x)+" "+u+" v"+w[x].version)}}}v.sort();for(var s=0,q=v.length;s<q;s++){r.push(v[s],["br"])}return r};a.Help=function(){window.open(o.helpURL,"MathJaxHelp")};a.ShowSource=function(t){if(!t){t=window.event}var s={screenX:t.screenX,screenY:t.screenY};if(!a.jax){return}if(this.format==="MathML"){var q=MathJax.ElementJax.mml;if(q&&typeof(q.mbase.prototype.toMathML)!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML(),t)}catch(r){if(!r.restart){throw r}f.After([this,a.ShowSource,s])}}else{if(!k.loadingToMathML){k.loadingToMathML=true;a.ShowSource.Window(t);f.Queue(k.Require("[MathJax]/extensions/toMathML.js"),function(){delete k.loadingToMathML;if(!q.mbase.prototype.toMathML){q.mbase.prototype.toMathML=function(){}}},[this,a.ShowSource,s]);return}}}else{if(a.jax.originalText==null){alert("No original form available");return}a.ShowSource.Text(a.jax.originalText,t)}};a.ShowSource.Window=function(r){if(!a.ShowSource.w){var s=[],q=o.windowSettings;for(var t in q){if(q.hasOwnProperty(t)){s.push(t+"="+q[t])}}a.ShowSource.w=window.open("","_blank",s.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(z,v){var s=a.ShowSource.Window(v);z=z.replace(/^\s*/,"").replace(/\s*$/,"");z=z.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");if(a.isMobile){s.document.open();s.document.write("<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0' /><title>MathJax Equation Source</title></head><body style='font-size:85%'>");s.document.write("<pre>"+z+"</pre>");s.document.write("<hr><input type='button' value='Close' onclick='window.close()' />");s.document.write("</body></html>");s.document.close()}else{s.document.open();s.document.write("<html><head><title>MathJax Equation Source</title></head><body style='font-size:85%'>");s.document.write("<table><tr><td><pre>"+z+"</pre></td></tr></table>");s.document.write("</body></html>");s.document.close();var u=s.document.body.firstChild;var t=(s.outerHeight-s.innerHeight)||30,r=(s.outerWidth-s.innerWidth)||30;r=Math.min(Math.floor(0.5*screen.width),u.offsetWidth+r+25);t=Math.min(Math.floor(0.5*screen.height),u.offsetHeight+t+25);s.resizeTo(r,t);if(v&&v.screenX!=null){var q=Math.max(0,Math.min(v.screenX-Math.floor(r/2),screen.width-r-20)),A=Math.max(0,Math.min(v.screenY-Math.floor(t/2),screen.height-t-20));s.moveTo(q,A)}}delete a.ShowSource.w};a.Scale=function(){var r=b["HTML-CSS"],q=b.NativeMML;var t=(r?r.config.scale:q.config.scale);var s=prompt("Scale all mathematics (compared to surrounding text) by",t+"%");if(s){if(s.match(/^\s*\d+\s*%?\s*$/)){s=parseInt(s);if(s){if(s!==t){if(r){r.config.scale=s}if(q){q.config.scale=s}a.cookie.scale=s;a.saveCookie();c.Reprocess()}}else{alert("The scale should not be zero")}}else{alert("The scale should be a perentage (e.g., 120%)")}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){k.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var r=c.outputJax["jax/mml"];if(r[0]!==o.settings.renderer){var u=c.Browser,t,q=a.Renderer.Messages,s;switch(o.settings.renderer){case"NativeMML":if(!o.settings.warnedMML){if(u.isChrome||(u.isSafari&&!u.versionAtLeast("5.0"))){t=q.MML.WebKit}else{if(u.isMSIE){if(!u.hasMathPlayer){t=q.MML.MSIE}}else{t=q.MML[u]}}s="warnedMML"}break;case"SVG":if(!o.settings.warnedSVG){if(u.isMSIE&&!e){t=q.SVG.MSIE}}break}if(t){t+="\n\nSwitch the renderer anyway?\n\n(Press OK to switch, CANCEL to continue with the current renderer)";a.cookie.renderer=r[0].id;a.saveCookie();if(!confirm(t)){return}if(s){a.cookie[s]=o.settings[s]=true}a.cookie.renderer=o.settings.renderer;a.saveCookie()}c.Queue(["setRenderer",c,o.settings.renderer,"jax/mml"],["Rerender",c])}};a.Renderer.Messages={MML:{WebKit:"Your browser doesn't seem to support MathML natively, so switching to MathML output may cause the mathematics on the page to become unreadable.",MSIE:"Internet Explorer requires the MathPlayer plugin in order to process MathML output.",Opera:"Opera's support for MathML is limited, so switching to MathML output may cause some expressions to render poorly.",Firefox:"Your browser's native MathML does not implement all the features used by MathJax, so some expressions my render improperly."},SVG:{MSIE:"SVG is not implemented in Internet Explorer prior to IE9, or when the browser is emulating IE8 or below. Switching to SVG output will cause the mathemtics to not display properly."}};a.Font=function(){var q=b["HTML-CSS"];if(!q){return}document.location.reload()};a.MPEvents=function(s){var r=o.settings.discoverable,q=a.MPEvents.Messages;if(!e){if(o.settings.mpMouse&&!confirm(q.IE8warning)){delete a.cookie.mpContext;delete o.settings.mpContext;delete a.cookie.mpMouse;delete o.settings.mpMouse;a.saveCookie();return}o.settings.mpContext=o.settings.mpMouse;a.cookie.mpContext=a.cookie.mpMouse=o.settings.mpMouse;a.saveCookie();MathJax.Hub.Queue(["Rerender",MathJax.Hub])}else{if(!r&&s.name==="Menu Events"&&o.settings.mpContext){alert(q.IE9warning)}}};a.MPEvents.Messages={IE8warning:"This will disable the MathJax menu and zoom features, but you can Alt-Click on an expression to obtain the MathJax menu instead.\n\nReally change the MathPlayer settings?",IE9warning:"The MathJax contextual menu will be disabled, but you can Alt-Click on an expression to obtain the MathJax menu instead."};c.Browser.Select({MSIE:function(q){var r=(document.compatMode==="BackCompat");var s=q.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:true,msieFixedPositionBug:(r||!s),msieAboutBug:r});if(e){delete o.styles["#MathJax_About"].filter;delete o.styles[".MathJax_Menu"].filter}},Firefox:function(q){a.skipMouseover=q.isMobile&&q.versionAtLeast("6.0");a.skipMousedown=q.isMobile}});a.isMobile=c.Browser.isMobile;a.noContextMenu=c.Browser.noContextMenu;c.Register.StartupHook("End Config",function(){o.settings=c.config.menuSettings;if(typeof(o.settings.showRenderer)!=="undefined"){o.showRenderer=o.settings.showRenderer}if(typeof(o.settings.showFontMenu)!=="undefined"){o.showFontMenu=o.settings.showFontMenu}if(typeof(o.settings.showContext)!=="undefined"){o.showContext=o.settings.showContext}a.getCookie();a.menu=a(m.SUBMENU("Show Math As",m.COMMAND("MathML Code",a.ShowSource,{nativeTouch:true,format:"MathML"}),m.COMMAND("Original Form",a.ShowSource,{nativeTouch:true}),m.RULE(),m.CHECKBOX("Show TeX hints in MathML","texHints")),m.RULE(),m.SUBMENU("Math Settings",m.SUBMENU("Zoom Trigger",m.RADIO("Hover","zoom",{action:a.Zoom}),m.RADIO("Click","zoom",{action:a.Zoom}),m.RADIO("Double-Click","zoom",{action:a.Zoom}),m.RADIO("No Zoom","zoom",{value:"None"}),m.RULE(),m.LABEL("Trigger Requires:"),m.CHECKBOX((c.Browser.isMac?"Option":"Alt"),"ALT"),m.CHECKBOX("Command","CMD",{hidden:!c.Browser.isMac}),m.CHECKBOX("Control","CTRL",{hidden:c.Browser.isMac}),m.CHECKBOX("Shift","Shift")),m.SUBMENU("Zoom Factor",m.RADIO("125%","zscale"),m.RADIO("133%","zscale"),m.RADIO("150%","zscale"),m.RADIO("175%","zscale"),m.RADIO("200%","zscale"),m.RADIO("250%","zscale"),m.RADIO("300%","zscale"),m.RADIO("400%","zscale")),m.RULE(),m.SUBMENU("Math Renderer",{hidden:!o.showRenderer},m.RADIO("HTML-CSS","renderer",{action:a.Renderer}),m.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"}),m.RADIO("SVG","renderer",{action:a.Renderer})),m.SUBMENU("MathPlayer",{hidden:!c.Browser.isMSIE||!o.showMathPlayer,disabled:!c.Browser.hasMathPlayer},m.LABEL("Let MathPlayer Handle:"),m.CHECKBOX("Menu Events","mpContext",{action:a.MPEvents,hidden:!e}),m.CHECKBOX("Mouse Events","mpMouse",{action:a.MPEvents,hidden:!e}),m.CHECKBOX("Mouse and Menu Events","mpMouse",{action:a.MPEvents,hidden:e})),m.SUBMENU("Font Preference",{hidden:!o.showFontMenu},m.LABEL("For HTML-CSS:"),m.RADIO("Auto","font",{action:a.Font}),m.RULE(),m.RADIO("TeX (local)","font",{action:a.Font}),m.RADIO("TeX (web)","font",{action:a.Font}),m.RADIO("TeX (image)","font",{action:a.Font}),m.RULE(),m.RADIO("STIX (local)","font",{action:a.Font})),m.SUBMENU("Contextual Menu",{hidden:!o.showContext},m.RADIO("MathJax","context"),m.RADIO("Browser","context")),m.COMMAND("Scale All Math ...",a.Scale),m.RULE().With({hidden:!o.showDiscoverable,name:"discover_rule"}),m.CHECKBOX("Highlight on Hover","discoverable",{hidden:!o.showDiscoverable})),m.RULE(),m.COMMAND("About MathJax",a.About),m.COMMAND("MathJax Help",a.Help));if(a.isMobile){(function(){var r=o.settings;var q=a.menu.Find("Math Settings","Zoom Trigger").menu;q.items[0].disabled=q.items[1].disabled=true;if(r.zoom==="Hover"||r.zoom=="Click"){r.zoom="None"}q.items=q.items.slice(0,4);if(navigator.appVersion.match(/[ (]Android[) ]/)){a.ITEM.SUBMENU.Augment({marker:"\u00BB"})}})()}});a.showRenderer=function(q){a.cookie.showRenderer=o.showRenderer=q;a.saveCookie();a.menu.Find("Math Settings","Math Renderer").hidden=!q};a.showMathPlayer=function(q){a.cookie.showMathPlayer=o.showMathPlayer=q;a.saveCookie();a.menu.Find("Math Settings","MathPlayer").hidden=!q};a.showFontMenu=function(q){a.cookie.showFontMenu=o.showFontMenu=q;a.saveCookie();a.menu.Find("Math Settings","Font Preference").hidden=!q};a.showContext=function(q){a.cookie.showContext=o.showContext=q;a.saveCookie();a.menu.Find("Math Settings","Contextual Menu").hidden=!q};a.showDiscoverable=function(q){a.cookie.showContext=o.showContext=q;a.saveCookie();a.menu.Find("Math Settings","Highlight on Hover").hidden=!q;a.menu.Find("Math Settings","discover_rule").hidden=!q};MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){if(!MathJax.OutputJax["HTML-CSS"].config.imageFont){a.menu.Find("Math Settings","Font Preference","TeX (image)").disabled=true}});f.Queue(c.Register.StartupHook("End Config",{}),["getImages",a],["Styles",k,o.styles],["Post",c.Startup.signal,"MathMenu Ready"],["loadComplete",k,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.CallBack,MathJax.OutputJax);

MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"2.0",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.attr&&this.root.attr.mode){if(!this.root.display&&this.root.attr.mode==="display"){this.root.display="block";this.root.attrNames.push("display")}delete this.root.attr.mode;for(var b=0,a=this.root.attrNames.length;b<a;b++){if(this.root.attrNames[b]==="mode"){this.root.attrNames.splice(b,1);break}}}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},TEXCLASSNAMES:["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"],copyAttributes:{fontfamily:true,fontsize:true,fontweight:true,fontstyle:true,color:true,background:true,id:true,"class":true,href:true,style:true},skipAttributes:{texClass:true,useHeight:true,texprimestyle:true},copyAttributeNames:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"]});(function(a){a.mbase=MathJax.Object.Subclass({type:"base",isToken:false,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT},noInherit:{},noInheritAttribute:{texClass:true},linebreakContainer:false,Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:true}))}this.Append.apply(this,arguments)},With:function(d){for(var e in d){if(d.hasOwnProperty(e)){this[e]=d[e]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var e=0,d=arguments.length;e<d;e++){this.SetData(this.data.length,arguments[e])}}},SetData:function(d,e){if(e!=null){if(!(e instanceof a.mbase)){e=(this.isToken?a.chars(e):a.mtext(e))}e.parent=this;e.setInherit(this.inheritFromMe?this:this.inherit)}this.data[d]=e},Parent:function(){var d=this.parent;while(d&&d.inferred){d=d.parent}return d},Get:function(e,j){if(this[e]!=null){return this[e]}if(this.attr&&this.attr[e]!=null){return this.attr[e]}var f=this.Parent();if(f&&f["adjustChild_"+e]!=null){return(f["adjustChild_"+e])(f.childPosition(this))}var i=this.inherit;var d=i;while(i){var h=i[e];if(h==null&&i.attr){h=i.attr[e]}if(h!=null&&!i.noInheritAttribute[e]){var g=i.noInherit[this.type];if(!(g&&g[e])){return h}}d=i;i=i.inherit}if(!j){if(this.defaults[e]===a.AUTO){return this.autoDefault(e)}if(this.defaults[e]!==a.INHERIT&&this.defaults[e]!=null){return this.defaults[e]}if(d){return d.defaults[e]}}return null},hasValue:function(d){return(this.Get(d,true)!=null)},getValues:function(){var e={};for(var f=0,d=arguments.length;f<d;f++){e[arguments[f]]=this.Get(arguments[f])}return e},adjustChild_scriptlevel:function(d){return this.Get("scriptlevel")},adjustChild_displaystyle:function(d){return this.Get("displaystyle")},adjustChild_texprimestyle:function(d){return this.Get("texprimestyle")},childPosition:function(f){if(f.parent.inferred){f=f.parent}for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]===f){return e}}return null},setInherit:function(f){if(f!==this.inherit&&this.inherit==null){this.inherit=f;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].setInherit){this.data[e].setInherit(f)}}}},setTeXclass:function(d){this.getPrevClass(d);return(typeof(this.texClass)!=="undefined"?this:d)},getPrevClass:function(d){if(d){this.prevClass=d.Get("texClass");this.prevLevel=d.Get("scriptlevel")}},updateTeXclass:function(d){if(d){this.prevClass=d.prevClass;delete d.prevClass;this.prevLevel=d.prevLevel;delete d.prevLevel;this.texClass=d.Get("texClass")}},texSpacing:function(){var e=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var d=(this.Get("texClass")||a.TEXCLASS.ORD);if(e===a.TEXCLASS.NONE||d===a.TEXCLASS.NONE){return""}if(e===a.TEXCLASS.VCENTER){e=a.TEXCLASS.ORD}if(d===a.TEXCLASS.VCENTER){d=a.TEXCLASS.ORD}var f=this.TEXSPACE[e][d];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&f>=0){return""}return this.TEXSPACELENGTH[Math.abs(f)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(d){return""},isSpacelike:function(){return false},isEmbellished:function(){return false},Core:function(){return this},CoreMO:function(){return this},hasNewline:function(){if(this.isEmbellished()){return this.CoreMO().hasNewline()}if(this.isToken||this.linebreakContainer){return false}for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&this.data[e].hasNewline()){return true}}return false},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"}},{childrenSpacelike:function(){for(var e=0,d=this.data.length;e<d;e++){if(!this.data[e].isSpacelike()){return false}}return true},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(d){if(this.data[0]){d=this.data[0].setTeXclass(d);this.updateTeXclass(this.data[0])}return d},setBaseTeXclasses:function(f){this.getPrevClass(f);this.texClass=null;if(this.isEmbellished()){f=this.data[0].setTeXclass(f);this.updateTeXclass(this.Core())}else{if(this.data[0]){this.data[0].setTeXclass()}f=this}for(var e=1,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}return f},setSeparateTeXclasses:function(f){this.getPrevClass(f);for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){this.data[e].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT},autoDefault:function(e){if(e==="mathvariant"){var d=(this.data[0]||"").toString();return(d.length===1||(d.length===2&&d.charCodeAt(0)>=55296&&d.charCodeAt(0)<56320)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""}});a.mn=a.mbase.Subclass({type:"mn",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:true,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:false,separator:false,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:false,symmetric:true,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:false,movablelimits:false,accent:false,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(f,l){var k=this.def;if(!k){if(f==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var j=this.data.join("");var e=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var g=0,d=e.length;g<d;g++){var h=this.OPTABLE[e[g]][j];if(h){k=this.makeDef(h);break}}if(!k){k=this.CheckRange(j)}if(!k&&l){k={}}else{if(!k){k=MathJax.Hub.Insert({},this.defaultDef)}k.form=e[0];this.def=k}}this.useMMLspacing&=~(this.SPACE_ATTR[f]||0);if(k[f]!=null){return k[f]}else{if(!l){return this.defaultDef[f]}}return""},CheckRange:function(h){var j=h.charCodeAt(0);if(j>=55296&&j<56320){j=(((j-55296)<<10)+(h.charCodeAt(1)-56320))+65536}for(var f=0,d=this.RANGES.length;f<d&&this.RANGES[f][0]<=j;f++){if(j<=this.RANGES[f][1]){if(this.RANGES[f][3]){var e=a.optableDir+"/"+this.RANGES[f][3]+".js";this.RANGES[f][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(e))}var g=a.TEXCLASSNAMES[this.RANGES[f][2]];g=this.OPTABLE.infix[h]=a.mo.OPTYPES[g==="BIN"?"BIN3":g];return this.makeDef(g)}}return null},makeDef:function(e){if(e[2]==null){e[2]=this.defaultDef.texClass}if(!e[3]){e[3]={}}var d=MathJax.Hub.Insert({},e[3]);d.lspace=this.SPACE[e[0]];d.rspace=this.SPACE[e[1]];d.texClass=e[2];if(d.texClass===a.TEXCLASS.REL&&(this.movablelimits||this.data.join("").match(/^[a-z]+$/i))){d.texClass=a.TEXCLASS.OP}return d},getForm:function(){var d=this,f=this.parent,e=this.Parent();while(e&&e.isEmbellished()){d=f;f=e.parent;e=e.Parent()}if(f&&f.type==="mrow"&&f.NonSpaceLength()!==1){if(f.FirstNonSpace()===d){return a.FORM.PREFIX}if(f.LastNonSpace()===d){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return true},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)},setTeXclass:function(d){this.getValues("lspace","rspace");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}this.texClass=this.Get("texClass");if(this.texClass===a.TEXCLASS.NONE){return d}if(d){this.prevClass=d.texClass||a.TEXCLASS.ORD;this.prevLevel=d.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){d.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:true,isSpacelike:function(){return true},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:true,isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)}});a.ms=a.mbase.Subclass({type:"ms",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:false,isEmbellished:function(){var e=false;for(var f=0,d=this.data.length;f<d;f++){if(this.data[f]==null){continue}if(this.data[f].isEmbellished()){if(e){return false}e=true;this.core=f}else{if(!this.data[f].isSpacelike()){return false}}}return e},NonSpaceLength:function(){var f=0;for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){f++}}return f},FirstNonSpace:function(){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]&&!this.data[e].isSpacelike()){return this.data[e]}}return null},LastNonSpace:function(){for(var d=this.data.length-1;d>=0;d--){if(this.data[0]&&!this.data[d].isSpacelike()){return this.data[d]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(f){for(var e=0,d=this.data.length;e<d;e++){if(this.data[e]){f=this.data[e].setTeXclass(f)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return f}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,linebreakContainer:true,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:false},adjustChild_displaystyle:function(d){return false},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(!this.Get("displaystyle")||d>0){d++}return d},adjustChild_texprimestyle:function(d){if(d==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(d){return true}});a.mroot=a.mbase.Subclass({type:"mroot",linebreakContainer:true,texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(d){if(d===1){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e===1){d+=2}return d},adjustChild_texprimestyle:function(d){if(d===0){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:true,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(f){var e=this.scriptlevel;if(e==null){e=this.Get("scriptlevel")}else{if(String(e).match(/^ *[-+]/)){delete this.scriptlevel;var d=this.Get("scriptlevel");this.scriptlevel=e;e=d+parseInt(e)}}return e},inheritFromMe:true,noInherit:{mpadded:{width:true,height:true,depth:true,lspace:true,voffset:true},mtable:{width:true,height:true,depth:true,align:true}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(g){this.getPrevClass(g);var e=this.getValues("open","close","separators");e.open=e.open.replace(/[ \t\n\r]/g,"");e.close=e.close.replace(/[ \t\n\r]/g,"");e.separators=e.separators.replace(/[ \t\n\r]/g,"");if(e.open!==""){this.SetData("open",a.mo(e.open).With({stretchy:true,texClass:a.TEXCLASS.OPEN}));g=this.data.open.setTeXclass(g)}if(e.separators!==""){while(e.separators.length<this.data.length){e.separators+=e.separators.charAt(e.separators.length-1)}}if(this.data[0]){g=this.data[0].setTeXclass(g)}for(var f=1,d=this.data.length;f<d;f++){if(this.data[f]){if(e.separators!==""){this.SetData("sep"+f,a.mo(e.separators.charAt(f-1)));g=this.data["sep"+f].setTeXclass(g)}g=this.data[f].setTeXclass(g)}}if(e.close!==""){this.SetData("close",a.mo(e.close).With({stretchy:true,texClass:a.TEXCLASS.CLOSE}));g=this.data.close.setTeXclass(g)}this.updateTeXclass(this.data.open);return g}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:true,linebreakContainer:true,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(e){var d=this.Get("scriptlevel");if(e>0){d++}return d},adjustChild_texprimestyle:function(d){if(d===this.sub){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(d){if(d%2===1){return true}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(d){if(d==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(d):a.TEXCLASS.ORD)}if(d==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(d==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return false},adjustChild_displaystyle:function(d){if(d>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");var d=(this.data[this.base]&&!this.Get("displaystyle")&&this.data[this.base].CoreMO().Get("movablelimits"));if(f==this.under&&(d||!this.Get("accentunder"))){e++}if(f==this.over&&(d||!this.Get("accent"))){e++}return e},adjustChild_texprimestyle:function(d){if(d===this.base&&this.data[this.over]){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:true,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:false,equalcolumns:false,displaystyle:false,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:true,noInherit:{mtable:{align:true,rowalign:true,columnalign:true,groupalign:true,alignmentscope:true,columnwidth:true,width:true,rowspacing:true,columnspacing:true,rowlines:true,columnlines:true,frame:true,framespacing:true,equalrows:true,equalcolumns:true,side:true,minlabelspacing:true,texClass:true,useHeight:1}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!((arguments[e] instanceof a.mtr)||(arguments[e] instanceof a.mlabeledtr))){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{rowalign:true,columnalign:true,groupalign:true},mtable:{rowalign:true,columnalign:true,groupalign:true}},linebreakContainer:true,Append:function(){for(var e=0,d=arguments.length;e<d;e++){if(!(arguments[e] instanceof a.mtd)){arguments[e]=a.mtd(arguments[e])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:true,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{groupalign:true},mtable:{groupalign:true}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return true}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(d){return this.selected().setTeXclass(d)}});a.semantics=a.mbase.Subclass({type:"semantics",isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass});a.annotation=a.mbase.Subclass({type:"annotation",isToken:true,linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:false},autoDefault:function(d){if(d==="displaystyle"){return this.Get("display")==="block"}return""},linebreakContainer:true,setTeXclass:a.mbase.setChildTeXclass});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var d=this.value();if(d<=65535){return String.fromCharCode(d)}d-=65536;return String.fromCharCode((d>>10)+55296)+String.fromCharCode((d&1023)+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var e=0,d=arguments.length;e<d;e++){var f=this.Import(arguments[e]);this.data.push(f);this.div.appendChild(f)}},Import:function(h){if(document.importNode){return document.importNode(h,true)}var e,f,d;if(h.nodeType===1){e=document.createElement(h.nodeName);if(h.className){e.className=iNode.className}for(f=0,d=h.attributes.length;f<d;f++){var g=h.attributes[f];if(g.specified&&g.nodeValue!=null&&g.nodeValue!=""){e.setAttribute(g.nodeName,g.nodeValue)}if(g.nodeName==="style"){e.style.cssText=g.nodeValue}}if(h.className){e.className=h.className}}else{if(h.nodeType===3||h.nodeType===4){e=document.createTextNode(h.nodeValue)}else{if(h.nodeType===8){e=document.createComment(h.nodeValue)}else{return document.createTextNode("")}}}for(f=0,d=h.childNodes.length;f<d;f++){e.appendChild(this.Import(h.childNodes[f]))}return e},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:true,texClass:a.TEXCLASS.ORD,setTeXclass:function(d){this.getPrevClass(d);this.data[0].setTeXclass();return this}});a.NULL=a.mbase().With({type:"null"});var b=a.TEXCLASS;var c={ORD:[0,0,b.ORD],ORD11:[1,1,b.ORD],ORD21:[2,1,b.ORD],ORD02:[0,2,b.ORD],ORD55:[5,5,b.ORD],OP:[1,2,b.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,b.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,b.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,b.OP,{largeop:true,symmetric:true}],BIN3:[3,3,b.BIN],BIN4:[4,4,b.BIN],BIN01:[0,1,b.BIN],BIN5:[5,5,b.BIN],TALLBIN:[4,4,b.BIN,{stretchy:true}],BINOP:[4,4,b.BIN,{largeop:true,movablelimits:true}],REL:[5,5,b.REL],REL1:[1,1,b.REL,{stretchy:true}],REL4:[4,4,b.REL],RELSTRETCH:[5,5,b.REL,{stretchy:true}],RELACCENT:[5,5,b.REL,{accent:true}],WIDEREL:[5,5,b.REL,{accent:true,stretchy:true}],OPEN:[0,0,b.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,b.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,b.INNER],PUNCT:[0,3,b.PUNCT],ACCENT:[0,0,b.ORD,{accent:true}],WIDEACCENT:[0,0,b.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,b.REL,"BasicLatin"],[160,255,b.ORD,"Latin1Supplement"],[256,383,b.ORD],[384,591,b.ORD],[688,767,b.ORD,"SpacingModLetters"],[768,879,b.ORD,"CombDiacritMarks"],[880,1023,b.ORD,"GreekAndCoptic"],[7680,7935,b.ORD],[8192,8303,b.PUNCT,"GeneralPunctuation"],[8304,8351,b.ORD],[8352,8399,b.ORD],[8400,8447,b.ORD,"CombDiactForSymbols"],[8448,8527,b.ORD,"LetterlikeSymbols"],[8528,8591,b.ORD],[8592,8703,b.REL,"Arrows"],[8704,8959,b.BIN,"MathOperators"],[8960,9215,b.ORD,"MiscTechnical"],[9312,9471,b.ORD],[9472,9631,b.ORD],[9632,9727,b.ORD,"GeometricShapes"],[9984,10175,b.ORD,"Dingbats"],[10176,10223,b.ORD,"MiscMathSymbolsA"],[10224,10239,b.REL,"SupplementalArrowsA"],[10496,10623,b.REL,"SupplementalArrowsB"],[10624,10751,b.ORD,"MiscMathSymbolsB"],[10752,11007,b.BIN,"SuppMathOperators"],[11008,11263,b.ORD,"MiscSymbolsAndArrows"],[119808,120831,b.ORD]],OPTABLE:{prefix:{"\u2200":c.ORD21,"\u2202":c.ORD21,"\u2203":c.ORD21,"\u2207":c.ORD21,"\u220F":c.OP,"\u2210":c.OP,"\u2211":c.OP,"\u2212":c.BIN01,"\u2213":c.BIN01,"\u221A":[1,1,b.ORD,{stretchy:true}],"\u2220":c.ORD,"\u222B":c.INTEGRAL,"\u222E":c.INTEGRAL,"\u22C0":c.OP,"\u22C1":c.OP,"\u22C2":c.OP,"\u22C3":c.OP,"\u2308":c.OPEN,"\u230A":c.OPEN,"\u27E8":c.OPEN,"\u27EE":c.OPEN,"\u2A00":c.OP,"\u2A01":c.OP,"\u2A02":c.OP,"\u2A04":c.OP,"\u2A06":c.OP,"\u00AC":c.ORD21,"\u00B1":c.BIN01,"(":c.OPEN,"+":c.BIN01,"-":c.BIN01,"[":c.OPEN,"{":c.OPEN,"|":c.OPEN},postfix:{"!":[1,0,b.CLOSE],"&":c.ORD,"\u2032":c.ORD02,"\u203E":c.WIDEACCENT,"\u2309":c.CLOSE,"\u230B":c.CLOSE,"\u23DE":c.WIDEACCENT,"\u23DF":c.WIDEACCENT,"\u266D":c.ORD02,"\u266E":c.ORD02,"\u266F":c.ORD02,"\u27E9":c.CLOSE,"\u27EF":c.CLOSE,"\u02C6":c.WIDEACCENT,"\u02C7":c.WIDEACCENT,"\u02C9":c.WIDEACCENT,"\u02CA":c.ACCENT,"\u02CB":c.ACCENT,"\u02D8":c.ACCENT,"\u02D9":c.ACCENT,"\u02DC":c.WIDEACCENT,"\u0302":c.WIDEACCENT,"\u00A8":c.ACCENT,"\u00AF":c.WIDEACCENT,")":c.CLOSE,"]":c.CLOSE,"^":c.WIDEACCENT,_:c.WIDEACCENT,"`":c.ACCENT,"|":c.CLOSE,"}":c.CLOSE,"~":c.WIDEACCENT},infix:{"":c.ORD,"%":[3,3,b.ORD],"\u2022":c.BIN4,"\u2026":c.INNER,"\u2044":c.TALLBIN,"\u2061":c.ORD,"\u2062":c.ORD,"\u2063":[0,0,b.ORD,{linebreakstyle:"after",separator:true}],"\u2064":c.ORD,"\u2190":c.WIDEREL,"\u2191":c.RELSTRETCH,"\u2192":c.WIDEREL,"\u2193":c.RELSTRETCH,"\u2194":c.WIDEREL,"\u2195":c.RELSTRETCH,"\u2196":c.RELSTRETCH,"\u2197":c.RELSTRETCH,"\u2198":c.RELSTRETCH,"\u2199":c.RELSTRETCH,"\u21A6":c.WIDEREL,"\u21A9":c.WIDEREL,"\u21AA":c.WIDEREL,"\u21BC":c.WIDEREL,"\u21BD":c.WIDEREL,"\u21C0":c.WIDEREL,"\u21C1":c.WIDEREL,"\u21CC":c.WIDEREL,"\u21D0":c.WIDEREL,"\u21D1":c.RELSTRETCH,"\u21D2":c.WIDEREL,"\u21D3":c.RELSTRETCH,"\u21D4":c.WIDEREL,"\u21D5":c.RELSTRETCH,"\u2208":c.REL,"\u2209":c.REL,"\u220B":c.REL,"\u2212":c.BIN4,"\u2213":c.BIN4,"\u2215":c.TALLBIN,"\u2216":c.BIN4,"\u2217":c.BIN4,"\u2218":c.BIN4,"\u2219":c.BIN4,"\u221D":c.REL,"\u2223":c.REL,"\u2225":c.REL,"\u2227":c.BIN4,"\u2228":c.BIN4,"\u2229":c.BIN4,"\u222A":c.BIN4,"\u223C":c.REL,"\u2240":c.BIN4,"\u2243":c.REL,"\u2245":c.REL,"\u2248":c.REL,"\u224D":c.REL,"\u2250":c.REL,"\u2260":c.REL,"\u2261":c.REL,"\u2264":c.REL,"\u2265":c.REL,"\u226A":c.REL,"\u226B":c.REL,"\u227A":c.REL,"\u227B":c.REL,"\u2282":c.REL,"\u2283":c.REL,"\u2286":c.REL,"\u2287":c.REL,"\u228E":c.BIN4,"\u2291":c.REL,"\u2292":c.REL,"\u2293":c.BIN4,"\u2294":c.BIN4,"\u2295":c.BIN4,"\u2296":c.BIN4,"\u2297":c.BIN4,"\u2298":c.BIN4,"\u2299":c.BIN4,"\u22A2":c.REL,"\u22A3":c.REL,"\u22A4":c.ORD55,"\u22A5":c.REL,"\u22A8":c.REL,"\u22C4":c.BIN4,"\u22C5":c.BIN4,"\u22C6":c.BIN4,"\u22C8":c.REL,"\u22EE":c.ORD55,"\u22EF":c.INNER,"\u22F1":[5,5,b.INNER],"\u25B3":c.BIN4,"\u25B5":c.BIN4,"\u25B9":c.BIN4,"\u25BD":c.BIN4,"\u25BF":c.BIN4,"\u25C3":c.BIN4,"\u2758":c.REL,"\u27F5":c.WIDEREL,"\u27F6":c.WIDEREL,"\u27F7":c.WIDEREL,"\u27F8":c.WIDEREL,"\u27F9":c.WIDEREL,"\u27FA":c.WIDEREL,"\u27FC":c.WIDEREL,"\u2A2F":c.BIN4,"\u2A3F":c.BIN4,"\u2AAF":c.REL,"\u2AB0":c.REL,"\u00B1":c.BIN4,"\u00B7":c.BIN4,"\u00D7":c.BIN4,"\u00F7":c.BIN4,"*":c.BIN3,"+":c.BIN4,",":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"-":c.BIN4,".":[3,3,b.ORD],"/":c.ORD11,":":[1,2,b.REL],";":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"<":c.REL,"=":c.REL,">":c.REL,"?":[1,1,b.CLOSE],"\\":c.ORD,"^":c.ORD11,_:c.ORD11,"|":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}],"#":c.ORD,"$":c.ORD,"\u002E":[0,3,b.PUNCT,{separator:true}],"\u02B9":c.ORD,"\u0300":c.ACCENT,"\u0301":c.ACCENT,"\u0303":c.WIDEACCENT,"\u0304":c.ACCENT,"\u0306":c.ACCENT,"\u0307":c.ACCENT,"\u0308":c.ACCENT,"\u030C":c.ACCENT,"\u0332":c.WIDEACCENT,"\u0338":c.REL4,"\u2015":[0,0,b.ORD,{stretchy:true}],"\u2017":[0,0,b.ORD,{stretchy:true}],"\u2020":c.BIN3,"\u2021":c.BIN3,"\u20D7":c.ACCENT,"\u2111":c.ORD,"\u2113":c.ORD,"\u2118":c.ORD,"\u211C":c.ORD,"\u2205":c.ORD,"\u221E":c.ORD,"\u2305":c.BIN3,"\u2306":c.BIN3,"\u2322":c.REL4,"\u2323":c.REL4,"\u2329":c.OPEN,"\u232A":c.CLOSE,"\u23AA":c.ORD,"\u23AF":[0,0,b.ORD,{stretchy:true}],"\u23B0":c.OPEN,"\u23B1":c.CLOSE,"\u2500":c.ORD,"\u25EF":c.BIN3,"\u2660":c.ORD,"\u2661":c.ORD,"\u2662":c.ORD,"\u2663":c.ORD,"\u3008":c.OPEN,"\u3009":c.CLOSE,"\uFE37":c.WIDEACCENT,"\uFE38":c.WIDEACCENT}}},{OPTYPES:c});a.mo.prototype.OPTABLE.infix["^"]=c.WIDEREL;a.mo.prototype.OPTABLE.infix._=c.WIDEREL})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");

MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="2.0";var a=MathJax.ElementJax.mml;SETTINGS=MathJax.Hub.config.menuSettings;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.toMathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[];var h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},toMathMLattributes:function(){var j=[],g=this.defaults;var c=(this.attrNames||a.copyAttributeNames),l=a.skipAttributes;if(this.type==="math"){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(!this.attrNames){if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.toMathMLattribute(k)+'"')}this[d]=k}}}}for(var h=0,f=c.length;h<f;h++){if(c[h]==="class"){continue}k=(this.attr||{})[c[h]];if(k==null){k=this[c[h]]}if(k!=null){j.push(c[h]+'="'+this.toMathMLquote(k)+'"')}}this.toMathMLclass(j);if(j.length){return" "+j.join(" ")}else{return""}},toMathMLclass:function(c){var e=[];if(this["class"]){e.push(this["class"])}if(this.isa(a.TeXAtom)&&SETTINGS.texHints){var d=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(d){e.push("MJX-TeXAtom-"+d)}}if(this.mathvariant&&this.toMathMLvariants[this.mathvariant]){e.push("MJX"+this.mathvariant)}if(this.arrow){e.push("MJX-arrow")}if(this.variantForm){e.push("MJX-variant")}if(e.length){c.unshift('class="'+e.join(" ")+'"')}},toMathMLattribute:function(c){if(typeof(c)==="string"&&c.replace(/ /g,"").match(/^(([-+])?(\d+(\.\d*)?|\.\d+))mu$/)){return((1/18)*RegExp.$1).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.toMathMLvariants[c]){return this.toMathMLvariants[c]}}return this.toMathMLquote(c)},toMathMLvariants:{"-tex-caligraphic":a.VARIANT.SCRIPT,"-tex-caligraphic-bold":a.VARIANT.BOLDSCRIPT,"-tex-oldstyle":a.VARIANT.NORMAL,"-tex-oldstyle-bold":a.VARIANT.BOLD,"-tex-mathit":a.VARIANT.ITALIC},toMathMLquote:function(e){e=String(e).split("");for(var f=0,d=e.length;f<d;f++){var h=e[f].charCodeAt(0);if(h<32||h>126){e[f]="&#x"+h.toString(16).toUpperCase()+";"}else{var g={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[e[f]];if(g){e[f]=g}}}return e.join("")}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(d){var c=this.toMathMLattributes();if(!c&&this.data[0].data.length===1){return d.substr(2)+this.data[0].toMathML(d)}return d+"<mrow"+c+">\n"+this.data[0].toMathML(d+"  ")+"\n"+d+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.toMathMLquote(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");

(function(ag){var k;var aa=MathJax.Object.Subclass({firstChild:null,lastChild:null,Init:function(){this.childNodes=[]},appendChild:function(i){if(i.parent){i.parent.removeChild(i)}if(this.lastChild){this.lastChild.nextSibling=i}if(!this.firstChild){this.firstChild=i}this.childNodes.push(i);i.parent=this;this.lastChild=i;return i},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.childNodes[ak]=al;al.nextSibling=aj.nextSibling;aj.nextSibling=aj.parent=null;return aj},toString:function(){return"{"+this.childNodes.join("")+"}"}});var E=function(){k=MathJax.ElementJax.mml;var i=k.mbase.prototype.Init;k.mbase.Augment({firstChild:null,lastChild:null,nodeValue:"",nextSibling:null,Init:function(){var ai=i.apply(this,arguments)||this;ai.childNodes=ai.data;ai.nodeName=ai.type;return ai},appendChild:function(al){if(al.parent){al.parent.removeChild(al)}var aj=arguments;if(al.isa(aa)){aj=al.childNodes;al.data=al.childNodes=[];al.firstChild=al.lastChild=null}for(var ak=0,ai=aj.length;ak<ai;ak++){al=aj[ak];if(this.lastChild){this.lastChild.nextSibling=al}if(!this.firstChild){this.firstChild=al}this.Append(al);this.lastChild=al;this.nodeValue+=al.nodeValue}return al},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}this.nodeValue="";for(aj=0,ai=this.childNodes.length;aj<ai;aj++){this.nodeValue+=this.childNodes[aj].nodeValue}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.SetData(ak,al);al.nextSibling=aj.nextSibling;this.nodeValue="";for(ak=0,ai=this.childNodes.length;ak<ai;ak++){this.nodeValue+=this.childNodes[ak].nodeValue}aj.nextSibling=aj.parent=null;return aj},setAttribute:function(ai,aj){this[ai]=aj}})};var S={};var g={getElementById:true,createElementNS:function(ai,i){return k[i]()},createTextNode:function(i){return k.chars(i).With({nodeValue:i})},createDocumentFragment:function(){return aa()}};var O={appName:"MathJax"};var ac;var I="red";var ad="serif";var t=true;var C=true;var f=".";var q=g.createElementNS==null;function V(i){if(q){return g.createElement(i)}else{return g.createElementNS("http://www.w3.org/1999/xhtml",i)}}var J=[61237,8492,61238,61239,8496,8497,61240,8459,8464,61241,61242,8466,8499,61243,61244,61245,61246,8475,61247,61248,61249,61250,61251,61252,61253,61254];var N=[61277,61278,8493,61279,61280,61281,61282,8460,8465,61283,61284,61285,61286,61287,61288,61289,61290,8476,61291,61292,61293,61294,61295,61296,61297,8488];var D=[61324,61325,8450,61326,61327,61328,61329,8461,61330,61331,61332,61333,61334,8469,61335,8473,8474,8477,61336,61337,61338,61339,61340,61341,61342,8484];var d=0,H=1,X=2,m=3,b=4,l=5,a=6,P=7,Z=8,r=9,ab=10;var j={input:"sqrt",tag:"msqrt",output:"sqrt",tex:null,ttype:H},af={input:"root",tag:"mroot",output:"root",tex:null,ttype:X},A={input:"frac",tag:"mfrac",output:"/",tex:null,ttype:X},Q={input:"/",tag:"mfrac",output:"/",tex:null,ttype:m},o={input:"stackrel",tag:"mover",output:"stackrel",tex:null,ttype:X},s={input:"_",tag:"msub",output:"_",tex:null,ttype:m},h={input:"^",tag:"msup",output:"^",tex:null,ttype:m},ah={input:"text",tag:"mtext",output:"text",tex:null,ttype:ab},x={input:"mbox",tag:"mtext",output:"mbox",tex:null,ttype:ab},p={input:'"',tag:"mtext",output:"mbox",tex:null,ttype:ab};var G=[{input:"alpha",tag:"mi",output:"\u03B1",tex:null,ttype:d},{input:"beta",tag:"mi",output:"\u03B2",tex:null,ttype:d},{input:"chi",tag:"mi",output:"\u03C7",tex:null,ttype:d},{input:"delta",tag:"mi",output:"\u03B4",tex:null,ttype:d},{input:"Delta",tag:"mo",output:"\u0394",tex:null,ttype:d},{input:"epsi",tag:"mi",output:"\u03B5",tex:"epsilon",ttype:d},{input:"varepsilon",tag:"mi",output:"\u025B",tex:null,ttype:d},{input:"eta",tag:"mi",output:"\u03B7",tex:null,ttype:d},{input:"gamma",tag:"mi",output:"\u03B3",tex:null,ttype:d},{input:"Gamma",tag:"mo",output:"\u0393",tex:null,ttype:d},{input:"iota",tag:"mi",output:"\u03B9",tex:null,ttype:d},{input:"kappa",tag:"mi",output:"\u03BA",tex:null,ttype:d},{input:"lambda",tag:"mi",output:"\u03BB",tex:null,ttype:d},{input:"Lambda",tag:"mo",output:"\u039B",tex:null,ttype:d},{input:"mu",tag:"mi",output:"\u03BC",tex:null,ttype:d},{input:"nu",tag:"mi",output:"\u03BD",tex:null,ttype:d},{input:"omega",tag:"mi",output:"\u03C9",tex:null,ttype:d},{input:"Omega",tag:"mo",output:"\u03A9",tex:null,ttype:d},{input:"phi",tag:"mi",output:"\u03C6",tex:null,ttype:d},{input:"varphi",tag:"mi",output:"\u03D5",tex:null,ttype:d},{input:"Phi",tag:"mo",output:"\u03A6",tex:null,ttype:d},{input:"pi",tag:"mi",output:"\u03C0",tex:null,ttype:d},{input:"Pi",tag:"mo",output:"\u03A0",tex:null,ttype:d},{input:"psi",tag:"mi",output:"\u03C8",tex:null,ttype:d},{input:"Psi",tag:"mi",output:"\u03A8",tex:null,ttype:d},{input:"rho",tag:"mi",output:"\u03C1",tex:null,ttype:d},{input:"sigma",tag:"mi",output:"\u03C3",tex:null,ttype:d},{input:"Sigma",tag:"mo",output:"\u03A3",tex:null,ttype:d},{input:"tau",tag:"mi",output:"\u03C4",tex:null,ttype:d},{input:"theta",tag:"mi",output:"\u03B8",tex:null,ttype:d},{input:"vartheta",tag:"mi",output:"\u03D1",tex:null,ttype:d},{input:"Theta",tag:"mo",output:"\u0398",tex:null,ttype:d},{input:"upsilon",tag:"mi",output:"\u03C5",tex:null,ttype:d},{input:"xi",tag:"mi",output:"\u03BE",tex:null,ttype:d},{input:"Xi",tag:"mo",output:"\u039E",tex:null,ttype:d},{input:"zeta",tag:"mi",output:"\u03B6",tex:null,ttype:d},{input:"*",tag:"mo",output:"\u22C5",tex:"cdot",ttype:d},{input:"**",tag:"mo",output:"\u22C6",tex:"star",ttype:d},{input:"//",tag:"mo",output:"/",tex:null,ttype:d},{input:"\\\\",tag:"mo",output:"\\",tex:"backslash",ttype:d},{input:"setminus",tag:"mo",output:"\\",tex:null,ttype:d},{input:"xx",tag:"mo",output:"\u00D7",tex:"times",ttype:d},{input:"-:",tag:"mo",output:"\u00F7",tex:"divide",ttype:d},{input:"@",tag:"mo",output:"\u2218",tex:"circ",ttype:d},{input:"o+",tag:"mo",output:"\u2295",tex:"oplus",ttype:d},{input:"ox",tag:"mo",output:"\u2297",tex:"otimes",ttype:d},{input:"o.",tag:"mo",output:"\u2299",tex:"odot",ttype:d},{input:"sum",tag:"mo",output:"\u2211",tex:null,ttype:P},{input:"prod",tag:"mo",output:"\u220F",tex:null,ttype:P},{input:"^^",tag:"mo",output:"\u2227",tex:"wedge",ttype:d},{input:"^^^",tag:"mo",output:"\u22C0",tex:"bigwedge",ttype:P},{input:"vv",tag:"mo",output:"\u2228",tex:"vee",ttype:d},{input:"vvv",tag:"mo",output:"\u22C1",tex:"bigvee",ttype:P},{input:"nn",tag:"mo",output:"\u2229",tex:"cap",ttype:d},{input:"nnn",tag:"mo",output:"\u22C2",tex:"bigcap",ttype:P},{input:"uu",tag:"mo",output:"\u222A",tex:"cup",ttype:d},{input:"uuu",tag:"mo",output:"\u22C3",tex:"bigcup",ttype:P},{input:"!=",tag:"mo",output:"\u2260",tex:"ne",ttype:d},{input:":=",tag:"mo",output:":=",tex:null,ttype:d},{input:"lt",tag:"mo",output:"<",tex:null,ttype:d},{input:"<=",tag:"mo",output:"\u2264",tex:"le",ttype:d},{input:"lt=",tag:"mo",output:"\u2264",tex:"leq",ttype:d},{input:">=",tag:"mo",output:"\u2265",tex:"ge",ttype:d},{input:"geq",tag:"mo",output:"\u2265",tex:null,ttype:d},{input:"-<",tag:"mo",output:"\u227A",tex:"prec",ttype:d},{input:"-lt",tag:"mo",output:"\u227A",tex:null,ttype:d},{input:">-",tag:"mo",output:"\u227B",tex:"succ",ttype:d},{input:"in",tag:"mo",output:"\u2208",tex:null,ttype:d},{input:"!in",tag:"mo",output:"\u2209",tex:"notin",ttype:d},{input:"sub",tag:"mo",output:"\u2282",tex:"subset",ttype:d},{input:"sup",tag:"mo",output:"\u2283",tex:"supset",ttype:d},{input:"sube",tag:"mo",output:"\u2286",tex:"subseteq",ttype:d},{input:"supe",tag:"mo",output:"\u2287",tex:"supseteq",ttype:d},{input:"-=",tag:"mo",output:"\u2261",tex:"equiv",ttype:d},{input:"~=",tag:"mo",output:"\u2245",tex:"cong",ttype:d},{input:"~~",tag:"mo",output:"\u2248",tex:"approx",ttype:d},{input:"prop",tag:"mo",output:"\u221D",tex:"propto",ttype:d},{input:"and",tag:"mtext",output:"and",tex:null,ttype:a},{input:"or",tag:"mtext",output:"or",tex:null,ttype:a},{input:"not",tag:"mo",output:"\u00AC",tex:"neg",ttype:d},{input:"=>",tag:"mo",output:"\u21D2",tex:"implies",ttype:d},{input:"if",tag:"mo",output:"if",tex:null,ttype:a},{input:"<=>",tag:"mo",output:"\u21D4",tex:"iff",ttype:d},{input:"AA",tag:"mo",output:"\u2200",tex:"forall",ttype:d},{input:"EE",tag:"mo",output:"\u2203",tex:"exists",ttype:d},{input:"_|_",tag:"mo",output:"\u22A5",tex:"bot",ttype:d},{input:"TT",tag:"mo",output:"\u22A4",tex:"top",ttype:d},{input:"|--",tag:"mo",output:"\u22A2",tex:"vdash",ttype:d},{input:"|==",tag:"mo",output:"\u22A8",tex:"models",ttype:d},{input:"(",tag:"mo",output:"(",tex:null,ttype:b},{input:")",tag:"mo",output:")",tex:null,ttype:l},{input:"[",tag:"mo",output:"[",tex:null,ttype:b},{input:"]",tag:"mo",output:"]",tex:null,ttype:l},{input:"{",tag:"mo",output:"{",tex:null,ttype:b},{input:"}",tag:"mo",output:"}",tex:null,ttype:l},{input:"|",tag:"mo",output:"|",tex:null,ttype:r},{input:"(:",tag:"mo",output:"\u2329",tex:"langle",ttype:b},{input:":)",tag:"mo",output:"\u232A",tex:"rangle",ttype:l},{input:"<<",tag:"mo",output:"\u2329",tex:null,ttype:b},{input:">>",tag:"mo",output:"\u232A",tex:null,ttype:l},{input:"{:",tag:"mo",output:"{:",tex:null,ttype:b,invisible:true},{input:":}",tag:"mo",output:":}",tex:null,ttype:l,invisible:true},{input:"int",tag:"mo",output:"\u222B",tex:null,ttype:d},{input:"dx",tag:"mi",output:"{:d x:}",tex:null,ttype:Z},{input:"dy",tag:"mi",output:"{:d y:}",tex:null,ttype:Z},{input:"dz",tag:"mi",output:"{:d z:}",tex:null,ttype:Z},{input:"dt",tag:"mi",output:"{:d t:}",tex:null,ttype:Z},{input:"oint",tag:"mo",output:"\u222E",tex:null,ttype:d},{input:"del",tag:"mo",output:"\u2202",tex:"partial",ttype:d},{input:"grad",tag:"mo",output:"\u2207",tex:"nabla",ttype:d},{input:"+-",tag:"mo",output:"\u00B1",tex:"pm",ttype:d},{input:"O/",tag:"mo",output:"\u2205",tex:"emptyset",ttype:d},{input:"oo",tag:"mo",output:"\u221E",tex:"infty",ttype:d},{input:"aleph",tag:"mo",output:"\u2135",tex:null,ttype:d},{input:"...",tag:"mo",output:"...",tex:"ldots",ttype:d},{input:":.",tag:"mo",output:"\u2234",tex:"therefore",ttype:d},{input:"/_",tag:"mo",output:"\u2220",tex:"angle",ttype:d},{input:"\\ ",tag:"mo",output:"\u00A0",tex:null,ttype:d},{input:"quad",tag:"mo",output:"\u00A0\u00A0",tex:null,ttype:d},{input:"qquad",tag:"mo",output:"\u00A0\u00A0\u00A0\u00A0",tex:null,ttype:d},{input:"cdots",tag:"mo",output:"\u22EF",tex:null,ttype:d},{input:"vdots",tag:"mo",output:"\u22EE",tex:null,ttype:d},{input:"ddots",tag:"mo",output:"\u22F1",tex:null,ttype:d},{input:"diamond",tag:"mo",output:"\u22C4",tex:null,ttype:d},{input:"square",tag:"mo",output:"\u25A1",tex:null,ttype:d},{input:"|__",tag:"mo",output:"\u230A",tex:"lfloor",ttype:d},{input:"__|",tag:"mo",output:"\u230B",tex:"rfloor",ttype:d},{input:"|~",tag:"mo",output:"\u2308",tex:"lceiling",ttype:d},{input:"~|",tag:"mo",output:"\u2309",tex:"rceiling",ttype:d},{input:"CC",tag:"mo",output:"\u2102",tex:null,ttype:d},{input:"NN",tag:"mo",output:"\u2115",tex:null,ttype:d},{input:"QQ",tag:"mo",output:"\u211A",tex:null,ttype:d},{input:"RR",tag:"mo",output:"\u211D",tex:null,ttype:d},{input:"ZZ",tag:"mo",output:"\u2124",tex:null,ttype:d},{input:"f",tag:"mi",output:"f",tex:null,ttype:H,func:true},{input:"g",tag:"mi",output:"g",tex:null,ttype:H,func:true},{input:"lim",tag:"mo",output:"lim",tex:null,ttype:P},{input:"Lim",tag:"mo",output:"Lim",tex:null,ttype:P},{input:"sin",tag:"mo",output:"sin",tex:null,ttype:H,func:true},{input:"cos",tag:"mo",output:"cos",tex:null,ttype:H,func:true},{input:"tan",tag:"mo",output:"tan",tex:null,ttype:H,func:true},{input:"sinh",tag:"mo",output:"sinh",tex:null,ttype:H,func:true},{input:"cosh",tag:"mo",output:"cosh",tex:null,ttype:H,func:true},{input:"tanh",tag:"mo",output:"tanh",tex:null,ttype:H,func:true},{input:"cot",tag:"mo",output:"cot",tex:null,ttype:H,func:true},{input:"sec",tag:"mo",output:"sec",tex:null,ttype:H,func:true},{input:"csc",tag:"mo",output:"csc",tex:null,ttype:H,func:true},{input:"log",tag:"mo",output:"log",tex:null,ttype:H,func:true},{input:"ln",tag:"mo",output:"ln",tex:null,ttype:H,func:true},{input:"det",tag:"mo",output:"det",tex:null,ttype:H,func:true},{input:"dim",tag:"mo",output:"dim",tex:null,ttype:d},{input:"mod",tag:"mo",output:"mod",tex:null,ttype:d},{input:"gcd",tag:"mo",output:"gcd",tex:null,ttype:H,func:true},{input:"lcm",tag:"mo",output:"lcm",tex:null,ttype:H,func:true},{input:"lub",tag:"mo",output:"lub",tex:null,ttype:d},{input:"glb",tag:"mo",output:"glb",tex:null,ttype:d},{input:"min",tag:"mo",output:"min",tex:null,ttype:P},{input:"max",tag:"mo",output:"max",tex:null,ttype:P},{input:"uarr",tag:"mo",output:"\u2191",tex:"uparrow",ttype:d},{input:"darr",tag:"mo",output:"\u2193",tex:"downarrow",ttype:d},{input:"rarr",tag:"mo",output:"\u2192",tex:"rightarrow",ttype:d},{input:"->",tag:"mo",output:"\u2192",tex:"to",ttype:d},{input:"|->",tag:"mo",output:"\u21A6",tex:"mapsto",ttype:d},{input:"larr",tag:"mo",output:"\u2190",tex:"leftarrow",ttype:d},{input:"harr",tag:"mo",output:"\u2194",tex:"leftrightarrow",ttype:d},{input:"rArr",tag:"mo",output:"\u21D2",tex:"Rightarrow",ttype:d},{input:"lArr",tag:"mo",output:"\u21D0",tex:"Leftarrow",ttype:d},{input:"hArr",tag:"mo",output:"\u21D4",tex:"Leftrightarrow",ttype:d},j,af,A,Q,o,s,h,{input:"hat",tag:"mover",output:"\u005E",tex:null,ttype:H,acc:true},{input:"bar",tag:"mover",output:"\u00AF",tex:"overline",ttype:H,acc:true},{input:"vec",tag:"mover",output:"\u2192",tex:null,ttype:H,acc:true},{input:"dot",tag:"mover",output:".",tex:null,ttype:H,acc:true},{input:"ddot",tag:"mover",output:"..",tex:null,ttype:H,acc:true},{input:"ul",tag:"munder",output:"\u0332",tex:"underline",ttype:H,acc:true},ah,x,p,{input:"bb",tag:"mstyle",atname:"fontweight",atval:"bold",output:"bb",tex:null,ttype:H},{input:"mathbf",tag:"mstyle",atname:"fontweight",atval:"bold",output:"mathbf",tex:null,ttype:H},{input:"sf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"sf",tex:null,ttype:H},{input:"mathsf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"mathsf",tex:null,ttype:H},{input:"bbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"bbb",tex:null,ttype:H,codes:D},{input:"mathbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"mathbb",tex:null,ttype:H,codes:D},{input:"cc",tag:"mstyle",atname:"mathvariant",atval:"script",output:"cc",tex:null,ttype:H,codes:J},{input:"mathcal",tag:"mstyle",atname:"mathvariant",atval:"script",output:"mathcal",tex:null,ttype:H,codes:J},{input:"tt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"tt",tex:null,ttype:H},{input:"mathtt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"mathtt",tex:null,ttype:H},{input:"fr",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"fr",tex:null,ttype:H,codes:N},{input:"mathfrak",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"mathfrak",tex:null,ttype:H,codes:N}];function W(ai,i){if(ai.input>i.input){return 1}else{return -1}}var U=[];function v(){var aj=[],ai;for(ai=0;ai<G.length;ai++){if(G[ai].tex){aj[aj.length]={input:G[ai].tex,tag:G[ai].tag,output:G[ai].output,ttype:G[ai].ttype}}}G=G.concat(aj);G.sort(W);for(ai=0;ai<G.length;ai++){U[ai]=G[ai].input}}var Y="http://www.w3.org/1998/Math/MathML";function R(i){if(q){return g.createElement("m:"+i)}else{return g.createElementNS(Y,i)}}function M(i,aj){if(q){var ai=g.createElement("m:"+i)}else{ai=g.createElementNS(Y,i)}ai.appendChild(aj);return ai}function B(i,ai){G=G.concat([{input:i,tag:"mo",output:ai,tex:null,ttype:Z}]);G.sort(W);for(ac=0;ac<G.length;ac++){U[ac]=G[ac].input}}function u(ak,al){var ai;if(ak.charAt(al)=="\\"&&ak.charAt(al+1)!="\\"&&ak.charAt(al+1)!=" "){ai=ak.slice(al+1)}else{ai=ak.slice(al)}for(var aj=0;aj<ai.length&&ai.charCodeAt(aj)<=32;aj=aj+1){}return ai.slice(aj)}function c(aj,am,an){if(an==0){var al,ai;an=-1;al=aj.length;while(an+1<al){ai=(an+al)>>1;if(aj[ai]<am){an=ai}else{al=ai}}return al}else{for(var ak=an;ak<aj.length&&aj[ak]<am;ak++){}}return ak}function n(ao){var ai=0;var aj=0;var al;var ar;var aq;var am="";var an=true;for(var ak=1;ak<=ao.length&&an;ak++){ar=ao.slice(0,ak);aj=ai;ai=c(U,ar,aj);if(ai<U.length&&ao.slice(0,U[ai].length)==U[ai]){am=U[ai];al=ai;ak=am.length}an=ai<U.length&&ao.slice(0,U[ai].length)>=U[ai]}y=F;if(am!=""){F=G[al].ttype;return G[al]}F=d;ai=1;ar=ao.slice(0,1);var ap=true;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}if(ar==f){ar=ao.slice(ai,ai+1);if("0"<=ar&&ar<="9"){ap=false;ai++;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}}}if((ap&&ai>1)||ai>2){ar=ao.slice(0,ai-1);aq="mn"}else{ai=2;ar=ao.slice(0,1);aq=(("A">ar||ar>"Z")&&("a">ar||ar>"z")?"mo":"mi")}if(ar=="-"&&y==m){F=m;return{input:ar,tag:aq,output:ar,ttype:H,func:true}}return{input:ar,tag:aq,output:ar,ttype:d}}function T(ai){var i;if(ai.nodeName=="mrow"){i=ai.firstChild.firstChild.nodeValue;if(i=="("||i=="["||i=="{"){ai.removeChild(ai.firstChild)}}if(ai.nodeName=="mrow"){i=ai.lastChild.firstChild.nodeValue;if(i==")"||i=="]"||i=="}"){ai.removeChild(ai.lastChild)}}}var K,y,F;function L(ao){var ak,aj,ar,am,aq,an=g.createDocumentFragment();ao=u(ao,0);ak=n(ao);if(ak==null||ak.ttype==l&&K>0){return[null,ao]}if(ak.ttype==Z){ao=ak.output+u(ao,ak.input.length);ak=n(ao)}switch(ak.ttype){case P:case d:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao];case b:K++;ao=u(ao,ak.input.length);ar=w(ao,true);K--;if(typeof ak.invisible=="boolean"&&ak.invisible){aj=M("mrow",ar[0])}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0])}return[aj,ar[1]];case ab:if(ak!=p){ao=u(ao,ak.input.length)}if(ao.charAt(0)=="{"){am=ao.indexOf("}")}else{if(ao.charAt(0)=="("){am=ao.indexOf(")")}else{if(ao.charAt(0)=="["){am=ao.indexOf("]")}else{if(ak==p){am=ao.slice(1).indexOf('"')+1}else{am=0}}}}if(am==-1){am=ao.length}aq=ao.slice(1,am);if(aq.charAt(0)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}an.appendChild(M(ak.tag,g.createTextNode(aq)));if(aq.charAt(aq.length-1)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}ao=u(ao,am+1);return[M("mrow",an),ao];case H:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M(ak.tag,g.createTextNode(ak.output)),ao]}if(typeof ak.func=="boolean"&&ak.func){aq=ao.charAt(0);if(aq=="^"||aq=="_"||aq=="/"||aq=="|"||aq==","){return[M(ak.tag,g.createTextNode(ak.output)),ao]}else{aj=M("mrow",M(ak.tag,g.createTextNode(ak.output)));aj.appendChild(ar[0]);return[aj,ar[1]]}}T(ar[0]);if(ak.input=="sqrt"){return[M(ak.tag,ar[0]),ar[1]]}else{if(typeof ak.acc=="boolean"&&ak.acc){aj=M(ak.tag,ar[0]);aj.appendChild(M("mo",g.createTextNode(ak.output)));return[aj,ar[1]]}else{if(!q&&typeof ak.codes!="undefined"){for(am=0;am<ar[0].childNodes.length;am++){if(ar[0].childNodes[am].nodeName=="mi"||ar[0].nodeName=="mi"){aq=(ar[0].nodeName=="mi"?ar[0].firstChild.nodeValue:ar[0].childNodes[am].firstChild.nodeValue);var ap=[];for(var al=0;al<aq.length;al++){if(aq.charCodeAt(al)>64&&aq.charCodeAt(al)<91){ap=ap+String.fromCharCode(ak.codes[aq.charCodeAt(al)-65])}else{ap=ap+aq.charAt(al)}}if(ar[0].nodeName=="mi"){ar[0]=R("mo").appendChild(g.createTextNode(ap))}else{ar[0].replaceChild(R("mo").appendChild(g.createTextNode(ap)),ar[0].childNodes[am])}}}}aj=M(ak.tag,ar[0]);aj.setAttribute(ak.atname,ak.atval);return[aj,ar[1]]}}case X:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ar[0]);var ai=L(ar[1]);if(ai[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ai[0]);if(ak.input=="root"||ak.input=="stackrel"){an.appendChild(ai[0])}an.appendChild(ar[0]);if(ak.input=="frac"){an.appendChild(ai[0])}return[M(ak.tag,an),ai[1]];case m:ao=u(ao,ak.input.length);return[M("mo",g.createTextNode(ak.output)),ao];case a:ao=u(ao,ak.input.length);aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);an.appendChild(M(ak.tag,g.createTextNode(ak.output)));aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);return[M("mrow",an),ao];case r:K++;ao=u(ao,ak.input.length);ar=w(ao,false);K--;aq="";if(ar[0].lastChild!=null){aq=ar[0].lastChild.firstChild.nodeValue}if(aq=="|"){aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0]);return[aj,ar[1]]}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);return[aj,ao]}default:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao]}}function z(an){var al,ao,am,ak,i,aj;an=u(an,0);ao=n(an);i=L(an);ak=i[0];an=i[1];al=n(an);if(al.ttype==m&&al.input!="/"){an=u(an,al.input.length);i=L(an);if(i[0]==null){i[0]=M("mo",g.createTextNode("\u25A1"))}else{T(i[0])}an=i[1];if(al.input=="_"){am=n(an);aj=(ao.ttype==P);if(am.input=="^"){an=u(an,am.input.length);var ai=L(an);T(ai[0]);an=ai[1];ak=M((aj?"munderover":"msubsup"),ak);ak.appendChild(i[0]);ak.appendChild(ai[0]);ak=M("mrow",ak)}else{ak=M((aj?"munder":"msub"),ak);ak.appendChild(i[0])}}else{ak=M(al.tag,ak);ak.appendChild(i[0])}}return[ak,an]}function w(aq,ap){var av,ar,am,ay,an=g.createDocumentFragment();do{aq=u(aq,0);am=z(aq);ar=am[0];aq=am[1];av=n(aq);if(av.ttype==m&&av.input=="/"){aq=u(aq,av.input.length);am=z(aq);if(am[0]==null){am[0]=M("mo",g.createTextNode("\u25A1"))}else{T(am[0])}aq=am[1];T(ar);ar=M(av.tag,ar);ar.appendChild(am[0]);an.appendChild(ar);av=n(aq)}else{if(ar!=undefined){an.appendChild(ar)}}}while((av.ttype!=l&&(av.ttype!=r||ap)||K==0)&&av!=null&&av.output!="");if(av.ttype==l||av.ttype==r){var az=an.childNodes.length;if(az>0&&an.childNodes[az-1].nodeName=="mrow"&&az>1&&an.childNodes[az-2].nodeName=="mo"&&an.childNodes[az-2].firstChild.nodeValue==","){var aB=an.childNodes[az-1].lastChild.firstChild.nodeValue;if(aB==")"||aB=="]"){var aj=an.childNodes[az-1].firstChild.firstChild.nodeValue;if(aj=="("&&aB==")"&&av.output!="}"||aj=="["&&aB=="]"){var ak=[];var aw=true;var at=an.childNodes.length;for(ay=0;aw&&ay<at;ay=ay+2){ak[ay]=[];ar=an.childNodes[ay];if(aw){aw=ar.nodeName=="mrow"&&(ay==at-1||ar.nextSibling.nodeName=="mo"&&ar.nextSibling.firstChild.nodeValue==",")&&ar.firstChild.firstChild.nodeValue==aj&&ar.lastChild.firstChild.nodeValue==aB}if(aw){for(var ax=0;ax<ar.childNodes.length;ax++){if(ar.childNodes[ax].firstChild.nodeValue==","){ak[ay][ak[ay].length]=ax}}}if(aw&&ay>1){aw=ak[ay].length==ak[ay-2].length}}if(aw){var al,ai,ao,au,aA=g.createDocumentFragment();for(ay=0;ay<at;ay=ay+2){al=g.createDocumentFragment();ai=g.createDocumentFragment();ar=an.firstChild;ao=ar.childNodes.length;au=0;ar.removeChild(ar.firstChild);for(ax=1;ax<ao-1;ax++){if(typeof ak[ay][au]!="undefined"&&ax==ak[ay][au]){ar.removeChild(ar.firstChild);al.appendChild(M("mtd",ai));au++}else{ai.appendChild(ar.firstChild)}}al.appendChild(M("mtd",ai));if(an.childNodes.length>2){an.removeChild(an.firstChild);an.removeChild(an.firstChild)}aA.appendChild(M("mtr",al))}ar=M("mtable",aA);if(typeof av.invisible=="boolean"&&av.invisible){ar.setAttribute("columnalign","left")}an.replaceChild(ar,an.firstChild)}}}}aq=u(aq,av.input.length);if(typeof av.invisible!="boolean"||!av.invisible){ar=M("mo",g.createTextNode(av.output));an.appendChild(ar)}}return[an,aq]}function e(aj){var ai=R("mstyle");if(I!=""){ai.setAttribute("mathcolor",I)}if(t){ai.setAttribute("displaystyle","true")}if(ad!=""){ai.setAttribute("fontfamily",ad)}K=0;ai.appendChild(w(aj.replace(/^\s+/g,""),false)[0]);ai=M("math",ai);if(C){ai.setAttribute("title",aj.replace(/\s+/g," "))}if(ad!=""&&(q||ad!="serif")){var i=V("font");i.setAttribute("face",ad);i.appendChild(ai);return i}return ai}C=false;ad="";I="";(function(){for(var aj=0,ai=G.length;aj<ai;aj++){if(G[aj].codes){delete G[aj].codes}if(G[aj].func){G[aj].tag="mi"}if(G[aj].atname==="fontfamily"||G[aj].atname==="fontweight"){G[aj].atname="mathvariant"}}})();G.push({input:"gt",tag:"mo",output:">",tex:null,ttype:d},{input:"gt=",tag:"mo",output:"\u2265",tex:"geq",ttype:d},{input:"-<=",tag:"mo",output:"\u2AAF",tex:"preceq",ttype:d},{input:">-=",tag:"mo",output:"\u2AB0",tex:"succeq",ttype:d},{input:"'",tag:"mo",output:"\u2032",tex:"prime",ttype:d},{input:"arcsin",tag:"mi",output:"arcsin",tex:null,ttype:H,func:true},{input:"arccos",tag:"mi",output:"arccos",tex:null,ttype:H,func:true},{input:"arctan",tag:"mi",output:"arctan",tex:null,ttype:H,func:true},{input:"coth",tag:"mi",output:"coth",tex:null,ttype:H,func:true},{input:"sech",tag:"mi",output:"sech",tex:null,ttype:H,func:true},{input:"csch",tag:"mi",output:"csch",tex:null,ttype:H,func:true},{input:"abs",tag:"mi",output:"abs",tex:null,ttype:H,func:true},{input:"exp",tag:"mi",output:"exp",tex:null,ttype:H,func:true},{input:"tilde",tag:"mover",output:"~",tex:null,ttype:H,acc:true});ag.Augment({AM:{Init:function(){t=ag.config.displaystyle;decimal=ag.config.decimal;E();v()},Augment:function(i){for(var ai in i){if(i.hasOwnProperty(ai)){switch(ai){case"displaystyle":t=i[ai];break;case"decimal":decimal=i[ai];break;case"parseMath":e=i[ai];break;case"parseExpr":w=i[ai];break;case"parseIexpr":z=i[ai];break;case"parseSexpr":L=i[ai];break;case"removeBrackets":T=i[ai];break;case"getSymbol":n=i[ai];break;case"position":c=i[ai];break;case"removeCharsAndBlanks":u=i[ai];break;case"createMmlNode":M=i[ai];break;case"createElementMathML":R=i[ai];break;case"createElementXHTML":V=i[ai];break;case"initSymbols":v=i[ai];break;case"compareNames":comareNames=i[ai];break}this[ai]=i[ai]}}},parseMath:e,parseExpr:w,parseIexpr:z,parseSexr:L,removeBrackets:T,getSymbol:n,position:c,removeCharsAndBlanks:u,createMmlNode:M,createElementMathML:R,createElementXHTML:V,initSymbols:v,compareNames:W,createDocumentFragment:aa,document:g,define:B,symbols:G,names:U,TOKEN:{CONST:d,UNARY:H,BINARY:X,INFIX:m,LEFTBRACKET:b,RIGHTBRACKET:l,SPACE:a,UNDEROVER:P,DEFINITION:Z,LEFTRIGHT:r,TEXT:ab}}});var ae=[S,O];ae=null})(MathJax.InputJax.AsciiMath);(function(b){var a;b.Augment({sourceMenuTitle:"AsciiMath Input",prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Translate:function(c){var d,f=MathJax.HTML.getScript(c);var g={math:f,script:c};this.prefilterHooks.Execute(g);f=g.math;try{d=this.AM.parseMath(f)}catch(e){if(!e.asciimathError){throw e}d=this.formatError(e,f)}g.math=a(d);this.postfilterHooks.Execute(g);return g.math},formatError:function(f,e,c){var d=f.message.replace(/\n.*/,"");MathJax.Hub.signal.Post(["AsciiMath Jax - parse error",d,e,c]);return a.merror(d)},Error:function(c){throw MathJax.Hub.Insert(Error(c),{asciimathError:true})},Startup:function(){a=MathJax.ElementJax.mml;this.AM.Init()}});b.loadComplete("jax.js")})(MathJax.InputJax.AsciiMath);

MathJax.Ajax.loadComplete("[MathJax]/config/AM_HTMLorMML.js");
