/*
 * Decompiled with CFR 0.152.
 */
package GX;

import GX.Codon;
import GX.ColorSequencer;
import GX.Exon;
import GX.HTMLContainer;
import GX.Nucleotide;
import java.util.ArrayList;

public class Gene {
    String _promoterSequence;
    int _promoterSpacing;
    String _terminatorSequence;
    String _intronStartSequence;
    String _intronEndSequence;
    String _polyATail;
    int _promoterStart;
    int _terminatorStart;
    int _numSpacesBeforeRNA_Start;
    int _numberOfExons;
    int _numCharsInDisplayBeforeFirstDNA_Base;
    String _DNASequence;
    String _premRNASequence;
    String _mRNASequence;
    String _proteinSequence;
    String _proteinString;
    public ArrayList _DNANucleotides = new ArrayList();
    ArrayList _exons;

    public Gene(String inputDNASequence, String promoterSequence, int promoterSpacing, String terminatorSequence, String intronStartSequence, String intronEndSequence, String polyATail) {
        this._DNASequence = inputDNASequence;
        this._promoterSequence = promoterSequence;
        this._promoterSpacing = promoterSpacing;
        this._terminatorSequence = terminatorSequence;
        this._intronStartSequence = intronStartSequence;
        this._intronEndSequence = intronEndSequence;
        this._polyATail = polyATail;
        this._promoterStart = -1;
        this._terminatorStart = -1;
        this._numSpacesBeforeRNA_Start = 0;
        this._numberOfExons = 0;
        this._numCharsInDisplayBeforeFirstDNA_Base = 0;
        this._premRNASequence = new String("");
        this._mRNASequence = new String("");
        this._proteinSequence = new String("");
        this._proteinString = new String("");
        int i = 0;
        while (i < inputDNASequence.length()) {
            this._DNANucleotides.add(new Nucleotide(this._DNASequence.charAt(i), i));
            ++i;
        }
    }

    public void transcribe() {
        int promoterSite = this._DNASequence.indexOf(this._promoterSequence);
        int terminatorSite = this._DNASequence.indexOf(this._terminatorSequence, promoterSite);
        StringBuffer pre_mRNAbuffer = new StringBuffer();
        if (promoterSite != -1) {
            Nucleotide nucleotide;
            int mRNANucleotideNumber = 0;
            this._promoterStart = promoterSite;
            this._numSpacesBeforeRNA_Start = this._promoterStart + this._promoterSequence.length() + this._promoterSpacing;
            this._terminatorStart = terminatorSite != -1 ? terminatorSite : this._DNASequence.length();
            int i = this._numSpacesBeforeRNA_Start;
            while (i < this._terminatorStart) {
                nucleotide = (Nucleotide)this._DNANucleotides.get(i);
                nucleotide.setInPremRNA();
                nucleotide.setPremRNABaseNum(mRNANucleotideNumber);
                ++mRNANucleotideNumber;
                ++i;
            }
            i = 0;
            while (i < this._DNASequence.length()) {
                nucleotide = (Nucleotide)this._DNANucleotides.get(i);
                pre_mRNAbuffer.append(nucleotide.getRNABase());
                ++i;
            }
            this._premRNASequence = pre_mRNAbuffer.toString().trim();
        } else {
            this._premRNASequence = "";
        }
    }

    public void process() {
        if (!this._premRNASequence.equals("")) {
            int currentNucleotideNum = 0;
            StringBuffer mRNAbuffer = new StringBuffer();
            int currentmRNABase = 0;
            while (currentNucleotideNum != -1) {
                Exon currentExon = this.findNextExon(currentNucleotideNum);
                ++this._numberOfExons;
                currentNucleotideNum = currentExon.getStartOfNext();
                int i = currentExon.getStart();
                while (i < currentExon.getEnd()) {
                    Nucleotide nucleotide = (Nucleotide)this._DNANucleotides.get(i + this._numSpacesBeforeRNA_Start);
                    nucleotide.setInmRNA();
                    nucleotide.setmRNABaseNum(currentmRNABase);
                    ++currentmRNABase;
                    mRNAbuffer.append(nucleotide.getRNABase());
                    ++i;
                }
            }
            int i = this._terminatorStart;
            while (i < this._terminatorStart + this._polyATail.length()) {
                Nucleotide nucleotide;
                if (i >= this._DNANucleotides.size()) {
                    nucleotide = new Nucleotide('A', i);
                    nucleotide.setInmRNA();
                    this._DNANucleotides.add(nucleotide);
                } else {
                    nucleotide = (Nucleotide)this._DNANucleotides.get(i);
                    nucleotide.setInmRNA();
                }
                ++i;
            }
            this._mRNASequence = String.valueOf(mRNAbuffer.toString()) + this._polyATail;
        } else {
            this._mRNASequence = "";
        }
    }

    public Exon findNextExon(int currentPosition) {
        int startSite = this._premRNASequence.indexOf(this._intronStartSequence, currentPosition);
        if (startSite == -1) {
            return new Exon(currentPosition, this._premRNASequence.length(), -1);
        }
        int endSite = this._premRNASequence.indexOf(this._intronEndSequence, startSite);
        if (endSite == -1) {
            return new Exon(currentPosition, this._premRNASequence.length(), -1);
        }
        return new Exon(currentPosition, startSite, endSite + this._intronEndSequence.length());
    }

    public void translate() {
        if (!this._mRNASequence.equals("")) {
            String codon;
            boolean aaNum = false;
            boolean baseInCodon = false;
            int currentmRNABase = 0;
            String currentAA = new String("");
            StringBuffer proteinBuffer = new StringBuffer();
            int i = 0;
            while (i < this._DNANucleotides.size()) {
                Nucleotide base = (Nucleotide)this._DNANucleotides.get(i);
                if (base.getInmRNA()) {
                    Nucleotide base1 = this.getNextmRNANucleotide(i);
                    Nucleotide base2 = this.getNextmRNANucleotide(base1.getDNABaseNum() + 1);
                    Nucleotide base3 = this.getNextmRNANucleotide(base2.getDNABaseNum() + 1);
                    codon = String.valueOf(base1.getRNABase()) + base2.getRNABase() + base3.getRNABase();
                    currentmRNABase = base3.getDNABaseNum();
                    if (codon.equals("AUG")) {
                        this.setCodonValues(0, base1, base2, base3);
                        proteinBuffer.append(Codon.getAA(codon));
                        break;
                    }
                }
                ++i;
            }
            int codonNum = 1;
            int j = currentmRNABase + 1;
            while (j <= this._DNANucleotides.size()) {
                Nucleotide first = this.getNextmRNANucleotide(j);
                Nucleotide second = this.getNextmRNANucleotide(first.getDNABaseNum() + 1);
                Nucleotide third = this.getNextmRNANucleotide(second.getDNABaseNum() + 1);
                codon = String.valueOf(first.getRNABase()) + second.getRNABase() + third.getRNABase();
                if (j + 2 >= this._DNANucleotides.size()) break;
                j = third.getDNABaseNum() + 1;
                proteinBuffer.append(Codon.getAA(codon));
                this.setCodonValues(codonNum, first, second, third);
                if (Codon.getAA(codon).equals("")) {
                    this.setCodonValues(-2, first, second, third);
                    break;
                }
                ++codonNum;
            }
            this._proteinSequence = proteinBuffer.toString();
        } else {
            this._proteinSequence = "";
        }
    }

    public Nucleotide getNextmRNANucleotide(int DNABaseNum) {
        if (DNABaseNum >= this._DNANucleotides.size()) {
            DNABaseNum = this._DNANucleotides.size() - 1;
        }
        Nucleotide nucleotide = (Nucleotide)this._DNANucleotides.get(DNABaseNum);
        while (!nucleotide.getInmRNA() && DNABaseNum < this._DNANucleotides.size()) {
            nucleotide = (Nucleotide)this._DNANucleotides.get(DNABaseNum);
            ++DNABaseNum;
        }
        return nucleotide;
    }

    public void setCodonValues(int AANum, Nucleotide first, Nucleotide second, Nucleotide third) {
        first.setInProtein();
        first.setAANum(AANum);
        first.setCodonPosition(0);
        second.setInProtein();
        second.setAANum(AANum);
        second.setCodonPosition(1);
        third.setInProtein();
        third.setAANum(AANum);
        third.setCodonPosition(2);
    }

    public void showItAll() {
        System.out.println("#\tDb\tRb\tpm\tm\tprot\taa\tcp\tsel");
        int i = 0;
        while (i < this._DNANucleotides.size()) {
            Nucleotide nuc = (Nucleotide)this._DNANucleotides.get(i);
            System.out.println(String.valueOf(i) + "\t" + nuc.getBase() + "\t" + nuc.getRNABase() + "\t" + this.convertBoolean(nuc.getInPremRNA()) + " " + nuc.getPremRNABaseNum() + "\t" + this.convertBoolean(nuc.getInmRNA()) + " " + nuc.getmRNABaseNum() + "\t" + this.convertBoolean(nuc.getInProtein()) + "\t" + nuc.getAANum() + "\t" + nuc.getCodonPosition() + "\t" + this.convertBoolean(nuc.getSelected()));
            ++i;
        }
    }

    public String convertBoolean(boolean b) {
        if (b) {
            return "Y";
        }
        return "N";
    }

    public HTMLContainer generateHTML(int selectedDNABase) {
        if (selectedDNABase != -1) {
            Nucleotide nuc = (Nucleotide)this._DNANucleotides.get(selectedDNABase);
            nuc.setSelected();
        }
        StringBuffer colorHTMLbuffer = new StringBuffer();
        StringBuffer bwHTMLbuffer = new StringBuffer();
        HTMLContainer headerHTML = this.generateHTMLHeader();
        colorHTMLbuffer.append(headerHTML.getColorHTML());
        bwHTMLbuffer.append(headerHTML.getBwHTML());
        HTMLContainer DNA_HTML = this.generateDNA_HTML(selectedDNABase);
        colorHTMLbuffer.append(DNA_HTML.getColorHTML());
        bwHTMLbuffer.append(DNA_HTML.getBwHTML());
        this._numCharsInDisplayBeforeFirstDNA_Base = this.calcCharsBeforeFirstDNA_Base(DNA_HTML.getColorHTML());
        HTMLContainer premRNA_HTML = this.generatepremRNA_HTML(selectedDNABase);
        colorHTMLbuffer.append(premRNA_HTML.getColorHTML());
        bwHTMLbuffer.append(premRNA_HTML.getBwHTML());
        HTMLContainer mRNA_HTML = this.generatemRNA_HTML(selectedDNABase);
        colorHTMLbuffer.append(mRNA_HTML.getColorHTML());
        bwHTMLbuffer.append(mRNA_HTML.getBwHTML());
        HTMLContainer protein_HTML = this.generateProteinHTML(selectedDNABase);
        colorHTMLbuffer.append(protein_HTML.getColorHTML());
        bwHTMLbuffer.append(protein_HTML.getBwHTML());
        return new HTMLContainer(colorHTMLbuffer.toString(), bwHTMLbuffer.toString());
    }

    public HTMLContainer generateHTMLHeader() {
        StringBuffer headerBuffer = new StringBuffer();
        headerBuffer.append("<html><head>");
        headerBuffer.append("<style type=\"text/css\">");
        headerBuffer.append("EM.selected {font-style: normal; background: blue; color: red}");
        headerBuffer.append("EM.promoter {font-style: normal; background: #90FF90; color: black}");
        headerBuffer.append("EM.terminator {font-style: normal; background: #FF9090; color: black}");
        headerBuffer.append("EM.exon {font-style: normal; background: #FF90FF; color: black}");
        headerBuffer.append("EM.next {font-style: normal; background: #FF8C00; color: black}");
        headerBuffer.append("EM.another {font-style: normal; background: #FFFF50; color: black}");
        headerBuffer.append("</style></head><body>");
        return new HTMLContainer(headerBuffer.toString(), "");
    }

    public HTMLContainer generateDNA_HTML(int selectedBase) {
        StringBuffer BW_Buffer = new StringBuffer();
        StringBuffer ColorBuffer = new StringBuffer();
        boolean highlighted = false;
        String fivePrimeSpaces = "    ";
        ColorBuffer.append("<html><h3>DNA: <EM class=promoter>Promoter</EM>");
        ColorBuffer.append("<EM class=terminator>Terminator</EM></h3><pre>\n");
        BW_Buffer.append("<h3>DNA: promoter, terminator</h3><pre>\n");
        ColorBuffer.append(fivePrimeSpaces);
        BW_Buffer.append(fivePrimeSpaces);
        int i = 0;
        while (i < this._DNASequence.length()) {
            String numberLabel = new String("");
            numberLabel = i == 0 ? "" : (i < 100 ? "        " + i : "       " + i);
            ColorBuffer.append(numberLabel);
            BW_Buffer.append(numberLabel);
            i += 10;
        }
        ColorBuffer.append("\n");
        BW_Buffer.append("\n");
        String tickMarkString = "    .    |";
        ColorBuffer.append(fivePrimeSpaces);
        BW_Buffer.append(fivePrimeSpaces);
        int i2 = 0;
        while (i2 < this._DNASequence.length()) {
            if (i2 > 0) {
                ColorBuffer.append("    .    |");
                BW_Buffer.append("    .    |");
            }
            i2 += 10;
        }
        ColorBuffer.append("\n");
        BW_Buffer.append("\n");
        StringBuffer ColorTopStrandBuffer = new StringBuffer();
        StringBuffer ColorBasePairBuffer = new StringBuffer();
        StringBuffer ColorBottomStrandBuffer = new StringBuffer();
        StringBuffer BW_TopStrandBuffer = new StringBuffer();
        StringBuffer BW_BasePairBuffer = new StringBuffer();
        StringBuffer BW_BottomStrandBuffer = new StringBuffer();
        int i3 = 0;
        while (i3 < this._DNASequence.length()) {
            Nucleotide n = (Nucleotide)this._DNANucleotides.get(i3);
            if (i3 == this._promoterStart) {
                highlighted = true;
            }
            if (i3 == this._promoterStart + this._promoterSequence.length()) {
                highlighted = false;
            }
            if (i3 == this._terminatorStart) {
                highlighted = true;
            }
            if (i3 == this._terminatorStart + this._terminatorSequence.length()) {
                highlighted = false;
            }
            ColorTopStrandBuffer.append(this.markUpNucleotideSymbol(i3, n.getBase(), n.getSelected(), highlighted).getColorHTML());
            ColorBasePairBuffer.append(this.markUpNucleotideSymbol(i3, "|", n.getSelected(), highlighted).getColorHTML());
            ColorBottomStrandBuffer.append(this.markUpNucleotideSymbol(i3, n.getComplementBase(), n.getSelected(), highlighted).getColorHTML());
            BW_TopStrandBuffer.append(this.markUpNucleotideSymbol(i3, n.getBase(), n.getSelected(), highlighted).getBwHTML());
            BW_BasePairBuffer.append(this.markUpNucleotideSymbol(i3, "|", n.getSelected(), highlighted).getBwHTML());
            BW_BottomStrandBuffer.append(this.markUpNucleotideSymbol(i3, n.getComplementBase(), n.getSelected(), highlighted).getBwHTML());
            ++i3;
        }
        ColorBuffer.append("5'-");
        ColorBuffer.append(String.valueOf(ColorTopStrandBuffer.toString()) + "</EM>-3'\n" + "   " + ColorBasePairBuffer.toString() + "</EM>\n" + "3'-" + ColorBottomStrandBuffer.toString());
        ColorBuffer.append("</EM>-5'\n");
        BW_Buffer.append("5'-");
        BW_Buffer.append(String.valueOf(BW_TopStrandBuffer.toString()) + "-3'\n" + "   " + BW_BasePairBuffer.toString() + "\n" + "3'-" + BW_BottomStrandBuffer.toString());
        BW_Buffer.append("-5'\n");
        return new HTMLContainer(ColorBuffer.toString(), BW_Buffer.toString());
    }

    public HTMLContainer generatepremRNA_HTML(int selectedDNABase) {
        StringBuffer BW_Buffer = new StringBuffer();
        StringBuffer ColorBuffer = new StringBuffer();
        boolean highlighted = false;
        ColorSequencer exonColorSequencer = new ColorSequencer();
        if (!this._intronStartSequence.equals("none") && !this._intronEndSequence.equals("none")) {
            ColorBuffer.append("</pre><h3>pre-mRNA: <EM class=exon>Ex</EM><EM class=next>o</EM><EM class=another>n</EM> Intron</h3><pre>");
            BW_Buffer.append("</pre><h3>pre-mRNA: EXON intron</h3><pre>");
            if (!this._premRNASequence.equals("")) {
                int i = 0;
                while (i < this._numSpacesBeforeRNA_Start) {
                    ColorBuffer.append(" ");
                    BW_Buffer.append(" ");
                    ++i;
                }
                ColorBuffer.append("5'-");
                BW_Buffer.append("5'-");
                i = 0;
                while (i < this._DNASequence.length()) {
                    Nucleotide current = (Nucleotide)this._DNANucleotides.get(i);
                    Nucleotide prev = i != 0 ? (Nucleotide)this._DNANucleotides.get(i - 1) : (Nucleotide)this._DNANucleotides.get(i);
                    if (current.getInPremRNA()) {
                        if (!prev.getInmRNA() && current.getInmRNA()) {
                            ColorBuffer.append("<EM class=" + exonColorSequencer.getNextColor() + ">");
                            highlighted = true;
                        }
                        if (prev.getInmRNA() && !current.getInmRNA()) {
                            ColorBuffer.append("</EM>");
                            highlighted = false;
                        }
                        if (current.getSelected()) {
                            ColorBuffer.append("<EM class=selected>");
                            ColorBuffer.append(current.getRNABase());
                            ColorBuffer.append("</EM>");
                            if (highlighted) {
                                BW_Buffer.append(current.getRNABase().toLowerCase());
                            } else {
                                BW_Buffer.append(current.getRNABase());
                            }
                        } else {
                            ColorBuffer.append(current.getRNABase());
                            if (highlighted) {
                                BW_Buffer.append(current.getRNABase());
                            } else {
                                BW_Buffer.append(current.getRNABase().toLowerCase());
                            }
                        }
                    }
                    ++i;
                }
                ColorBuffer.append("</EM>-3'\n");
                BW_Buffer.append("-3'\n");
            } else {
                ColorBuffer.append("<font color=red>none</font>\n");
                BW_Buffer.append("none\n");
            }
        }
        return new HTMLContainer(ColorBuffer.toString(), BW_Buffer.toString());
    }

    public HTMLContainer generatemRNA_HTML(int selectedDNABase) {
        int i;
        StringBuffer BW_Buffer = new StringBuffer();
        StringBuffer ColorBuffer = new StringBuffer();
        boolean highlighted = false;
        boolean inPolyA = false;
        ColorSequencer exonColorSequencer = new ColorSequencer();
        ColorBuffer.append("</pre><h3>");
        BW_Buffer.append("</pre><h3>");
        if (!this._intronStartSequence.equals("none") && !this._intronEndSequence.equals("none")) {
            ColorBuffer.append("mature-");
            BW_Buffer.append("mature-");
        }
        ColorBuffer.append("mRNA and Protein (<font color=blue>previous</font>):</h3><pre>");
        BW_Buffer.append("mRNA and Protein (previous on line below):</h3><pre>");
        if (this._intronStartSequence.equals("none") || this._intronEndSequence.equals("none")) {
            i = 0;
            while (i < this._numSpacesBeforeRNA_Start) {
                ColorBuffer.append(" ");
                BW_Buffer.append(" ");
                ++i;
            }
        }
        if (!this._mRNASequence.equals("")) {
            ColorBuffer.append("5'-");
            BW_Buffer.append("5'-");
            i = 0;
            while (i < this._DNANucleotides.size()) {
                Nucleotide current = (Nucleotide)this._DNANucleotides.get(i);
                Nucleotide prev = i != 0 ? (Nucleotide)this._DNANucleotides.get(i - 1) : (Nucleotide)this._DNANucleotides.get(i);
                Nucleotide next = i != this._DNANucleotides.size() - 1 ? (Nucleotide)this._DNANucleotides.get(i + 1) : (Nucleotide)this._DNANucleotides.get(i);
                if (current.getInmRNA()) {
                    if (!prev.getInmRNA() && current.getInmRNA()) {
                        ColorBuffer.append("<EM class=" + exonColorSequencer.getNextColor() + ">");
                        if (highlighted) {
                            ColorBuffer.append("<u>");
                        }
                    }
                    if (!current.getInPremRNA() && current.getInmRNA() && !inPolyA) {
                        ColorBuffer.append("</EM>");
                        inPolyA = true;
                    }
                    if ((current.getAANum() == 0 || current.getAANum() == -2) && current.getCodonPosition() == 0 && current.getInPremRNA()) {
                        ColorBuffer.append("<u>");
                        highlighted = true;
                    }
                    if (current.getAANum() == 1 && current.getCodonPosition() == 0) {
                        ColorBuffer.append("</u>");
                        highlighted = false;
                    }
                    if (current.getAANum() == -1 && prev.getAANum() == -2) {
                        ColorBuffer.append("</u>");
                        highlighted = false;
                    }
                    if (current.getSelected() && current.getInPremRNA()) {
                        ColorBuffer.append("<EM class=selected>");
                        ColorBuffer.append(current.getRNABase());
                        ColorBuffer.append("</EM>");
                        if (highlighted) {
                            BW_Buffer.append(current.getRNABase());
                        } else {
                            BW_Buffer.append(current.getRNABase().toLowerCase());
                        }
                    } else {
                        ColorBuffer.append(current.getRNABase());
                        if (highlighted) {
                            BW_Buffer.append(current.getRNABase().toLowerCase());
                        } else {
                            BW_Buffer.append(current.getRNABase());
                        }
                    }
                    if (current.getInmRNA() && !next.getInmRNA()) {
                        ColorBuffer.append("</EM>");
                    }
                }
                ++i;
            }
            ColorBuffer.append("-3'\n");
            BW_Buffer.append("-3'\n");
        } else {
            ColorBuffer.append("<font color=red>none</font>\n");
            BW_Buffer.append("none\n");
        }
        return new HTMLContainer(ColorBuffer.toString(), BW_Buffer.toString());
    }

    public HTMLContainer generateProteinHTML(int selectedDNABase) {
        int i;
        StringBuffer BW_Buffer = new StringBuffer();
        StringBuffer ColorBuffer = new StringBuffer();
        boolean highlighted = false;
        StringBuffer proteinStringBuffer = new StringBuffer();
        if (this._intronStartSequence.equals("none") || this._intronEndSequence.equals("none")) {
            i = 0;
            while (i < this._numSpacesBeforeRNA_Start) {
                proteinStringBuffer.append(" ");
                BW_Buffer.append(" ");
                ++i;
            }
        }
        if (!this._proteinSequence.equals("")) {
            Nucleotide n;
            i = 0;
            while (i < this._DNASequence.length()) {
                n = (Nucleotide)this._DNANucleotides.get(i);
                if (n.getInmRNA()) {
                    if (n.getAANum() == 0) break;
                    proteinStringBuffer.append(" ");
                    BW_Buffer.append(" ");
                }
                ++i;
            }
            proteinStringBuffer.append(" N-");
            BW_Buffer.append(" N-" + this._proteinSequence + "-C\n");
            if (selectedDNABase != -1) {
                StringBuffer proteinBuffer = new StringBuffer(this._proteinSequence);
                n = (Nucleotide)this._DNANucleotides.get(selectedDNABase);
                if (n.getAANum() >= 0) {
                    proteinBuffer = proteinBuffer.insert(n.getAANum() * 3 + 3, "</EM>");
                    proteinBuffer = proteinBuffer.insert(n.getAANum() * 3 + n.getCodonPosition() + 1, "</u>");
                    proteinBuffer = proteinBuffer.insert(n.getAANum() * 3 + n.getCodonPosition(), "<u>");
                    proteinBuffer = proteinBuffer.insert(n.getAANum() * 3, "<EM class=selected>");
                }
                proteinStringBuffer.append(String.valueOf(proteinBuffer.toString()) + "-C");
            } else {
                proteinStringBuffer.append(String.valueOf(this._proteinSequence) + "-C");
            }
        } else {
            proteinStringBuffer.append("<font color=red>none</font>\n");
            BW_Buffer.append("none\n");
        }
        this._proteinString = proteinStringBuffer.toString();
        ColorBuffer.append(String.valueOf(this._proteinString) + "\n");
        return new HTMLContainer(ColorBuffer.toString(), BW_Buffer.toString());
    }

    public HTMLContainer markUpNucleotideSymbol(int nucleotideNum, String nucleotideSymbol, boolean selected, boolean highlighted) {
        StringBuffer BW_Buffer = new StringBuffer();
        StringBuffer ColorBuffer = new StringBuffer();
        if (nucleotideNum == this._promoterStart) {
            ColorBuffer.append("<EM class=promoter>");
        }
        if (nucleotideNum == this._promoterStart + this._promoterSequence.length()) {
            ColorBuffer.append("</EM>");
        }
        if (nucleotideNum == this._terminatorStart) {
            ColorBuffer.append("<EM class=terminator>");
        }
        if (nucleotideNum == this._terminatorStart + this._terminatorSequence.length()) {
            ColorBuffer.append("</EM>");
        }
        if (selected) {
            ColorBuffer.append("<EM class=selected>");
            ColorBuffer.append(nucleotideSymbol);
            ColorBuffer.append("</EM>");
            if (highlighted) {
                BW_Buffer.append(nucleotideSymbol);
            } else {
                BW_Buffer.append(nucleotideSymbol.toLowerCase());
            }
        } else {
            ColorBuffer.append(nucleotideSymbol);
            if (highlighted) {
                BW_Buffer.append(nucleotideSymbol.toLowerCase());
            } else {
                BW_Buffer.append(nucleotideSymbol);
            }
        }
        return new HTMLContainer(ColorBuffer.toString(), BW_Buffer.toString());
    }

    public int calcCharsBeforeFirstDNA_Base(String HTMLstring) {
        String noHTMLstring = HTMLstring.replaceAll("<[^<]*>", "");
        return noHTMLstring.indexOf("5'-") + 4;
    }

    public int getHeaderLength() {
        return this._numCharsInDisplayBeforeFirstDNA_Base;
    }

    public int getDNASequenceLength() {
        return this._DNASequence.length();
    }

    public String getProteinString() {
        String s = new String(this._proteinString);
        s = s.replaceAll("<EM class=selected>", "");
        s = s.replaceAll("</EM>", "");
        s = s.replaceAll("<u>", "");
        return s.replaceAll("</u>", "");
    }
}

