;(function (define) {
    'use strict';
    define([
        'backbone',
        'gettext',
        'teams/js/views/teams',
        'common/js/components/views/paging_header',
        'text!teams/templates/team-actions.underscore'
    ], function (Backbone, gettext, TeamsView, PagingHeader, teamActionsTemplate) {
            var TopicTeamsView = TeamsView.extend({
                events: {
                    'click a.browse-teams': 'browseTeams',
                    'click a.search-teams': 'searchTeams',
                    'click a.create-team': 'showCreateTeamForm'
                },

                initialize: function(options) {
                    this.showSortControls = options.showSortControls;
                    TeamsView.prototype.initialize.call(this, options);
                },

                render: function() {
                    var self = this;
                    $.when(
                        this.collection.refresh(),
                        this.teamMemberships.refresh()
                    ).done(function() {
                            TeamsView.prototype.render.call(self);

                            if (self.teamMemberships.canUserCreateTeam()) {
                                var message = interpolate_text(
                                    // Translators: this string is shown at the bottom of the teams page
                                    // to find a team to join or else to create a new one. There are three
                                    // links that need to be included in the message:
                                    // 1. Browse teams in other topics
                                    // 2. search teams
                                    // 3. create a new team
                                    // Be careful to start each link with the appropriate start indicator
                                    // (e.g. {browse_span_start} for #1) and finish it with {span_end}.
                                    _.escape(gettext("{browse_span_start}Browse teams in other topics{span_end} or {search_span_start}search teams{span_end} in this topic. If you still can't find a team to join, {create_span_start}create a new team in this topic{span_end}.")),
                                    {
                                        'browse_span_start': '<a class="browse-teams" href="">',
                                        'search_span_start': '<a class="search-teams" href="">',
                                        'create_span_start': '<a class="create-team" href="">',
                                        'span_end': '</a>'
                                    }
                                );
                                self.$el.append(_.template(teamActionsTemplate, {message: message}));
                            }
                        });
                    return this;
                },

                browseTeams: function (event) {
                    event.preventDefault();
                    Backbone.history.navigate('browse', {trigger: true});
                },

                searchTeams: function (event) {
                    //var searchField = $('.page-header-search .search-field');
                    event.preventDefault();
                    //searchField.focus();
                    //searchField.select();
                    //$('html, body').animate({
                    //    scrollTop: 0
                    //}, 500);

                    // TODO! Will navigate to correct place once required functionality is available
                    Backbone.history.navigate('browse', {trigger: true});
                },

                showCreateTeamForm: function (event) {
                    event.preventDefault();
                    Backbone.history.navigate('topics/' + this.model.id + '/create-team', {trigger: true});
                },

                createHeaderView: function () {
                    return new PagingHeader({
                        collection: this.options.collection,
                        srInfo: this.srInfo,
                        showSortControls: this.showSortControls
                    });
                }
            });

            return TopicTeamsView;
        });
}).call(this, define || RequireJS.define);
