"""
Errors for self-assessment
"""

class SelfAssessmentError(Exception):
    """Generic Self Assessment Error

    Raised when an error occurs while processing a request related to the
    Self Assessment Workflow.

    """
    pass


class SelfAssessmentRequestError(SelfAssessmentError):
    """
    There was a problem with the request for a self-assessment.
    """
    pass


class SelfAssessmentInternalError(SelfAssessmentError):
    """
    There was an internal problem while accessing the self-assessment api.
    """
    pass
