/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.edx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.edx.AminoAcid;

public class Utils {
    static String filename = "codonTable.txt";
    static Map<String, AminoAcid> codonTable;

    public static final byte complement(byte b) {
        switch (b) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b;
    }

    public static String getNucleotideComplement(String sequence) {
        char[] complement = new char[sequence.length()];
        int jj = complement.length;
        block6: for (int ii = 0; ii < sequence.length(); ++ii) {
            char c = sequence.charAt(ii);
            --jj;
            switch (c) {
                case 'T': 
                case 't': {
                    complement[jj] = 65;
                    continue block6;
                }
                case 'A': 
                case 'a': {
                    complement[jj] = 84;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    complement[jj] = 71;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    complement[jj] = 67;
                    continue block6;
                }
                default: {
                    complement[jj] = c;
                }
            }
        }
        return new String(complement);
    }

    public static AminoAcid getAminoAcid(String codon) {
        AminoAcid aa = null;
        if (codonTable == null) {
            Utils.initCodonTable();
        }
        if (codonTable == null || codon == null) {
            aa = AminoAcid.NULL_AMINO_ACID;
        } else {
            aa = codonTable.get(codon);
            if (aa == null) {
                aa = AminoAcid.NULL_AMINO_ACID;
            }
        }
        return aa;
    }

    static synchronized void initCodonTable() {
        if (codonTable == null) {
            try {
                InputStream is = Utils.class.getResourceAsStream("codonTable.txt");
                if (is == null) {
                    return;
                }
                codonTable = new HashMap<String, AminoAcid>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    if (tokens.length != 4) continue;
                    String codon = tokens[0].trim().toUpperCase();
                    String fullName = tokens[1].trim();
                    String shortName = tokens[2].trim();
                    char symbol = tokens[3].trim().charAt(0);
                    codonTable.put(codon, new AminoAcid(fullName, shortName, symbol));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

