/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.edx;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.NumberFormatter;
import org.broad.igv.edx.AminoAcid;
import org.broad.igv.edx.EdxApplet;
import org.broad.igv.edx.EdxModel;
import org.broad.igv.edx.Strand;
import org.broad.igv.edx.Utils;

class SequencePanel
extends Panel {
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    public static final Color AA_COLOR_1;
    public static final Color AA_COLOR_2;
    public static final Color AA_FONT_COLOR;
    protected static final Color STOP_CODON_COLOR;
    protected static final Color METHIONINE_COLOR;
    protected static final Color NUCLEOTIDE_SEPARATOR_COLOR;
    EdxApplet applet;
    EdxModel model;
    private final Font seqFont;
    private final Font rulerFont;
    private final int aaFrameHeight = 18;
    private int horizontalInsert = 20;
    private boolean colorNucelotides;
    private boolean colorMethionines;
    NumberFormatter formatter;

    SequencePanel(EdxApplet theApplet, EdxModel theModel) {
        this.applet = theApplet;
        this.model = theModel;
        this.formatter = new NumberFormatter();
        this.seqFont = new Font("Arial", 1, 12);
        this.rulerFont = new Font("Arial", 0, 8);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            int lastMouseX;

            @Override
            public void mousePressed(MouseEvent e) {
                this.lastMouseX = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                double dx = (double)(this.lastMouseX - e.getX()) * SequencePanel.this.model.getScale();
                SequencePanel.this.model.setOrigin(Math.max((double)SequencePanel.this.model.getSeqStart(), SequencePanel.this.model.getOrigin() + dx));
                SequencePanel.this.applet.updatePanels();
                this.lastMouseX = e.getX();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @Override
    public void paint(Graphics g) {
        int p;
        int nucIdx;
        int aaIdx;
        int startIdx;
        int p2;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g.getFontMetrics(this.seqFont);
        FontMetrics rulerFM = g.getFontMetrics(this.rulerFont);
        g.setColor(Color.black);
        int y = 20;
        int basePosition = (int)this.model.getOrigin() + 1;
        while (true) {
            int p3 = (int)(((double)basePosition - 0.5 - this.model.getOrigin()) / this.model.getScale());
            int b = 3;
            int h = 5;
            if (basePosition % 5 == 0) {
                b = 2;
                h = 8;
                try {
                    String label = this.formatter.valueToString(basePosition);
                    int stringWidth = rulerFM.stringWidth(label);
                    g.setFont(this.rulerFont);
                    g.drawString(label, p3 - stringWidth / 2, y);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (p3 > this.getWidth()) break;
            g.drawLine(p3, y + b, p3, y + h);
            ++basePosition;
        }
        g.setFont(this.seqFont);
        y += 25;
        for (int i = startIdx = (int)this.model.getOrigin() - this.model.getSeqStart(); i < this.model.getSequence().length && (p2 = (int)(((double)(this.model.getSeqStart() + i) - this.model.getOrigin()) / this.model.getScale())) <= this.getWidth(); ++i) {
            Color color;
            char c = (char)this.model.getSequence()[i];
            int cw = fm.charWidth(c);
            int offset = (int)((1.0 / this.model.getScale() - (double)cw) / 2.0);
            if (this.colorNucelotides && (color = nucleotideColors.get(Character.valueOf(c))) != null) {
                g.setColor(color);
            }
            g.drawChars(new char[]{c}, 0, 1, p2 + offset, y);
        }
        y += 5;
        int aaStartIdx = Math.max(0, startIdx / 3 - 1);
        int aaEndIdx = this.model.getSequence().length / 3;
        boolean alt = aaStartIdx % 2 == 0;
        for (aaIdx = aaStartIdx; aaIdx < aaEndIdx; ++aaIdx) {
            nucIdx = aaIdx * 3;
            if (this.drawFrame(g, fm, y, nucIdx++, Strand.POSITIVE, alt)) break;
            this.drawFrame(g, fm, y + 18, nucIdx++, Strand.POSITIVE, alt);
            this.drawFrame(g, fm, y + 36, nucIdx, Strand.POSITIVE, alt);
            alt = !alt;
        }
        y += 72;
        g.setColor(Color.black);
        for (int i = startIdx = (int)this.model.getOrigin() - this.model.getSeqStart(); i < this.model.getSequence().length && (p = (int)(((double)(this.model.getSeqStart() + i) - this.model.getOrigin()) / this.model.getScale())) <= this.getWidth(); ++i) {
            Color color;
            char c = (char)this.model.getComplementSequence()[i];
            int cw = fm.charWidth(c);
            int offset = (int)((1.0 / this.model.getScale() - (double)cw) / 2.0);
            if (this.colorNucelotides && (color = nucleotideColors.get(Character.valueOf(c))) != null) {
                g.setColor(color);
            }
            g.drawChars(new char[]{c}, 0, 1, p + offset, y);
        }
        y += 5;
        alt = aaStartIdx % 2 == 0;
        for (aaIdx = aaStartIdx; aaIdx < aaEndIdx; ++aaIdx) {
            nucIdx = aaIdx * 3 + 2;
            this.drawFrame(g, fm, y, nucIdx--, Strand.NEGATIVE, alt);
            this.drawFrame(g, fm, y + 18, nucIdx--, Strand.NEGATIVE, alt);
            if (this.drawFrame(g, fm, y + 36, nucIdx, Strand.NEGATIVE, alt)) break;
            alt = !alt;
        }
    }

    private boolean drawFrame(Graphics g, FontMetrics fm, int aaY, int nucIdx, Strand strand, boolean alt) {
        byte[] sequence = strand == Strand.POSITIVE ? this.model.getSequence() : this.model.getComplementSequence();
        String codon = new String(sequence, nucIdx, 3);
        if (strand == Strand.NEGATIVE) {
            codon = new StringBuilder(codon).reverse().toString();
        }
        AminoAcid aa = Utils.getAminoAcid(codon);
        int aaStartPixel = (int)(((double)(this.model.getSeqStart() + nucIdx) - this.model.getOrigin()) / this.model.getScale());
        int aaEndPixel = (int)(((double)(this.model.getSeqStart() + nucIdx + 3) - this.model.getOrigin()) / this.model.getScale());
        if (this.colorMethionines && aa.getSymbol() == 'M') {
            g.setColor(METHIONINE_COLOR);
        } else if (this.colorMethionines && aa.getSymbol() == '*') {
            g.setColor(STOP_CODON_COLOR);
        } else {
            g.setColor(alt ? AA_COLOR_1 : AA_COLOR_2);
        }
        g.fillRect(aaStartPixel, aaY, aaEndPixel - aaStartPixel, 18);
        int cw = fm.charWidth(aa.getSymbol());
        int offset = (aaEndPixel - aaStartPixel - cw) / 2;
        g.setColor(AA_FONT_COLOR);
        g.drawChars(new char[]{aa.getSymbol()}, 0, 1, aaStartPixel + offset, aaY + 18 - 4);
        return aaStartPixel > this.getWidth();
    }

    public void setColorNucelotides(boolean colorNucelotides) {
        this.colorNucelotides = colorNucelotides;
        this.repaint();
    }

    public void setColorMethionines(boolean colorMethionines) {
        this.colorMethionines = colorMethionines;
        this.repaint();
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), new Color(0, 150, 0));
        nucleotideColors.put(Character.valueOf('a'), new Color(0, 150, 0));
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('g'), new Color(209, 113, 5));
        nucleotideColors.put(Character.valueOf('N'), Color.gray);
        nucleotideColors.put(Character.valueOf('n'), Color.gray);
        AA_COLOR_1 = new Color(128, 128, 128);
        AA_COLOR_2 = new Color(170, 170, 170);
        AA_FONT_COLOR = Color.WHITE;
        STOP_CODON_COLOR = Color.RED;
        METHIONINE_COLOR = Color.GREEN;
        NUCLEOTIDE_SEPARATOR_COLOR = new Color(150, 150, 150, 120);
    }
}

