/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.edx;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.broad.igv.edx.EdxApplet;
import org.broad.igv.edx.EdxModel;
import org.broad.igv.edx.Gene;
import org.broad.igv.edx.Strand;

class GenePanel
extends Panel {
    EdxApplet applet;
    EdxModel model;
    int utrHeight = 6;
    int cdHeight = 14;
    private double scale;
    int[] exonPixelStartPositions;
    Rectangle[] exonRectangles;
    private int intronSampleLength = 50;
    private int exonGap = 7;
    private int horizontalInset = 50;
    private static final int PROMOTER_INDICATOR_HEIGHT = 40;
    private static final int PROMOTER_INDICATOR_WIDTH = 20;
    private static final int PROMOTER_ARROW_WIDTH = 10;
    private static final int PROMOTER_ARROW_HEIGHT = 10;

    public GenePanel(EdxApplet applet, EdxModel model) {
        this.applet = applet;
        this.model = model;
        this.layoutGene();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EdxModel model = GenePanel.this.model;
                Gene.Exon[] exons = model.getGene().getExons();
                int intronPixelWidth = (int)((double)GenePanel.this.intronSampleLength / GenePanel.this.scale);
                int x = e.getX();
                for (int i = 0; i < GenePanel.this.exonPixelStartPositions.length; ++i) {
                    int pixelStart = GenePanel.this.exonPixelStartPositions[i] - intronPixelWidth;
                    int pixelEnd = GenePanel.this.exonPixelStartPositions[i] + (int)((double)(exons[i].getLength() + GenePanel.this.intronSampleLength) / GenePanel.this.scale);
                    if (x < pixelStart || x > pixelEnd) continue;
                    double bpX = (double)exons[i].getStart() + (double)(x - GenePanel.this.exonPixelStartPositions[i]) * GenePanel.this.scale;
                    model.setOrigin(bpX - (double)GenePanel.this.applet.getPixelWidth() * model.getScale() / 2.0);
                    GenePanel.this.applet.updatePanels();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    void layoutGene() {
        if (this.model.getGene() == null) {
            return;
        }
        Gene.Exon[] exons = this.model.getGene().getExons();
        int n = exons.length;
        int bp = 0;
        for (Gene.Exon ex : exons) {
            bp += ex.getLength();
        }
        int pixels = this.applet.getPixelWidth() - (n - 1) * this.exonGap - 2 * this.horizontalInset;
        this.scale = (double)(bp += (n - 1) * (2 * this.intronSampleLength)) / (double)pixels;
        this.exonPixelStartPositions = new int[exons.length];
        this.exonPixelStartPositions[0] = this.horizontalInset;
        for (int i = 1; i < exons.length; ++i) {
            this.exonPixelStartPositions[i] = this.exonPixelStartPositions[i - 1] + (int)((double)(exons[i - 1].getLength() + 2 * this.intronSampleLength) / this.scale) + this.exonGap;
        }
        int h = this.getHeight();
        int intronPixelLength = (int)((double)this.intronSampleLength / this.scale);
        this.exonRectangles = new Rectangle[exons.length];
        for (int i = 0; i < exons.length; ++i) {
            int rectStart = this.exonPixelStartPositions[i] - intronPixelLength;
            int rectEnd = this.exonPixelStartPositions[i] + intronPixelLength;
            this.exonRectangles[i] = new Rectangle(rectStart, 0, rectEnd, h);
        }
    }

    @Override
    public void paint(Graphics g) {
        boolean reverse;
        super.paint(g);
        if (this.model.getGene() == null) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int centerY = 70;
        g.setColor(Color.blue);
        int cdStart = this.model.getGene().getCdStart();
        int cdEnd = this.model.getGene().getCdEnd();
        Gene.Exon[] exons = this.model.getGene().getExons();
        int lastPixelEnd = -1;
        for (int i = 0; i < exons.length; ++i) {
            Gene.Exon exon = exons[i];
            int pixelStart = this.exonPixelStartPositions[i];
            int pixelEnd = pixelStart + (int)((double)exon.getLength() / this.scale);
            if (i > 0) {
                int leftIntonPixelStart = pixelStart - (int)((double)this.intronSampleLength / this.scale);
                g.drawLine(leftIntonPixelStart, centerY, pixelStart, centerY);
                g.drawLine(leftIntonPixelStart - 3, centerY - 3, leftIntonPixelStart + 3, centerY + 3);
            }
            if (i < exons.length - 1) {
                int rightIntronPixelEnd = pixelEnd + (int)((double)this.intronSampleLength / this.scale);
                g.drawLine(pixelEnd, centerY, rightIntronPixelEnd, centerY);
                g.drawLine(rightIntronPixelEnd - 3, centerY - 3, rightIntronPixelEnd + 3, centerY + 3);
            }
            if (i == exons.length - 1) {
                lastPixelEnd = pixelEnd;
            }
            if (cdStart > exon.getStart()) {
                int e = Math.min(exon.getEnd(), cdStart);
                int pw = (int)((double)(e - exon.getStart()) / this.scale);
                g.fillRect(pixelStart, centerY - this.utrHeight / 2, pw, this.utrHeight);
                pixelStart += pw;
            } else if (cdEnd < exon.getEnd()) {
                int s = Math.max(exon.getStart(), cdEnd);
                int ps = this.exonPixelStartPositions[i] + (int)((double)(s - exon.getStart()) / this.scale);
                g.fillRect(ps, centerY - this.utrHeight / 2, pixelEnd - ps, this.utrHeight);
                pixelEnd = ps;
            }
            if (pixelEnd <= pixelStart) continue;
            g.fillRect(pixelStart, centerY - this.cdHeight / 2, pixelEnd - pixelStart, this.cdHeight);
        }
        int p0 = this.getPixelPosition(exons, this.model.getOrigin());
        double seqEnd = this.model.getOrigin() + (double)this.applet.getPixelWidth() * this.model.getScale();
        int p1 = this.getPixelPosition(exons, seqEnd);
        g.setColor(Color.gray);
        g.drawLine(p0, centerY + this.cdHeight - 5, p0, centerY + this.cdHeight);
        g.drawLine(0, this.getHeight(), p0, centerY + this.cdHeight);
        g.drawLine(p1, centerY + this.cdHeight - 5, p1, centerY + this.cdHeight);
        g.drawLine(this.getWidth(), this.getHeight(), p1, centerY + this.cdHeight);
        int xBase = this.exonPixelStartPositions[0] - 10;
        boolean bl = reverse = this.model.getGene().strand == Strand.NEGATIVE;
        if (reverse) {
            xBase = lastPixelEnd + 10;
            if (lastPixelEnd < 0) {
                System.out.println("lastPixelEnd not set, must have no exons");
            }
        }
        this.drawPromoterArrow((Graphics2D)g, xBase, centerY, reverse);
    }

    private int getPixelPosition(Gene.Exon[] exons, double genomicPosition) {
        if (genomicPosition < (double)exons[0].getStart()) {
            return this.exonPixelStartPositions[0] + (int)((genomicPosition - (double)exons[0].getStart()) / this.scale);
        }
        for (int i = 0; i < exons.length; ++i) {
            int eStart = exons[i].getStart() - this.intronSampleLength;
            int eEnd = exons[i].getEnd() + this.intronSampleLength;
            if (i > 0 && genomicPosition < (double)eStart) {
                int eEndLast = exons[i - 1].getEnd() + this.intronSampleLength;
                double p0 = (double)this.exonPixelStartPositions[i - 1] + (double)(eEndLast - exons[i - 1].getStart()) / this.scale;
                double p1 = (double)this.exonPixelStartPositions[i] + (double)(eStart - exons[i].getStart()) / this.scale;
                return (int)(p0 + (genomicPosition - (double)eEndLast) / (double)(eStart - eEndLast) * (p1 - p0));
            }
            if (!(genomicPosition >= (double)eStart) || !(genomicPosition <= (double)eEnd)) continue;
            return this.exonPixelStartPositions[i] + (int)((genomicPosition - (double)exons[i].getStart()) / this.scale);
        }
        int lastIdx = this.exonPixelStartPositions.length - 1;
        return this.exonPixelStartPositions[lastIdx] + (int)((genomicPosition - (double)exons[lastIdx].getStart()) / this.scale);
    }

    private void drawPromoterArrow(Graphics2D inputG, int xBase, int yBase, boolean reverse) {
        Graphics2D g = (Graphics2D)inputG.create();
        g.translate(xBase, yBase);
        if (reverse) {
            g.scale(-1.0, 1.0);
        }
        g.setColor(Color.BLACK);
        int pih = -40;
        g.drawLine(0, 0, 0, pih);
        g.drawLine(0, pih, 20, pih);
        Polygon arrowHead = new Polygon();
        int xArrowFloor = 10;
        arrowHead.addPoint(xArrowFloor, pih + 5);
        arrowHead.addPoint(20, pih);
        arrowHead.addPoint(xArrowFloor, pih - 5);
        g.fillPolygon(arrowHead);
    }
}

