/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.edx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.broad.igv.edx.EdxApplet;
import org.broad.igv.edx.Gene;
import org.broad.igv.edx.Strand;
import org.broad.igv.edx.Utils;

public class EdxModel {
    private Gene gene;
    private int seqStart;
    private byte[] sequence;
    private byte[] complementSequence;
    private double origin;
    private double scale = 0.06666666666666667;

    public EdxModel(String geneName) {
        this.read(geneName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String geneName) {
        try {
            int i;
            InputStream is = EdxApplet.class.getResourceAsStream(geneName + ".txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            br.readLine();
            String[] tokens = br.readLine().split("\t");
            Strand strand = tokens[1].equals("+") ? Strand.POSITIVE : Strand.NEGATIVE;
            int start = Integer.parseInt(tokens[2]);
            int end = Integer.parseInt(tokens[3]);
            int cdStart = Integer.parseInt(tokens[4]);
            int cdEnd = Integer.parseInt(tokens[5]);
            int exonCount = Integer.parseInt(br.readLine().trim());
            Gene.Exon[] exons = new Gene.Exon[exonCount];
            for (i = 0; i < exonCount; ++i) {
                tokens = br.readLine().split("\t");
                int exStart = Integer.parseInt(tokens[0]);
                int exEnd = Integer.parseInt(tokens[1]);
                int frameShift = Integer.parseInt(tokens[2]);
                exons[i] = new Gene.Exon(exStart, exEnd, frameShift);
            }
            this.gene = new Gene(strand, start, end, cdStart, cdEnd, exons);
            br.readLine();
            this.seqStart = Integer.parseInt(br.readLine().trim());
            this.origin = this.gene.getCdStart();
            this.sequence = br.readLine().trim().getBytes();
            this.complementSequence = new byte[this.sequence.length];
            for (i = 0; i < this.sequence.length; ++i) {
                this.complementSequence[i] = Utils.complement(this.sequence[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSeqStart() {
        return this.seqStart;
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public byte[] getComplementSequence() {
        return this.complementSequence;
    }

    public Gene getGene() {
        return this.gene;
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getScale() {
        return this.scale;
    }

    public void setOrigin(double origin) {
        this.origin = origin;
    }
}

