/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.edx;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.broad.igv.edx.EdxModel;
import org.broad.igv.edx.GenePanel;
import org.broad.igv.edx.SequencePanel;

public class EdxApplet
extends Applet {
    private String geneName = "SRGN";
    private EdxModel model;
    private Panel contentPanel;
    private GenePanel genePanel;
    private SequencePanel sequencePanel;
    private Label headerLabel;
    private Checkbox colorNucleotidesCB;
    private Checkbox colorMethionineCB;
    private int pixelWidth;

    @Override
    public void init() {
        this.pixelWidth = this.getWidth();
        this.model = new EdxModel(this.geneName);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new Panel();
        this.contentPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.add((Component)this.contentPanel, "Center");
        this.genePanel = new GenePanel(this, this.model);
        this.contentPanel.add(this.genePanel);
        this.sequencePanel = new SequencePanel(this, this.model);
        this.contentPanel.add(this.sequencePanel);
        this.headerLabel = new Label();
        this.headerLabel.setText(this.geneName);
        this.headerLabel.setAlignment(1);
        this.add((Component)this.headerLabel, "North");
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        Label buttonPanelLabel = new Label("Buttons for demo/develoment only");
        buttonPanelLabel.setFont(new Font("Arial", 2, 12));
        buttonPanel.add(buttonPanelLabel);
        this.colorNucleotidesCB = new Checkbox("Color sequence");
        this.colorNucleotidesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EdxApplet.this.sequencePanel.setColorNucelotides(EdxApplet.this.colorNucleotidesCB.getState());
            }
        });
        this.sequencePanel.setColorNucelotides(true);
        this.colorNucleotidesCB.setState(true);
        buttonPanel.add(this.colorNucleotidesCB);
        this.colorMethionineCB = new Checkbox("Color methionines");
        this.colorMethionineCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EdxApplet.this.sequencePanel.setColorMethionines(EdxApplet.this.colorMethionineCB.getState());
            }
        });
        buttonPanel.add(this.colorMethionineCB);
        this.add((Component)buttonPanel, "South");
    }

    void updatePanels() {
        this.genePanel.repaint();
        this.sequencePanel.repaint();
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    static class ButtonPanel
    extends Panel {
        ButtonPanel() {
        }

        @Override
        public void paint(Graphics g) {
            g.drawLine(0, 0, this.getWidth(), 0);
            super.paint(g);
        }
    }
}

