# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-05-26 01:38
from __future__ import unicode_literals

from django.db import migrations, models
from oscar.core.loading import get_model


def migrate_sailthru_toggle(apps, schema_editor):
    SiteConfiguration = apps.get_model('core', 'SiteConfiguration')
    Partner = get_model('partner', 'Partner')

    for site_configuration in SiteConfiguration.objects.all():
        # Reload the Partner object using the forked model instead of Oscar's default
        partner = Partner.objects.get(pk=site_configuration.partner.pk)

        site_configuration.enable_sailthru = partner.enable_sailthru
        site_configuration.save()


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0030_auto_20170525_2134'),
    ]

    operations = [
        migrations.AddField(
            model_name='siteconfiguration',
            name='enable_sailthru',
            field=models.BooleanField(
                default=False,
                help_text='Determines if purchases should be reported to Sailthru.',
                verbose_name='Enable Sailthru Reporting'
            )
        ),
        migrations.RunPython(migrate_sailthru_toggle, migrations.RunPython.noop),
    ]
