define([
        'backbone'
    ],
    function (Backbone) {
        'use strict';

        return {
            /**
             * Returns a Backbone model that can be used to test validation.
             *
             * @param {Boolean} valid - Indicates if the model should pass or fail validation.
             */
            getModelForValidation: function (valid) {
                return Backbone.Model.extend({
                    isValid: function () {
                        return valid;
                    },

                    validate: function () {
                        if (valid) {
                            return {};
                        }

                        return {error: 'Test model: validate always fails.'};
                    }
                });
            }
        };
    }
);
