# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-06-06 09:35
from __future__ import unicode_literals

from django.db import migrations
from ecommerce.extensions.order.constants import ORDER_LIST_VIEW_SWITCH


def create_switch(apps, schema_editor):
    """Create the `enable_order_list_view` switch if it does not already exist."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.update_or_create(name=ORDER_LIST_VIEW_SWITCH, defaults={'active': True})


def delete_switch(apps, schema_editor):
    """Delete the `enable_order_list_view` switch."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.filter(name=ORDER_LIST_VIEW_SWITCH).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0013_auto_20170215_2229'),
    ]

    operations = [
        migrations.RunPython(create_switch, delete_switch),
    ]
