# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-05-25 05:31
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models

from ecommerce.core.constants import SEAT_PRODUCT_CLASS_NAME


def add_site_to_courses(apps, schema_editor):
    Course = apps.get_model('courses', 'Course')

    for course in Course.objects.all():
        parent_seat = course.products.get(product_class__name=SEAT_PRODUCT_CLASS_NAME, structure='parent')
        course.site = parent_seat.children.first().stockrecords.first().partner.siteconfiguration.site
        course.save()


class Migration(migrations.Migration):
    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('courses', '0004_auto_20150803_1406'),
    ]

    operations = [
        migrations.AddField(
            model_name='course',
            name='site',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='sites.Site', verbose_name='Site'),
        ),
        migrations.AddField(
            model_name='historicalcourse',
            name='site',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True,
                                    on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.Site'),
        ),
        migrations.RunPython(add_site_to_courses, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='course',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='sites.Site', verbose_name='Site'),
        ),
    ]
