# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-05-10 12:29
from __future__ import unicode_literals

import django.db.models.deletion
from django.db import migrations, models


def add_default_site_to_partners(apps, schema_editor):
    Partner = apps.get_model('partner', 'Partner')

    for partner in Partner.objects.all():
        if hasattr(partner, 'siteconfiguration'):
            partner.default_site = partner.siteconfiguration.site
            partner.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('partner', '0012_auto_20180119_0903'),
    ]

    operations = [
        migrations.AddField(
            model_name='partner',
            name='default_site',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='sites.Site'),
        ),
        migrations.RunPython(add_default_site_to_partners, migrations.RunPython.noop)
    ]
