# Working with AJAX and CSRF

> "Take a close look at possible CSRF / XSRF vulnerabilities on your own websites. They're the worst kind of vulnerability -- very easy to exploit by attackers, yet not so intuitively easy to understand for software developers, at least until you've been bitten by one."
>
>  &mdash; [Jeff Atwood][cite]

* Explain need to add CSRF token to AJAX requests.
* Explain deferred CSRF style used by REST framework
* Why you should use Django's standard login/logout views, and not REST framework view


[cite]: http://www.codinghorror.com/blog/2008/10/preventing-csrf-and-xsrf-attacks.html
