# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-06-18 16:47
from __future__ import unicode_literals
import uuid

import django.db.models.deletion
import django_extensions.db.fields
import djchoices.choices

from django.db import migrations, models


class Migration(migrations.Migration):

    replaces = [('journal', '0001_initial'), ('journal', '0002_auto_20180322_1823'), ('journal', '0003_auto_20180322_1827'), ('journal', '0004_journalbundle_partner'), ('journal', '0005_auto_20180329_2009'), ('journal', '0006_auto_20180402_2100'), ('journal', '0007_journalbundle_applicable_seat_types'), ('journal', '0006_auto_20180403_1927'), ('journal', '0008_merge_20180405_1200'), ('journal', '0009_auto_20180405_1203'), ('journal', '0010_journal_status'), ('journal', '0011_journal_slug'), ('journal', '0012_auto_20180618_1646')]

    initial = True

    dependencies = [
        ('core', '0007_auto_20171004_1133'),
        ('course_metadata', '0080_seat_bulk_sku'),
        ('course_metadata', '0081_auto_20180329_0718'),
        ('course_metadata', '0079_enable_program_default_true'),
    ]

    operations = [
        migrations.CreateModel(
            name='Journal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='UUID')),
                ('title', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('price', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('sku', models.CharField(blank=True, max_length=128, null=True)),
                ('expires', models.DateTimeField(blank=True, null=True)),
                ('currency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Currency')),
                ('partner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Partner')),
            ],
            options={
                'abstract': False,
                'get_latest_by': 'modified',
                'ordering': ('-modified', '-created'),
            },
        ),
        migrations.CreateModel(
            name='JournalBundle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='UUID')),
                ('title', models.CharField(help_text='The user-facing display title for this Journal Bundle', max_length=255, unique=True)),
                ('courses', models.ManyToManyField(blank=True, to='course_metadata.Course')),
                ('journals', models.ManyToManyField(blank=True, to='journal.Journal')),
                ('partner', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='core.Partner')),
                ('applicable_seat_types', models.ManyToManyField(blank=True, to='course_metadata.SeatType')),
            ],
            options={
                'abstract': False,
                'get_latest_by': 'modified',
                'ordering': ('-modified', '-created'),
            },
        ),
        migrations.RemoveField(
            model_name='journal',
            name='expires',
        ),
        migrations.AddField(
            model_name='journal',
            name='access_length',
            field=models.IntegerField(default=365, help_text='number of days valid after purchase', null=True),
        ),
        migrations.AddField(
            model_name='journal',
            name='card_image_url',
            field=models.URLField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='journal',
            name='full_description',
            field=models.TextField(blank=True, default=None, null=True),
        ),
        migrations.AddField(
            model_name='journal',
            name='organization',
            field=models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='course_metadata.Organization'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='journal',
            name='short_description',
            field=models.CharField(default=None, max_length=350),
        ),
        migrations.AlterUniqueTogether(
            name='journal',
            unique_together=set([('partner', 'uuid')]),
        ),
        migrations.AlterModelOptions(
            name='journal',
            options={'ordering': ('created',)},
        ),
        migrations.AlterField(
            model_name='journal',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, verbose_name='UUID'),
        ),
        migrations.AlterField(
            model_name='journal',
            name='uuid',
            field=models.UUIDField(verbose_name='UUID'),
        ),
        migrations.AddField(
            model_name='journal',
            name='status',
            field=models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive'), ('retired', 'Retired')], db_index=True, default='active', help_text='Used to determine whether journal is marketed or not.', max_length=24, validators=[djchoices.choices.ChoicesValidator({'active': 'Active', 'inactive': 'Inactive', 'retired': 'Retired'})]),
        ),
        migrations.AddField(
            model_name='journal',
            name='slug',
            field=models.CharField(default='', max_length=255),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name='journal',
            unique_together=set([]),
        ),
    ]
