# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-11-03 22:04
from __future__ import unicode_literals

import django.contrib.auth.models
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_extensions.db.fields
import pycountry
from django.conf import settings
from django.db import migrations, models


def add_currencies(apps, schema_editor):
    """ Populates the currency table.

    Data is pulled from pycountry. X currencies are not included given their limited use, and a desire
    to limit the size of the options displayed in Django admin.
    """
    Currency = apps.get_model('core', 'Currency')
    Currency.objects.bulk_create(
        [Currency(code=currency.letter, name=currency.name) for currency in pycountry.currencies if
            not currency.letter.startswith('X')]
    )


def remove_currencies(apps, schema_editor):
    """ Deletes all rows in the currency table. """
    Currency = apps.get_model('core', 'Currency')
    Currency.objects.all().delete()

class Migration(migrations.Migration):

    replaces = [('core', '0001_initial'), ('core', '0002_userthrottlerate'), ('core', '0003_auto_20160315_1910'), ('core', '0004_currency'), ('core', '0005_populate_currencies'), ('core', '0006_user_referral_tracking_id'), ('core', '0007_auto_20160510_2017'), ('core', '0008_partner'), ('core', '0009_auto_20160730_2131'), ('core', '0010_auto_20160731_0023'), ('core', '0011_auto_20161101_2207')]

    initial = True

    dependencies = [
        ('auth', '0006_require_contenttypes_0002'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=30, unique=True, validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.')], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('full_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Full Name')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
                ('referral_tracking_id', models.CharField(default='affiliate_partner', max_length=255, verbose_name='Referral Tracking ID')),
            ],
            options={
                'get_latest_by': 'date_joined',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='UserThrottleRate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rate', models.CharField(help_text='The rate of requests to limit this user to. The format is specified by Django Rest Framework (see http://www.django-rest-framework.org/api-guide/throttling/).', max_length=50)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('code', models.CharField(max_length=6, primary_key=True, serialize=False, unique=True)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name_plural': 'Currencies',
            },
        ),
        migrations.RunPython(
            code=add_currencies,
            reverse_code=remove_currencies,
        ),
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('short_code', models.CharField(help_text='Convenient code/slug used to identify this Partner (e.g. for management commands.)', max_length=8, unique=True, verbose_name='Short Code')),
                ('courses_api_url', models.URLField(blank=True, max_length=255, null=True, verbose_name='Courses API URL')),
                ('ecommerce_api_url', models.URLField(blank=True, max_length=255, null=True, verbose_name='E-Commerce API URL')),
                ('organizations_api_url', models.URLField(blank=True, max_length=255, null=True, verbose_name='Organizations API URL')),
                ('programs_api_url', models.URLField(blank=True, max_length=255, null=True, verbose_name='Programs API URL')),
                ('marketing_site_api_url', models.URLField(blank=True, max_length=255, null=True, verbose_name='Marketing Site API URL')),
                ('marketing_site_url_root', models.URLField(blank=True, max_length=255, null=True, verbose_name='Marketing Site URL')),
                ('oidc_url_root', models.CharField(max_length=255, null=True, verbose_name='OpenID Connect URL')),
                ('oidc_key', models.CharField(max_length=255, null=True, verbose_name='OpenID Connect Key')),
                ('oidc_secret', models.CharField(max_length=255, null=True, verbose_name='OpenID Connect Secret')),
                ('marketing_site_api_password', models.CharField(blank=True, max_length=255, null=True, verbose_name='Marketing Site API Password')),
                ('marketing_site_api_username', models.CharField(blank=True, max_length=255, null=True, verbose_name='Marketing Site API Username')),
            ],
            options={
                'verbose_name_plural': 'Partners',
                'verbose_name': 'Partner',
            },
        ),
    ]
