# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2017-01-26 15:10
from __future__ import unicode_literals

from django.db import migrations

def add_enrollable_paid_seat_boosting(apps, schema_editor):
    """Add enrollable paid Seat boosting function to ElasticsearchBoostConfig instance."""

    # Get the model from the versioned app registry to ensure the correct version is used, as described in
    # https://docs.djangoproject.com/en/1.8/ref/migration-operations/#runpython
    ElasticsearchBoostConfig = apps.get_model('edx_haystack_extensions', 'ElasticsearchBoostConfig')
    ElasticsearchBoostConfig.objects.update_or_create(
        # The `solo` library uses 1 for the PrimaryKey to create/lookup the singleton record
        # See https://github.com/lazybird/django-solo/blob/1.1.2/solo/models.py
        pk=1,
        defaults={
            'function_score': {
                'boost_mode': 'sum',
                'boost': 1.0,
                'score_mode': 'sum',
                'functions': [
                    {'filter': {'term': {'pacing_type_exact': 'self_paced'}}, 'weight': 1.0},
                    {'filter': {'term': {'type_exact': 'Professional Certificate'}}, 'weight': 1.0},
                    {'filter': {'term': {'type_exact': 'MicroMasters'}}, 'weight': 1.0},
                    {'linear': {'start': {'origin': 'now', 'decay': 0.95, 'scale': '1d'}}, 'weight': 5.0},

                    # Boost function for CourseRuns with enrollable paid Seats.
                    # We want to boost if:
                    #       - The course run has at least one enrollable paid Seat (has_enrollable_paid_seats is True)
                    # AND one of the following two conditions are true
                    #       - The paid_seat_enrollment_end is unspecified.
                    #       - The paid_seat_enrollment_end is in the future.
                    # We apply a weight of 1.0 to match the boost given for self paced courses.
                    {
                        'filter': {
                            'bool': {
                                'must': [
                                    {'exists': {'field': 'has_enrollable_paid_seats'}},
                                    {'term': {'has_enrollable_paid_seats': True}}
                                ],
                                'should': [
                                    {'bool': {'must_not': { 'exists': {'field': 'paid_seat_enrollment_end'}}}},
                                    {'range': {'paid_seat_enrollment_end': {'gte': 'now'}}}
                                ]
                            }
                        },
                        'weight': 1.0
                    }
                ]
            }
        }
    )


class Migration(migrations.Migration):

    dependencies = [
        ('edx_haystack_extensions', '0003_auto_20170124_1834'),
    ]

    operations = [
        migrations.RunPython(add_enrollable_paid_seat_boosting, migrations.RunPython.noop)
    ]
