# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2017-01-24 18:34
from __future__ import unicode_literals

from django.db import migrations

def add_professional_certificate_boosting(apps, schema_editor):
    """ Update ElasticsearchBoostConfig to include professional certificate boosting."""

    # Get the model from the versioned app registry to ensure the correct version is used, as described in
    # https://docs.djangoproject.com/en/1.8/ref/migration-operations/#runpython
    ElasticsearchBoostConfig = apps.get_model('edx_haystack_extensions', 'ElasticsearchBoostConfig')
    ElasticsearchBoostConfig.objects.update_or_create(
        # The `solo` library uses 1 for the PrimaryKey to create/lookup the singleton record
        # See https://github.com/lazybird/django-solo/blob/1.1.2/solo/models.py
        pk=1,
        defaults={
            'function_score': {
                'boost_mode': 'sum',
                'boost': 1.0,
                'score_mode': 'sum',
                'functions': [
                    {'filter': {'term': {'pacing_type_exact': 'self_paced'}}, 'weight': 1.0},
                    {'filter': {'term': {'type_exact': 'Professional Certificate'}}, 'weight': 1.0},
                    {'filter': {'term': {'type_exact': 'MicroMasters'}}, 'weight': 1.0},
                    {'linear': {'start': {'origin': 'now', 'decay': 0.95, 'scale': '1d'}}, 'weight': 5.0}
                ]
            }
        }
    )

class Migration(migrations.Migration):

    dependencies = [
        ('edx_haystack_extensions', '0002_auto_20170118_1826'),
    ]

    operations = [
        migrations.RunPython(add_professional_certificate_boosting, migrations.RunPython.noop)
    ]
