# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-11-29 09:10
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields


class Migration(migrations.Migration):

    dependencies = [
        ('course_metadata', '0038_seat_sku'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('publisher', '0015_auto_20161117_1210'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalOrganizationUserRole',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('role', models.CharField(choices=[('partner_coordinator', 'Partner Coordinator'), ('marketing_reviewer', 'Reviewer'), ('publisher', 'Publisher')], max_length=63, verbose_name='Role Type')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('organization', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='course_metadata.Organization')),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'verbose_name': 'historical organization user role',
            },
        ),
        migrations.CreateModel(
            name='OrganizationUserRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('role', models.CharField(choices=[('partner_coordinator', 'Partner Coordinator'), ('marketing_reviewer', 'Reviewer'), ('publisher', 'Publisher')], max_length=63, verbose_name='Role Type')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_roles', to='course_metadata.Organization')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='organization_user_roles', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='organizationuserrole',
            unique_together=set([('organization', 'user', 'role')]),
        ),
    ]
