# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-06-20 13:51
from __future__ import unicode_literals

from django.db import migrations


def create_switch(apps, schema_editor):
    """Create the log_course_search_queries switch if it does not already exist."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.get_or_create(name='log_course_search_queries', defaults={'active': False})


def delete_switch(apps, schema_editor):
    """Delete the log_course_search_queries switch."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.filter(name='log_course_search_queries').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('course_metadata', '0055_program_hidden'),
        ('waffle', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_switch, delete_switch),
    ]
