# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-06-05 09:53
from __future__ import unicode_literals

from django.db import migrations

from course_discovery.apps.publisher.constants import GENERAL_STAFF_GROUP_NAME, PARTNER_SUPPORT_GROUP_NAME

GROUPS = [GENERAL_STAFF_GROUP_NAME, PARTNER_SUPPORT_GROUP_NAME]


def create_groups(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')

    for group in GROUPS:
        Group.objects.get_or_create(name=group)


def remove_groups(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')

    for group in GROUPS:
        Group.objects.filter(name=group).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('publisher', '0053_auto_20170604_1502'),
    ]

    operations = [
        migrations.RunPython(create_groups, remove_groups)
    ]
