# -*- coding: utf-8 -*-
# Generated by Django 1.9.10 on 2016-11-03 22:15
from __future__ import unicode_literals

from django.db import migrations

PAID_SEAT_TYPES = ('credit', 'professional', 'verified',)
PROGRAM_TYPES = ('XSeries', 'MicroMasters',)


def add_program_types(apps, schema_editor):
    SeatType = apps.get_model('course_metadata', 'SeatType')
    ProgramType = apps.get_model('course_metadata', 'ProgramType')

    seat_types = SeatType.objects.filter(slug__in=PAID_SEAT_TYPES)

    for name in PROGRAM_TYPES:
        program_type, __ = ProgramType.objects.update_or_create(name=name)
        program_type.applicable_seat_types.clear()
        program_type.applicable_seat_types.add(*seat_types)
        program_type.save()


def drop_program_types(apps, schema_editor):
    ProgramType = apps.get_model('course_metadata', 'ProgramType')
    ProgramType.objects.filter(name__in=PROGRAM_TYPES).delete()


def create_switch(apps, schema_editor):
    """Create and activate the publish_program_to_marketing_site switch if it does not already exist."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.get_or_create(name='publish_program_to_marketing_site', defaults={'active': False})


def delete_switch(apps, schema_editor):
    """Delete the publish_program_to_marketing_site switch."""
    Switch = apps.get_model('waffle', 'Switch')
    Switch.objects.filter(name='publish_program_to_marketing_site').delete()


class Migration(migrations.Migration):

    replaces = [('edx_catalog_extensions', '0001_create_program_types'), ('edx_catalog_extensions', '0002_convert_program_category_to_type'), ('edx_catalog_extensions', '0003_create_publish_to_marketing_site_flag')]

    initial = True

    dependencies = [
        ('waffle', '0001_initial'),
        ('course_metadata', '0001_squashed_0033_courserun_mobile_available'),
    ]

    operations = [
        migrations.RunPython(
            code=add_program_types,
            reverse_code=drop_program_types,
        ),
        migrations.RunPython(
            code=create_switch,
            reverse_code=delete_switch,
        ),
    ]
