# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-05-05 02:32
from __future__ import unicode_literals

import django_extensions.db.fields
from django.db import migrations
from django.db.models import Q
from django.template.defaultfilters import slugify


def update_slugs(apps, schema_editor):
    ProgramType = apps.get_model('course_metadata', 'ProgramType')

    for program_type in ProgramType.objects.filter(Q(slug='') | Q(slug__isnull=True)):
        program_type.slug = slugify(program_type.name)
        program_type.save()


class Migration(migrations.Migration):
    dependencies = [
        ('course_metadata', '0053_person_email'),
    ]

    operations = [
        migrations.RunPython(update_slugs, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='programtype',
            name='slug',
            field=django_extensions.db.fields.AutoSlugField(
                blank=True, editable=False,
                help_text='Leave this field blank to have the value generated automatically.',
                populate_from='name', unique=True),
        ),
    ]
