package com.orhon.notification.onservice;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.annotation.RequiresApi;
import android.util.Log;

import com.google.gson.Gson;
import com.orhon.SmartCloud.MainActivity;

import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class NotificationService extends Service {

    PowerManager.WakeLock wakeLock = null;

    // 获取电源锁，保持该服务在屏幕熄灭时仍然获取CPU时，保持运行
    @SuppressLint("InvalidWakeLockTag")
    private void acquireWakeLock() {
        if (null == wakeLock) {
            PowerManager pm = (PowerManager) this.getSystemService(Context.POWER_SERVICE);
            wakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, TAG);
            if (null != wakeLock) {
                wakeLock.acquire();
            }
        }
    }

    // 释放设备电源锁
    private void releaseWakeLock() {
        if (null != wakeLock) {
            wakeLock.release();
            wakeLock = null;
        }
    }

    /**
     * 以上为获取和释放电源锁
     */

    private Timer timer;
    private TimerTask timerTask;
    String CHANNEL_ONE_ID = "CHANNEL_ONE_ID";
    String CHANNEL_ONE_NAME = "CHANNEL_ONE_NAME";
    NotificationChannel notificationChannel = null;
    boolean flagRequest = true;
    int notificationId = 1;

    OkHttpClient client;
    OkHttpClient clientOffline;
    private long sendTime = 0L;
    private Handler mHandler = new Handler();
    private static final long HEART_BEAT_RATE = 2 * 1000;
    private WebSocket mSocket;
    Gson gson;
    // 发送心跳包
    private Runnable heartBeatRunnable = new Runnable() {
        @Override
        public void run() {
            if (System.currentTimeMillis() - sendTime >= HEART_BEAT_RATE) {
                // String message = "what's this";
                // mSocket.send(message);
                // sendTime = System.currentTimeMillis();
            }
            mHandler.postDelayed(this, HEART_BEAT_RATE); // 每隔一定的时间，对长连接进行一次心跳检测
        }
    };
    final String webSocket = "ws://messagesrv.dev.campus.orhonedu.com:31288";
    final String api = "https://www.edu.mongol.pub/api/messagesrv/messagePush/userUnread/%s";

    // ---------------------------------------------

    private static final String TAG = "NotificationService";

    // 17652
    private String userId;
    public static CordovaWebView webView;
    public static CordovaInterface cordovaPlugin;

    private Intent intent;

    public MyBinder binder = new MyBinder();

    public static BeanOffline offlineAll = new BeanOffline();  //  给前端返回的离线数据

    public static String getOfflineAll() {
        String res = new Gson().toJson(offlineAll);
        Log.e(TAG, "getOfflineAll: "+res );
        return res;
    }

    /**
     * 离线通知的查询完成 todo需要将通知封装个统一方法
     */
    // 接收结构体

    // BeanResult beanResult = new BeanResult();
    private void getMessageOffline() {
        Callback callback = new Callback() {
            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Log.e(TAG, "onFailure: ");
            }

            @RequiresApi(api = Build.VERSION_CODES.O)
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                String result = response.body().string();
                Log.e(TAG, "requestUrl: " + response.request().url());
                Log.e(TAG, "onResponse: " + result);
                // 获取到的结果的
                BeanOffline beanOffline = gson.fromJson(result, BeanOffline.class);
                if (beanOffline != null && beanOffline.list != null && !beanOffline.list.isEmpty()) {
                    //  发送通知
                    getNotification(beanOffline.list);
                    //  添入结构体中
                    for (BeanOffline.Content content : beanOffline.list) {
                        addOfflineBean(content);
                    }
                }
            }
        };

        clientOffline = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(String.format(api, userId)).build();

        if (null == timer) {
            timer = new Timer();
        }
        if (null == timerTask) {
            timerTask = new TimerTask() {
                @Override
                public void run() {
                    clientOffline.newCall(request).enqueue(callback);

                }
            };
        }
        timer.schedule(timerTask, 5000, 5000);

    }

    //  向gson结构体中添加对象
    private void addOfflineBean(BeanOffline.Content content) {
        if (null == offlineAll) {
            offlineAll = new BeanOffline();
        }
        offlineAll.list.add(content);
    }

    //  清空gson结构体
    public static void cleanOfflineBean() {
        if (null == offlineAll) {
            offlineAll = new BeanOffline();
        } else {
            offlineAll.list = new ArrayList<>();
        }
    }

    //  获取到了离线消息
    private void getNotification(List<BeanOffline.Content> contentList) {
        if (contentList == null) {
            Log.e(TAG, "getNotification: " + "content is null");
            return;
        }
        // 进行8.0的判断
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            // notificationChannel = new NotificationChannel(CHANNEL_ONE_ID,
            // CHANNEL_ONE_NAME, NotificationManager.IMPORTANCE_HIGH);
            // notificationChannel.enableLights(true);
            // notificationChannel.setLightColor(Color.RED);
            // notificationChannel.setShowBadge(true);
            // notificationChannel.setLockscreenVisibility(Notification.VISIBILITY_PUBLIC);
            NotificationManager manager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
            manager.createNotificationChannel(notificationChannel);
            for (BeanOffline.Content content : contentList) {
                Intent intentPending;
                intentPending = new Intent(this, HandleService.class);
                intentPending.putExtra("userId", userId);
                intentPending.putExtra("object", gson.toJson(content));

                PendingIntent pendingIntent = PendingIntent.getService(this, 0, intentPending,
                        PendingIntent.FLAG_CANCEL_CURRENT);
                int ic_launcher = getResources().getIdentifier("ic_launcher", "mipmap",
                        cordovaPlugin.getActivity().getPackageName());
                Notification notification = new Notification.Builder(this).setChannelId(CHANNEL_ONE_ID)
                        .setTicker("Nature").setSmallIcon(ic_launcher).setContentTitle(content.messageTitle)
                        .setContentIntent(pendingIntent).setContentText(content.body).setNumber(2).setAutoCancel(true)
                        .build();
                // notification.flags = Notification.FLAG_AUTO_CANCEL;
                // 是否允许清除通知
                // notification.flags |= Notification.FLAG_NO_CLEAR;
                cordovaPlugin.getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        webView.loadUrl("javascript:cordova.plugins.notification.badge.increase(1)");
                    }
                });
                manager.notify(Integer.parseInt(content.id), notification);
            }
        }
    }

    public class MyBinder extends Binder {
        public void setId(String idCard) {
            NotificationService.this.userId = idCard;
        }

        public void startForeGround() {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                startMyForeGroundService();
            }
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    public void startMyForeGroundService() {
        Intent intentPending;
        intentPending = new Intent(this, MainActivity.class);
        intentPending.putExtra("idCard", userId);
        PendingIntent pendingIntent = PendingIntent.getService(this, 1, intentPending, 0);
        int ic_launcher = getResources().getIdentifier("ic_launcher", "mipmap",
                cordovaPlugin.getActivity().getPackageName());
        Notification notification = new Notification.Builder(this, CHANNEL_ONE_ID).setTicker("Nature")
                .setSmallIcon(ic_launcher).setContentTitle("智慧校园通知服务").setContentIntent(pendingIntent)
                .setContentText("关闭此服务可能会影响通知接收").build();
        // 是否允许清除通知
        notification.flags |= Notification.FLAG_NO_CLEAR;
        NotificationManager manager = ((NotificationManager) getSystemService(NOTIFICATION_SERVICE));
        startForeground(1, notification);
    }

    @Override
    public void onCreate() {
        Log.e(TAG, "onCreate: ");
        super.onCreate();
        gson = new Gson();
        initNotificationChannel();
    }

    /**
     * 初始化NotificationChannel
     */
    private void initNotificationChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, CHANNEL_ONE_NAME,
                    NotificationManager.IMPORTANCE_HIGH);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(Color.RED);
            notificationChannel.setShowBadge(true);
            notificationChannel.setLockscreenVisibility(Notification.VISIBILITY_PUBLIC);
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public IBinder onBind(Intent intent) {

        Log.e(TAG, "onBind: ");
        NotificationService.this.userId = intent.getStringExtra("idCard");
        client = new OkHttpClient.Builder().readTimeout(3, TimeUnit.SECONDS).writeTimeout(3, TimeUnit.SECONDS)
                .connectTimeout(3, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(webSocket).build();

        mHandler.postDelayed(heartBeatRunnable, HEART_BEAT_RATE);
        client.newWebSocket(request, new WebSocketListener() {
            @Override
            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                super.onClosed(webSocket, code, reason);
                Log.e(TAG, "onClosed: 连接已关闭 ");
            }

            @Override
            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                super.onClosing(webSocket, code, reason);
                Log.e(TAG, "onClosing: 连接关闭中 ");
            }

            @Override
            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                super.onFailure(webSocket, t, response);
                Log.e(TAG, "onFailure:  连接失败 ");
            }

            @Override
            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                super.onMessage(webSocket, text);
                Log.e(TAG, "onMessage string: " + text);
            }

            @Override
            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                super.onMessage(webSocket, bytes);
                Log.e(TAG, "onMessage bytes: " + bytes);
            }

            @Override
            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                super.onOpen(webSocket, response);
                Log.e(TAG, "onOpen: webSocket 连接成功 ");
            }
        });
        client.dispatcher().executorService().shutdown();

        /**
         * 获取离线消息
         */
        getMessageOffline();
        return binder;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e(TAG, "onStartCommand: ");
        NotificationService.this.intent = intent;
        return Service.START_REDELIVER_INTENT;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        Log.e(TAG, "onUnbind ");
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
//            stopForeground(STOP_FOREGROUND_REMOVE);
        }
        timer.cancel();
        timer.purge();
        stopSelf();
        return super.onUnbind(intent);
    }

    public Service getNotificationService() {
        return this;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.e(TAG, "onDestroy: ");
    }

    class BeanResult {
        public List<Outer> outerList = new ArrayList<>();

        public class Outer {
            public String categoryName;
            public String messageCategory;
            public List<Child> children = new ArrayList<>();

            public class Child {
                public String id;
                public String messageTitle; // 通知标题
                public String messageType; // 类型
                public String body; // 内容
                public String routing;
            }
        }
    }

    public static class BeanOffline {
        public String msg;
        public String code;
        public List<Content> list = new ArrayList<>();

        public class Content {
            public String id;
            public String messageTitle;
            public String messageType;
            public String body;
            public String sendUser;
            public String acceptUser;
            public String sendTime;
            public String messagePushType;
            public String isPush;
            public String messageCategory;
            public String createTime;
            public String number;
            public String categoryName;
            public String isRead;
            // 一个json的string，需要自己解析其中的compont,和did属性并通过/连接后接到http://localhost/后面
            public String routing;
            public String photoUrl;
            public String icon;
        }
    }

    public class BeanRouting {
        public String compont;
        public String did;
    }

}
