package com.orhon.notification;


import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;

import com.orhon.notification.onservice.NotificationService;

import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CallbackContext;
import org.json.JSONArray;
import org.json.JSONException;

import java.util.List;

/**
 * This class echoes a string called from JavaScript.
 */
public class ONService extends CordovaPlugin {
    private static final String TAG = "ONService";
    private NotificationService.MyBinder myBinder;

    private ServiceConnection connection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            NotificationService.webView = webView;
            NotificationService.cordovaPlugin = cordova;
            myBinder = (NotificationService.MyBinder) iBinder;
//            myBinder.startForeGround();
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            //这里貌似不用写什么东西
            Log.e(TAG, "onServiceDisconnected");
        }
    };


    @Override
    public Boolean shouldAllowBridgeAccess(String url) {
        return true;
    }

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("coolMethod")) {
            String message = args.getString(0);
            this.coolMethod(message, callbackContext);
            return true;
        }

        if (action.endsWith("getMessage")) {
            callbackContext.success(NotificationService.getOfflineAll());
            NotificationService.cleanOfflineBean();
            return true;
        }

        //  开启并绑定服务并5秒间隔调取getHistory()
        if (action.equals("bindService")) {
            Intent intent = new Intent(cordova.getActivity(), NotificationService.class);
            try {
                intent.putExtra("idCard", args.getString(0));
            } catch (JSONException e) {
                e.printStackTrace();
            }
//            webView.loadUrl("http://localhost/tabs/tab3");
            cordova.getActivity().startService(intent);
            cordova.getActivity().bindService(
                    intent,
                    connection,
                    Service.BIND_AUTO_CREATE
            );
            callbackContext.success("服务开启成功");
            return true;
        }

        //  开始间隔调取getHistory()
        if (action.equals("startLoop")) {
            if (myBinder != null) {
                myBinder.startForeGround();
            }
        }

        //  接触activity与service的绑定(最好在退出时调用)
        if (action.equals("unbindService")) {
            cordova.getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (isServiceExisted(NotificationService.class.getName())) {
                        cordova.getActivity().unbindService(connection);
                    }
                }
            });
        }
        return false;
    }

    private void coolMethod(String message, CallbackContext callbackContext) {
        if (message != null && message.length() > 0) {
            callbackContext.success(message);
        } else {
            callbackContext.error("Expected one non-empty string argument.");
        }
    }

    public boolean isServiceExisted(String className) {
        ActivityManager am = (ActivityManager) cordova.getActivity().getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningServiceInfo> serviceList = am.getRunningServices(Integer.MAX_VALUE);
        int myUid = android.os.Process.myUid();
        for (ActivityManager.RunningServiceInfo runningServiceInfo : serviceList) {
            if (runningServiceInfo.uid == myUid && runningServiceInfo.service.getClassName().equals(className)) {
                return true;
            }
        }
        return false;
    }
}

