package com.orhon.notification.onservice;

import android.app.IntentService;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.util.Log;

import com.orhon.SmartCloudTest.MainActivity;

public class HandleService extends IntentService {
    private static final String TAG = "HandleService";

    public HandleService() {
        super("");
    }

    public HandleService(String name) {
        super(name);
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
//        Log.e(TAG, "onHandleIntent: userId "+ intent.getStringExtra("userId"));
//        Log.e(TAG, "onHandleIntent: schoolId "+ intent.getStringExtra("schoolId"));
        Log.e(TAG, "onHandleIntent: object " + intent.getStringExtra("object"));
//        NotificationService.webView.loadUrl(intent.getStringExtra("url"));
        NotificationService.cordovaPlugin.getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                NotificationService.webView.loadUrl(
                        String.format("javascript:socketIoService.isGotoRouter(%s,%s)",
                                intent.getStringExtra("object"),
                                NotificationService.getOfflineAll()));
                NotificationService.cleanOfflineBean();
            }
        });
    }

    @Override
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        NotificationService.cordovaPlugin.getActivity().startActivity(new Intent(NotificationService.cordovaPlugin.getContext(), MainActivity.class));
        NotificationService.cordovaPlugin.getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
//                 NotificationService.webView.loadUrl("javascript:cordova.plugins.notification.badge.decrease(1)");
            }
        });
//        Log.e(TAG, "onStartCommand: userId "+ intent.getStringExtra("userId"));
//        Log.e(TAG, "onStartCommand: schoolId "+ intent.getStringExtra("schoolId"));
//        Log.e(TAG, "onStartCommand: url " + intent.getStringExtra("url"));
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.e(TAG, "onDestroy: ");
    }
}
