/**
 *
 * cordova使用webview层。。。
 * 在这个层面不需要设置x5引擎的相关参数...
 *
 * 1、用于暴露init方法。
 * 2、暴露init的方法的目的可能是  X5WebViewEngine的init方法cordova层面去调用，在这个层面去进行webview的init
 *    init方法的其他作用是判断两个client是否为空，如果为空，初始化一个新的，复制进去
 * 3、暴露的其他办法有
 *    getCordovaWebView   用于从系统层面获取cordova的webview
 *
 *    一个webview有两个client，分别是webclient和chromewebclient
 *    setWebViewClient    给webview设置webviewclient
 *    setWebChromeClient  给webview设置webchromeclient
 */


package org.apache.cordova.x5engine;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;


public class X5WebView extends WebView implements CordovaWebViewEngine.EngineView {
    private X5WebViewClient viewClient;
    X5WebChromeClient chromeClient;
    private X5WebViewEngine parentEngine;
    private CordovaInterface cordova;

    public X5WebView(Context context) {
        this(context, null);
    }

    public X5WebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    // Package visibility to enforce that only X5WebViewEngine should call this method.
    void init(X5WebViewEngine parentEngine, CordovaInterface cordova) {
        this.cordova = cordova;
        this.parentEngine = parentEngine;
        if (this.viewClient == null) {
            setWebViewClient(new X5WebViewClient(parentEngine));
        }

        if (this.chromeClient == null) {
            setWebChromeClient(new X5WebChromeClient(parentEngine));
        }
    }


    void initWithLocalServer(X5WebViewEngine parentEngine,
                             CordovaInterface cordova ,
                             ConfigXmlParser parser,
                             X5WebViewLocalServer server,
                             String CDV_LOCAL_SERVER_REF){


        //init the webview with server

        this.cordova = cordova;
        this.parentEngine = parentEngine;
        if (this.viewClient == null){
            setWebViewClient(
                    new X5WebViewClient(
                            parentEngine ,
                            parser ,
                            server ,
                            CDV_LOCAL_SERVER_REF
                    )
            );
        }

        if (this.chromeClient == null) {
            setWebChromeClient(new X5WebChromeClient(parentEngine));
        }

    }

    @Override
    public CordovaWebView getCordovaWebView() {
        return parentEngine != null ? parentEngine.getCordovaWebView() : null;
    }

    @Override
    public void setWebViewClient(WebViewClient client) {
        viewClient = (X5WebViewClient)client;
        super.setWebViewClient(client);
    }

    @Override
    public void setWebChromeClient(WebChromeClient client) {
        chromeClient = (X5WebChromeClient)client;
        super.setWebChromeClient(client);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Boolean ret = parentEngine.client.onDispatchKeyEvent(event);
        if (ret != null) {
            return ret.booleanValue();
        }
        return super.dispatchKeyEvent(event);
    }
}
