import React from 'react';
import classNames from 'classnames';
import PropTypes from 'prop-types';

import styles from './Icon.scss';

function Icon(props) {
  return (
    <div>
      <span
        id={props.id}
        className={classNames(props.className)}
        aria-describedby={props.describedBy}
        aria-hidden={props.hidden}
      />
      { props.srText &&
        <span className={classNames(styles['sr-only'])}>
            {props.srText}
        </span>
      }
    </div>
  );
}

Icon.propTypes = {
  id: PropTypes.string.isRequired,
  className: PropTypes.arrayOf(PropTypes.string).isRequired,
  describedBy: PropTypes.string,
  hidden: PropTypes.bool,
  srText: PropTypes.string,
};

Icon.defaultProps = {
  describedBy: undefined,
  hidden: true,
  srText: undefined,
};

export default Icon;
