(function (tree) {

tree.Alpha = function (val) {
    this.value = val;
};
tree.Alpha.prototype = {
    type: "Alpha",
    accept: function (visitor) {
        this.value = visitor.visit(this.value);
    },
    eval: function (env) {
        if (this.value.eval) { return new tree.Alpha(this.value.eval(env)); }
        return this;
    },
    genCSS: function (env, output) {
        output.add("alpha(opacity=");

        if (this.value.genCSS) {
            this.value.genCSS(env, output);
        } else {
            output.add(this.value);
        }

        output.add(")");
    },
    toCSS: tree.toCSS
};

})(require('../tree'));
